package games.enchanted.eg_particle_interactions.common.config.screen.yacl.controller.generic;

import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.dropdown.AbstractDropdownController;
import dev.isxander.yacl3.gui.controllers.dropdown.AbstractDropdownControllerElement;
import games.enchanted.eg_particle_interactions.common.Constants;
import games.enchanted.eg_particle_interactions.common.mixin.mod_compat.yacl.accessor.DropdownWidgetAccessor;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_10799;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public abstract class GenericListControllerElement<T, R extends AbstractDropdownController<T>> extends AbstractDropdownControllerElement<T, T> {
    private static final class_2960 MISSING_ITEM_ICON_SPRITE = class_2960.method_60655(Constants.MOD_ID, "missing_item_icon");

    private final R controller;
    protected T currentItem = null;
    protected Map<class_2960, T> matchingItems = new HashMap<>();
    int lastKnownSelectedDropdownIndex = 0;

    public GenericListControllerElement(R control, YACLScreen screen, Dimension<Integer> dim) {
        super(control, screen, dim);
        this.controller = control;
    }

    public R getController() {
        return controller;
    }

    @Override
    protected void renderDropdownEntry(class_332 graphics, Dimension<Integer> entryDimension, T value) {
        super.renderDropdownEntry(graphics, entryDimension, value);
    }

    @Override
    protected void drawValueText(class_332 graphics, int mouseX, int mouseY, float delta) {
        var oldDimension = getDimension();
        setDimension(getDimension().withWidth(getDimension().width() - getDecorationPadding()));
        super.drawValueText(graphics, mouseX, mouseY, delta);
        setDimension(oldDimension);
        if (currentItem != null) {
            this.renderItemIcon(graphics, getItemToRender(currentItem), getDimension().xLimit() - getXPadding() - getDecorationPadding() + 2, getDimension().y() + 2);
        }
    }

    protected void renderItemIcon(class_332 graphics, class_1792 item, int x, int y) {
        if(item == null) return;;
        if(item == class_1802.field_8162) {
            graphics.method_52706(class_10799.field_56883, MISSING_ITEM_ICON_SPRITE, x, y, 16, 16);
            return;
        }
        graphics.method_51445(new class_1799(item), x, y);
    }

    @Override
    protected void drawHoveredControl(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.drawHoveredControl(graphics, mouseX, mouseY, delta);

        class_2561 text = this.getHoverTooltipText();
        if(text == null) return;
        Dimension<Integer> dimension = this.getDimension();

        graphics.method_51438(class_310.method_1551().field_1772, text, dimension.x(), dimension.y());
    }

    public @Nullable class_2561 getHoverTooltipText() {
        return class_2561.method_43470(this.getController().option().pendingValue().toString());
    }

    @Override
    //? if minecraft: > 1.21.8 {
    public boolean onCharTyped(char chr, String cpStr, int modifiers) {
    //?} else {
    /*public boolean charTyped(char chr, int modifiers) {
    *///?}
        if(this.dropdownWidget != null) {
            ((DropdownWidgetAccessor) this.dropdownWidget).block_place_particle$setFirstVisibleIndex(0);
            this.dropdownWidget.scrollUp();
        }
        //? if minecraft: > 1.21.8 {
        return super.onCharTyped(chr, cpStr, modifiers);
        //?} else {
        /*return super.charTyped(chr, modifiers);
        *///?}
    }

    @Override
    public String getString(T val) {
        return val.toString();
    }

    @Override
    protected int getDecorationPadding() {
        return 16;
    }

    @Override
    protected int getDropdownEntryPadding() {
        return 4;
    }

    @Override
    protected int getControlWidth() {
        return super.getControlWidth() + getDecorationPadding();
    }

    //? if minecraft: > 1.21.8 {
    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        return super.onMouseClicked(mouseX + this.getDecorationPadding(), mouseY, button);
    }
    //?} else {
    /*@Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX + this.getDecorationPadding(), mouseY, button);
    }
    *///?}

    public void setLastSelectedDropdownIndex(int index) {
        this.lastKnownSelectedDropdownIndex = index;
    }
    public int getLastSelectedDropdownIndex() {
        return this.lastKnownSelectedDropdownIndex;
    }

    @Override
    public void createDropdownWidget() {
        dropdownVisible = true;
        dropdownWidget = new FixedDropdownWidget<>(controller, screen, getDimension(), this);
        screen.addPopupControllerWidget(dropdownWidget);
    }

    @Override
    protected class_2561 getValueText() {
        if (inputField.isEmpty() || controller == null) {
            return super.getValueText();
        }

        if (inputFieldFocused) {
            return class_2561.method_43470(inputField);
        }

        return getRenderedValueText();
    }

    public abstract class_1792 getItemToRender(T value);

    public abstract class_2561 getRenderedValueText();
}
