package games.enchanted.eg_particle_interactions.common.mixin.client.entity;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import games.enchanted.eg_particle_interactions.common.Logging;
import games.enchanted.eg_particle_interactions.common.particle_spawning.SpawnParticles;
import net.minecraft.class_1540;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5568;
import net.minecraft.class_5577;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_8170;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_638.class)
public abstract class FallingBlockEntityLand_ClientLevelMixin extends class_1937 {
    protected FallingBlockEntityLand_ClientLevelMixin(class_5269 writableLevelData, class_5321<class_1937> resourceKey, class_5455 registryAccess, class_6880<class_2874> dimensionTypeHolder, boolean isClientSide, boolean isDebug, long p_270248_, int p_270466_) {
        super(writableLevelData, resourceKey, registryAccess, dimensionTypeHolder, isClientSide, isDebug, p_270248_, p_270466_);
    }

    @SuppressWarnings("UnreachableCode")
    @WrapOperation(
        method = "removeEntity",
        at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/entity/LevelEntityGetter;get(I)Lnet/minecraft/world/level/entity/EntityAccess;")
    )
    public class_5568 removeEntity(class_5577 instance, int i, Operation<class_5568> original) {
        class_5568 entity = original.call(instance, i);
        if(!(entity instanceof class_1540 fallingBlockEntity)) {
            // not a falling block so return early
            return original.call(instance, i);
        }

        if(fallingBlockEntity.method_6962().method_26204() instanceof class_8170) {
            return original.call(instance, i);
        }

        class_2680 fallingState = fallingBlockEntity.method_6962();
        class_2338 fallingBlockPos = fallingBlockEntity.method_24515();

        SpawnParticles.spawnFallingBlockLandParticles((class_638) (Object) this, fallingState, fallingBlockEntity.method_23317(), fallingBlockEntity.method_23318(), fallingBlockEntity.method_23321(), fallingBlockEntity.method_18798());

        Logging.interactionDebugInfo("Falling block ({}) was removed at {}", fallingBlockEntity, fallingBlockPos);
        return original.call(instance, i);
    }
}
