package games.enchanted.eg_particle_interactions.common.mixin.client.items;

import games.enchanted.eg_particle_interactions.common.Logging;
import games.enchanted.eg_particle_interactions.common.particle_spawning.SpawnParticles;
import net.minecraft.class_1269;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3922;
import net.minecraft.class_4770;
import net.minecraft.class_5544;
import net.minecraft.class_5545;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(net.minecraft.class_1786.class)
public abstract class FlintAndSteelItem {
    @Inject(
        method = "useOn",
        at = @At(value = "HEAD")
    )
    private void spawnParticlesOnUse(class_1838 useOnContext, CallbackInfoReturnable<class_1269> cir) {
        class_1937 level = useOnContext.method_8045();
        if(level.method_8608()) {
            class_2338 clickedPos = useOnContext.method_8037();
            class_2680 clickedState = level.method_8320(clickedPos);

            if(!class_3922.method_30035(clickedState) && !class_5544.method_31630(clickedState) && !class_5545.method_31635(clickedState)) {
                // placed a fire
                class_2338 firePos = clickedPos.method_10093(useOnContext.method_8038());
                if(class_4770.method_30032(level, firePos, useOnContext.method_8042())) {
                    Logging.interactionDebugInfo("Fire placed by '" + this + "' at " + firePos.method_23854() + ". (interacted at " + clickedPos.method_23854() + ")");
                    SpawnParticles.spawnFlintAndSteelSparkParticle(level, firePos);
                }
            }else {
                // lit a block
                Logging.interactionDebugInfo("Block lit by '" + this + "' at " + clickedPos.method_23854());
                SpawnParticles.spawnFlintAndSteelSparkParticle(level, clickedPos);
            }
        }
    }
}