package games.enchanted.eg_particle_interactions.common.mixin.client.items;

import games.enchanted.eg_particle_interactions.common.Logging;
import games.enchanted.eg_particle_interactions.common.particle_spawning.SpawnParticles;
import net.minecraft.class_1269;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(net.minecraft.class_1821.class)
public abstract class ShovelItem {
    @Inject(
        method = "useOn",
        at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/core/BlockPos;Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V")
    )
    private void spawnParticlesOnBlockFlatten(class_1838 useOnContext, CallbackInfoReturnable<class_1269> cir) {
        class_1937 level = useOnContext.method_8045();
        if(level.method_8608()) {
            class_2338 flattenedBlockPos = useOnContext.method_8037();
            class_2680 blockState = level.method_8320(flattenedBlockPos);

            Logging.interactionDebugInfo("Shovel used (" + this + ") at " + flattenedBlockPos.method_23854() + " to flatten " + blockState.method_26204());
            SpawnParticles.spawnShovelFlattenParticle(level, flattenedBlockPos, useOnContext);
        }
    }
}
