package games.enchanted.eg_particle_interactions.common.particle;

import com.mojang.serialization.MapCodec;
import games.enchanted.eg_particle_interactions.common.Constants;
import games.enchanted.eg_particle_interactions.common.particle.types.CustomMovementTerrainParticle;
import games.enchanted.eg_particle_interactions.common.particle.types.bubble.UnderwaterRisingBubble;
import games.enchanted.eg_particle_interactions.common.particle.types.constant_motion.LavaPop;
import games.enchanted.eg_particle_interactions.common.particle.types.drip.DripAndLandParticle;
import games.enchanted.eg_particle_interactions.common.particle.types.dust.BasicDust;
import games.enchanted.eg_particle_interactions.common.particle.types.dust.BasicTintedDust;
import games.enchanted.eg_particle_interactions.common.particle.types.dust.FloatingColouredDust;
import games.enchanted.eg_particle_interactions.common.particle.types.emitter.arc.ArcEmitter;
import games.enchanted.eg_particle_interactions.common.particle.types.emitter.random_distribution.UnderwaterBubbleEmitter;
import games.enchanted.eg_particle_interactions.common.particle.options.ArcEmitterOptions;
import games.enchanted.eg_particle_interactions.common.particle.options.DripParticleOption;
import games.enchanted.eg_particle_interactions.common.particle.options.RandomDistributionEmitterOptions;
import games.enchanted.eg_particle_interactions.common.particle.options.TintedParticleOption;
import games.enchanted.eg_particle_interactions.common.particle.types.falling_spin.FallingSpinningColouredParticle;
import games.enchanted.eg_particle_interactions.common.particle.types.falling_spin.FallingSpinningParticle;
import games.enchanted.eg_particle_interactions.common.particle.types.shatter.BlockShatter;
import games.enchanted.eg_particle_interactions.common.particle.types.spark.FlyingSpark;
import games.enchanted.eg_particle_interactions.common.particle.types.emitter.random_distribution.SparkEmitter;
import games.enchanted.eg_particle_interactions.common.particle.types.spark.SparkFlash;
import games.enchanted.eg_particle_interactions.common.particle.types.splash.BlockSplash;
import games.enchanted.eg_particle_interactions.common.particle.types.splash.ColouredBucketSplash;
import games.enchanted.eg_particle_interactions.common.particle.types.splash.LavaSplash;
import games.enchanted.eg_particle_interactions.common.particle.types.swirling.Ember;
import games.enchanted.eg_particle_interactions.common.particle.types.swirling.WaterVapour;
import games.enchanted.eg_particle_interactions.common.platform.PlatformHelper;
import games.enchanted.eg_particle_interactions.common.registry.RegistryHelpers;
import org.jetbrains.annotations.NotNull;

import java.util.function.Function;
import net.minecraft.class_2378;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_4002;
import net.minecraft.class_707;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class ModParticleTypes {
    public static class_2400 SNOWFLAKE;
    public static class_2400 SNOWFLAKE_SPECK;
    public static class_2400 FALLING_CHERRY_PETAL;
    public static class_2396<class_2388> FALLING_TINTED_LEAF;
    public static class_2396<class_2388> FALLING_TINTED_PINE_LEAF;
    public static class_2400 FALLING_AZALEA_LEAF;
    public static class_2400 FALLING_FLOWERING_AZALEA_LEAF;
    public static class_2400 FALLING_PALE_OAK_LEAF;
    public static class_2396<class_2388> FLOWER_PETAL;
    public static class_2396<class_2388> GRASS_BLADE;
    public static class_2396<class_2388> HEAVY_GRASS_BLADE;
    public static class_2400 MOSS_CLUMP;
    public static class_2400 PALE_MOSS_CLUMP;
    public static class_2396<TintedParticleOption> BRUSH_DUST;
    public static class_2396<TintedParticleOption> BRUSH_DUST_SPECK;
    public static class_2396<TintedParticleOption> ITEM_FRAME_DUST;
    public static class_2396<TintedParticleOption> ITEM_FRAME_DUST_SPECK;
    public static class_2396<TintedParticleOption> GLOW_ITEM_FRAME_DUST;
    public static class_2396<TintedParticleOption> GLOW_ITEM_FRAME_DUST_SPECK;
    public static class_2396<class_2388> TINTED_DUST;
    public static class_2396<class_2388> TINTED_DUST_SPECK;
    public static class_2396<class_2388> REDSTONE_DUST;
    public static class_2396<class_2388> BLOCK_SHATTER;
    public static class_2396<class_2388> CHAIN_SNAP;
    public static class_2396<class_2388> SUGAR_CANE;

    public static class_2396<DripParticleOption> HONEY_DROP;

    public static class_2396<class_2388> WATER_BUCKET_TINTED_SPLASH;
    public static class_2400 LAVA_BUCKET_SPLASH;
    public static class_2396<class_2388> GENERIC_FLUID_BUCKET_SPLASH;

    public static class_2400 FLYING_SPARK;
    public static class_2400 FLOATING_SPARK;
    public static class_2400 FLYING_SOUL_SPARK;
    public static class_2400 FLOATING_SOUL_SPARK;

    public static class_2400 SPARK_FLASH;
    public static class_2400 SOUL_SPARK_FLASH;
    public static class_2400 LIGHTNING_FLASH;

    public static class_2400 UNDERWATER_RISING_BUBBLE;
    public static class_2400 UNDERWATER_RISING_BUBBLE_SMALL;

    public static class_2400 FLOATING_EMBER;
    public static class_2400 FLOATING_SOUL_EMBER;
    public static class_2400 WATER_VAPOUR;

    public static class_2400 LAVA_POP;

    public static class_2396<RandomDistributionEmitterOptions> FLYING_SPARK_EMITTER;
    public static class_2396<RandomDistributionEmitterOptions> UNDERWATER_RISING_BUBBLE_SMALL_EMITTER;
    public static class_2396<ArcEmitterOptions> ARC_EMITTER;

    // this only exists because the vanilla block cracking particles are created inside the particle engine
    public static class_2396<class_2388> BLOCK_CRACK;
    // this exists so block particles can be spawned with low velocities and still move correctly (hacky workaround
    //  for Block Particle Overrides not having a way to spawn different particles at different velocities)
    public static class_2396<class_2388> BLOCK_HIGH_VELOCITY;

    @SuppressWarnings({"unchecked","rawtypes"})
    public static void registerParticles() {
        SNOWFLAKE = register((SpriteProviderReg) BasicDust.SnowflakeProvider::new, class_2960.method_60655(Constants.MOD_ID, "snowflake"), false);
        SNOWFLAKE_SPECK = register((SpriteProviderReg) BasicDust.SnowflakeSpeckProvider::new, class_2960.method_60655(Constants.MOD_ID, "snowflake_speck"), false);
        FALLING_CHERRY_PETAL = register((SpriteProviderReg) FallingSpinningParticle.GenericLeafProvider::new, class_2960.method_60655(Constants.MOD_ID, "falling_cherry_leaves"), false);
        FALLING_TINTED_LEAF = register((SpriteProviderReg) FallingSpinningColouredParticle.TintedLeafProvider::new, class_2960.method_60655(Constants.MOD_ID, "falling_tinted_leaves"), false, class_2388::method_29128, class_2388::method_56170);
        FALLING_TINTED_PINE_LEAF = register((SpriteProviderReg) FallingSpinningColouredParticle.TintedLeafProvider::new, class_2960.method_60655(Constants.MOD_ID, "falling_tinted_pine_leaves"), false, class_2388::method_29128, class_2388::method_56170);
        FALLING_AZALEA_LEAF = register((SpriteProviderReg) FallingSpinningParticle.GenericLeafProvider::new, class_2960.method_60655(Constants.MOD_ID, "falling_azalea_leaves"), false);
        FALLING_FLOWERING_AZALEA_LEAF = register((SpriteProviderReg) FallingSpinningParticle.GenericLeafProvider::new, class_2960.method_60655(Constants.MOD_ID, "falling_flowering_azalea_leaves"), false);
        FALLING_PALE_OAK_LEAF = register((SpriteProviderReg) FallingSpinningParticle.PaleOakProvider::new, class_2960.method_60655(Constants.MOD_ID, "falling_pale_oak_leaf"), false);
        FLOWER_PETAL = register((SpriteProviderReg) FallingSpinningColouredParticle.FlowerPetalProvider::new, class_2960.method_60655(Constants.MOD_ID, "flower_petal"), false, class_2388::method_29128, class_2388::method_56170);
        GRASS_BLADE = register((SpriteProviderReg) FallingSpinningColouredParticle.GrassBladeProvider::new, class_2960.method_60655(Constants.MOD_ID, "grass_blade"), false, class_2388::method_29128, class_2388::method_56170);
        HEAVY_GRASS_BLADE = register((SpriteProviderReg) FallingSpinningColouredParticle.HeavyGrassBladeProvider::new, class_2960.method_60655(Constants.MOD_ID, "heavy_grass_blade"), false, class_2388::method_29128, class_2388::method_56170);
        MOSS_CLUMP = register((SpriteProviderReg) FallingSpinningParticle.RandomisedSizeMoreGravityProvider::new, class_2960.method_60655(Constants.MOD_ID, "moss_clump"), false);
        PALE_MOSS_CLUMP = register((SpriteProviderReg) FallingSpinningParticle.RandomisedSizeMoreGravityProvider::new, class_2960.method_60655(Constants.MOD_ID, "pale_moss_clump"), false);
        BRUSH_DUST = register((SpriteProviderReg) BasicTintedDust.BrushProvider::new, class_2960.method_60655(Constants.MOD_ID, "brush_dust"), false, TintedParticleOption::codec, TintedParticleOption::streamCodec);
        BRUSH_DUST_SPECK = register((SpriteProviderReg) BasicTintedDust.BrushSpeckProvider::new, class_2960.method_60655(Constants.MOD_ID, "brush_dust_speck"), false, TintedParticleOption::codec, TintedParticleOption::streamCodec);
        ITEM_FRAME_DUST = register((SpriteProviderReg) BasicTintedDust.ItemFrameProvider::new, class_2960.method_60655(Constants.MOD_ID, "item_frame_dust"), false, TintedParticleOption::codec, TintedParticleOption::streamCodec);
        ITEM_FRAME_DUST_SPECK = register((SpriteProviderReg) BasicTintedDust.ItemFrameSpeckProvider::new, class_2960.method_60655(Constants.MOD_ID, "item_frame_dust_speck"), false, TintedParticleOption::codec, TintedParticleOption::streamCodec);
        GLOW_ITEM_FRAME_DUST = register((SpriteProviderReg) BasicTintedDust.GlowItemFrameProvider::new, class_2960.method_60655(Constants.MOD_ID, "glow_item_frame_dust"), false, TintedParticleOption::codec, TintedParticleOption::streamCodec);
        GLOW_ITEM_FRAME_DUST_SPECK = register((SpriteProviderReg) BasicTintedDust.GlowItemFrameSpeckProvider::new, class_2960.method_60655(Constants.MOD_ID, "glow_item_frame_dust_speck"), false, TintedParticleOption::codec, TintedParticleOption::streamCodec);
        TINTED_DUST = register((SpriteProviderReg) FloatingColouredDust.TintedDustProvider::new, class_2960.method_60655(Constants.MOD_ID, "tinted_dust"), false, class_2388::method_29128, class_2388::method_56170);
        TINTED_DUST_SPECK = register((SpriteProviderReg) FloatingColouredDust.TintedDustSpeckProvider::new, class_2960.method_60655(Constants.MOD_ID, "tinted_dust_speck"), false, class_2388::method_29128, class_2388::method_56170);
        REDSTONE_DUST = register((SpriteProviderReg) FloatingColouredDust.RedstoneProvider::new, class_2960.method_60655(Constants.MOD_ID, "redstone_dust"), false, TintedParticleOption::codec, TintedParticleOption::streamCodec);
        BLOCK_SHATTER = register((SpriteProviderReg) BlockShatter.BlockShatterProvider::new, class_2960.method_60655(Constants.MOD_ID, "block_shatter"), false, class_2388::method_29128, class_2388::method_56170);
        CHAIN_SNAP = register((SpriteProviderReg) FallingSpinningColouredParticle.ChainSnapProvider::new, class_2960.method_60655(Constants.MOD_ID, "chain_snap"), false, class_2388::method_29128, class_2388::method_56170);
        SUGAR_CANE = register((SpriteProviderReg) FallingSpinningColouredParticle.SugarCaneProvider::new, class_2960.method_60655(Constants.MOD_ID, "sugar_cane"), false, class_2388::method_29128, class_2388::method_56170);

        HONEY_DROP = register((SpriteProviderReg) DripAndLandParticle.UntintedDropProvider::new, class_2960.method_60655(Constants.MOD_ID, "honey_drop"), false, DripParticleOption::codec, DripParticleOption::streamCodec);

        WATER_BUCKET_TINTED_SPLASH = register((SpriteProviderReg) ColouredBucketSplash.Provider::new, class_2960.method_60655(Constants.MOD_ID, "water_bucket_tinted_splash"), false, class_2388::method_29128, class_2388::method_56170);
        LAVA_BUCKET_SPLASH = register((SpriteProviderReg) LavaSplash.Provider::new, class_2960.method_60655(Constants.MOD_ID, "lava_bucket_splash"), false);
        GENERIC_FLUID_BUCKET_SPLASH = register((SpriteProviderReg) BlockSplash.Provider::new, class_2960.method_60655(Constants.MOD_ID, "generic_fluid_bucket_splash"), false, class_2388::method_29128, class_2388::method_56170);

        FLYING_SPARK = register((SpriteProviderReg) FlyingSpark.FlyingSparkProvider::new, class_2960.method_60655(Constants.MOD_ID, "flying_spark"), false);
        FLOATING_SPARK = register((SpriteProviderReg) FlyingSpark.FloatingSparkProvider::new, class_2960.method_60655(Constants.MOD_ID, "floating_spark"), false);
        FLYING_SOUL_SPARK = register((SpriteProviderReg) FlyingSpark.FlyingSoulSparkProvider::new, class_2960.method_60655(Constants.MOD_ID, "flying_soul_spark"), false);
        FLOATING_SOUL_SPARK = register((SpriteProviderReg) FlyingSpark.FloatingSoulSparkProvider::new, class_2960.method_60655(Constants.MOD_ID, "floating_soul_spark"), false);

        SPARK_FLASH = register((SpriteProviderReg) SparkFlash.Provider::new, class_2960.method_60655(Constants.MOD_ID, "spark_flash"), false);
        SOUL_SPARK_FLASH = register((SpriteProviderReg) SparkFlash.Provider::new, class_2960.method_60655(Constants.MOD_ID, "soul_spark_flash"), false);
        LIGHTNING_FLASH = register((SpriteProviderReg) SparkFlash.RandomAnimationProvider::new, class_2960.method_60655(Constants.MOD_ID, "lightning_flash"), false);

        UNDERWATER_RISING_BUBBLE = register((SpriteProviderReg) UnderwaterRisingBubble.Provider::new, class_2960.method_60655(Constants.MOD_ID, "underwater_rising_bubble"), false);
        UNDERWATER_RISING_BUBBLE_SMALL = register((SpriteProviderReg) UnderwaterRisingBubble.SmallProvider::new, class_2960.method_60655(Constants.MOD_ID, "underwater_rising_bubble_small"), false);

        FLOATING_EMBER = register((SpriteProviderReg) Ember.EmberProvider::new, class_2960.method_60655(Constants.MOD_ID, "floating_ember"), true);
        FLOATING_SOUL_EMBER = register((SpriteProviderReg) Ember.EmberProvider::new, class_2960.method_60655(Constants.MOD_ID, "floating_soul_ember"), true);
        WATER_VAPOUR = register((SpriteProviderReg) WaterVapour.WaterVapourProvider::new, class_2960.method_60655(Constants.MOD_ID, "water_vapour"), true);

        LAVA_POP = register((SpriteProviderReg) LavaPop.LavaPopProvider::new, class_2960.method_60655(Constants.MOD_ID, "lava_pop"), true);

        FLYING_SPARK_EMITTER = register((SpriteProviderReg) SparkEmitter.Provider::new, class_2960.method_60655(Constants.MOD_ID, "flying_spark_emitter"), true, RandomDistributionEmitterOptions::codec, RandomDistributionEmitterOptions::streamCodec);
        UNDERWATER_RISING_BUBBLE_SMALL_EMITTER = register((SpriteProviderReg) UnderwaterBubbleEmitter.Provider::new, class_2960.method_60655(Constants.MOD_ID, "underwater_rising_bubble_small_emitter"), true, RandomDistributionEmitterOptions::codec, RandomDistributionEmitterOptions::streamCodec);
        ARC_EMITTER = register((SpriteProviderReg) ArcEmitter.Provider::new, class_2960.method_60655(Constants.MOD_ID, "arc_emitter"), true, ArcEmitterOptions::codec, ArcEmitterOptions::streamCodec);

        BLOCK_CRACK = register((SpriteProviderReg) CustomMovementTerrainParticle.CrackingProvider::new, class_2960.method_60655(Constants.MOD_ID, "block_crack"), true, class_2388::method_29128, class_2388::method_56170);
        BLOCK_HIGH_VELOCITY = register((SpriteProviderReg) CustomMovementTerrainParticle.UncappedMotionProvider::new, class_2960.method_60655(Constants.MOD_ID, "block_high_velocity"), true, class_2388::method_29128, class_2388::method_56170);
    }

    private static class_2400 register(SpriteProviderReg<class_2400> provider, class_2960 particleID, boolean alwaysShow) {
        class_2400 registeredParticleType = class_2378.method_10230(class_7923.field_41180, particleID, PlatformHelper.createNewSimpleParticle(alwaysShow));
        PlatformHelper.registerParticleProvider(registeredParticleType, provider);
        return registeredParticleType;
    }

    private static <T extends class_2394> class_2396<T> register(SpriteProviderReg<T> provider, class_2960 particleID, boolean alwaysShow, final Function<class_2396<T>, MapCodec<T>> codecGetter, final Function<class_2396<T>, class_9139<? super class_9129, T>> packetCodecGetter) {
        class_2396<T> registeredParticleType = RegistryHelpers.register(class_7924.field_41210, () -> new class_2396<T>(alwaysShow) {
            public @NotNull MapCodec<T> method_29138() {
                return codecGetter.apply(this);
            }

            public @NotNull class_9139<? super class_9129, T> method_56179() {
                return packetCodecGetter.apply(this);
            }
        }, particleID);
        PlatformHelper.registerParticleProvider(registeredParticleType, provider);
        return registeredParticleType;
    }

    @FunctionalInterface
    public interface SpriteProviderReg<T extends class_2394> {
        class_707<T> create(class_4002 spriteSet);
    }
}
