package games.enchanted.eg_particle_interactions.common.particle.options;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class ArcEmitterOptions implements class_2394 {
    public static final int TICK_INTERVAL_DEFAULT = 1;
    public static final int REPEAT_DEFAULT = 5;

    private final class_2396<ArcEmitterOptions> type;
    private final int length;
    private final int splits;
    private final int angleVariance;
    private final int tickInterval;
    private final int repeat;
    @Nullable private final Integer initialAngleXDeg;
    @Nullable private final Integer initialAngleYDeg;

    public ArcEmitterOptions(class_2396<ArcEmitterOptions> type, int length, int splits, int angleVariance) {
        this(type, length, splits, angleVariance, REPEAT_DEFAULT, TICK_INTERVAL_DEFAULT, null, null);
    }

    public ArcEmitterOptions(class_2396<ArcEmitterOptions> type, int length, int splits, int angleVariance, int repeat, int tickInterval, @Nullable Integer initialAngleXDeg, @Nullable Integer initialAngleYDeg) {
        this.type = type;
        this.length = length;
        this.splits = splits;
        this.angleVariance = angleVariance;
        this.repeat = repeat;
        this.tickInterval = tickInterval;
        this.initialAngleXDeg = initialAngleXDeg;
        this.initialAngleYDeg = initialAngleYDeg;
    }

    private static Codec<ArcEmitterOptions> createCodec(class_2396<ArcEmitterOptions> type) {
        return RecordCodecBuilder.create((RecordCodecBuilder.Instance<ArcEmitterOptions> instance) ->
            instance.group(
                class_5699.field_33442.optionalFieldOf("length", 5).forGetter(ArcEmitterOptions::getLength),
                class_5699.field_33442.optionalFieldOf("splits", 2).forGetter(ArcEmitterOptions::getSplits),
                class_5699.field_33442.optionalFieldOf("angle_variance", 45).forGetter(ArcEmitterOptions::getAngleVariance),
                class_5699.field_33442.optionalFieldOf("repeat", REPEAT_DEFAULT).forGetter(ArcEmitterOptions::getRepeat),
                class_5699.field_33442.optionalFieldOf("interval", TICK_INTERVAL_DEFAULT).forGetter(ArcEmitterOptions::getTickInterval),
                Codec.INT.optionalFieldOf("initial_x_angle").forGetter(ArcEmitterOptions::getInitialAngleXDeg),
                Codec.INT.optionalFieldOf("initial_y_angle").forGetter(ArcEmitterOptions::getInitialAngleYDeg)
            ).apply(
                instance,
                (
                    Integer length,
                    Integer splits,
                    Integer angleVariance,
                    Integer repeat,
                    Integer tickInterval,
                    Optional<Integer> initialAngleXDeg,
                    Optional<Integer> initialAngleYDeg
                ) -> new ArcEmitterOptions(
                    type,
                    length,
                    splits,
                    angleVariance,
                    repeat,
                    tickInterval,
                    initialAngleXDeg.orElse(null),
                    initialAngleYDeg.orElse(null)
                )
            )
        );
    }

    public static MapCodec<ArcEmitterOptions> codec(class_2396<ArcEmitterOptions> type) {
        return createCodec(type).fieldOf("emitter_options");
    }

    public static class_9139<? super class_9129, ArcEmitterOptions> streamCodec(class_2396<ArcEmitterOptions> type) {
        return class_9135.method_56368(createCodec(type));
    }

    @Override
    public @NotNull class_2396<ArcEmitterOptions> method_10295() {
        return this.type;
    }

    public int getLength() {
        return length;
    }

    public int getSplits() {
        return splits;
    }

    public int getAngleVariance() {
        return angleVariance;
    }

    public int getTickInterval() {
        return tickInterval;
    }

    public int getRepeat() {
        return repeat;
    }

    public Optional<Integer> getInitialAngleXDeg() {
        return Optional.ofNullable(initialAngleXDeg);
    }

    public Optional<Integer> getInitialAngleYDeg() {
        return Optional.ofNullable(initialAngleYDeg);
    }
}
