package games.enchanted.eg_particle_interactions.common.particle.options;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RandomDistributionEmitterOptions implements class_2394 {
    private final class_2396<RandomDistributionEmitterOptions> type;
    private final int repeat;
    private final int tickInterval;
    private final int particlesPerEmission;
    private final boolean emitOnFirstTick;
    private final Vector3f dimensions;
    private final Vector3f velocityVariance;

    public RandomDistributionEmitterOptions(class_2396<RandomDistributionEmitterOptions> type, int tickIterations, int tickInvertal, int particlesPerEmission, boolean emitOnFirstTick, Vector3fc dimensions, Vector3fc velocityVariance) {
        this.type = type;
        this.repeat = tickIterations;
        this.tickInterval = tickInvertal;
        this.particlesPerEmission = particlesPerEmission;
        this.emitOnFirstTick = emitOnFirstTick;
        this.dimensions = new Vector3f(dimensions);
        this.velocityVariance = new Vector3f(velocityVariance);
    }

    public RandomDistributionEmitterOptions(class_2396<RandomDistributionEmitterOptions> type, int repeat, int tickInvertal, int particlesPerEmission) {
        this(type, repeat, tickInvertal, particlesPerEmission, true, new Vector3f(0, 0, 0), new Vector3f(0, 0, 0));
    }

    public RandomDistributionEmitterOptions(class_2396<RandomDistributionEmitterOptions> type, int repeat, int tickInvertal, int particlesPerEmission, Vector3f dimensions) {
        this(type, repeat, tickInvertal, particlesPerEmission, true, dimensions, new Vector3f(0, 0, 0));
    }

    public RandomDistributionEmitterOptions(class_2396<RandomDistributionEmitterOptions> type, int repeat, int tickInvertal, int particlesPerEmission, Vector3f dimensions, Vector3f velocityVariance) {
        this(type, repeat, tickInvertal, particlesPerEmission, true, dimensions, velocityVariance);
    }

    private static Codec<RandomDistributionEmitterOptions> createCodec(class_2396<RandomDistributionEmitterOptions> type) {
        return RecordCodecBuilder.create((RecordCodecBuilder.Instance<RandomDistributionEmitterOptions> instance) ->
            instance.group(
                class_5699.field_33442.fieldOf("repeat").forGetter(RandomDistributionEmitterOptions::getRepeat),
                class_5699.field_33442.fieldOf("interval").forGetter(RandomDistributionEmitterOptions::getTickInterval),
                class_5699.field_33442.optionalFieldOf("amount_per_emission", 1).forGetter(RandomDistributionEmitterOptions::getParticlesPerEmission),
                Codec.BOOL.optionalFieldOf("emit_on_first_tick", true).forGetter(RandomDistributionEmitterOptions::getEmitOnFirstTick),
                class_5699.field_40723.optionalFieldOf("dimensions", new Vector3f(0f, 0f, 0f)).forGetter(RandomDistributionEmitterOptions::getDimensions),
                class_5699.field_40723.optionalFieldOf("velocity_variance", new Vector3f(0f, 0f, 0f)).forGetter(RandomDistributionEmitterOptions::getVelocityVariance)
            ).apply(
                instance,
                (Integer tickIterations, Integer tickInterval, Integer particlesPerEmission, Boolean emitOnFirstTick, Vector3fc dimensions, Vector3fc velocityVariance) -> new RandomDistributionEmitterOptions(type, tickIterations, tickInterval, particlesPerEmission, emitOnFirstTick, dimensions, velocityVariance)
            )
        );
    }

    public static MapCodec<RandomDistributionEmitterOptions> codec(class_2396<RandomDistributionEmitterOptions> type) {
        return createCodec(type).fieldOf("emitter_options");
    }

    public static class_9139<? super class_9129, RandomDistributionEmitterOptions> streamCodec(class_2396<RandomDistributionEmitterOptions> type) {
        return class_9135.method_56368(createCodec(type));
    }

    @Override
    public @NotNull class_2396<RandomDistributionEmitterOptions> method_10295() {
        return this.type;
    }

    public int getRepeat() {
        return repeat;
    }

    public int getTickInterval() {
        return tickInterval;
    }

    public int getParticlesPerEmission() {
        return particlesPerEmission;
    }

    public boolean getEmitOnFirstTick() {
        return emitOnFirstTick;
    }

    public Vector3f getDimensions() {
        return dimensions;
    }

    public Vector3f getVelocityVariance() {
        return velocityVariance;
    }
}
