package games.enchanted.eg_particle_interactions.common.particle.overrides;

import games.enchanted.eg_particle_interactions.common.config.categories.BlockOverrideOptions;
import games.enchanted.eg_particle_interactions.common.particle.ModParticleTypes;
import games.enchanted.eg_particle_interactions.common.particle.options.TintedParticleOption;
import games.enchanted.eg_particle_interactions.common.util.BiomeHelpers;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_638;
import net.minecraft.world.level.block.*;

public abstract class BlockParticleOverrides {
    public static final BlockParticleOverride SNOW_POWDER = new BlockParticleOverride(
        "snowflake",
        "generic_block_override",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> {
            if(BiomeHelpers.isWarmBiomeOrDimension(level, blockPos)) {
                return level.field_9229.method_43048(5) == 0 ? class_2398.field_11203 : ModParticleTypes.SNOWFLAKE;
            }
            return ModParticleTypes.SNOWFLAKE;
        },
        BlockOverrideOptions.SNOWFLAKE_PARTICLE_OVERRIDE,
        0.15f
    );
    public static final BlockParticleOverride CHERRY_LEAF = new BlockParticleOverride(
        "cherry_petal",
        "generic_block_override",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> ModParticleTypes.FALLING_CHERRY_PETAL,
        BlockOverrideOptions.CHERRY_PETAL_PARTICLE_OVERRIDE,
        0.13f
    );
    public static final BlockParticleOverride AZALEA_LEAF = new BlockParticleOverride(
        "azalea_leaf",
        "generic_block_override",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> ModParticleTypes.FALLING_AZALEA_LEAF,
        BlockOverrideOptions.AZALEA_LEAVES_PARTICLE_OVERRIDE,
        0.13f
    );
    public static final BlockParticleOverride FLOWERING_AZALEA_LEAF = new BlockParticleOverride(
        "flowering_azalea_leaf",
        "generic_block_override",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> ModParticleTypes.FALLING_FLOWERING_AZALEA_LEAF,
        BlockOverrideOptions.FLOWERING_AZALEA_LEAVES_PARTICLE_OVERRIDE,
        0.13f
    );
    public static final BlockParticleOverride PALE_LEAF = new BlockParticleOverride(
        "pale_leaf",
        "generic_block_override",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> ModParticleTypes.FALLING_PALE_OAK_LEAF,
        BlockOverrideOptions.PALE_LEAVES_PARTICLE_OVERRIDE,
        0.13f
    );
    public static final BlockParticleOverride TINTED_PINE_LEAF = new BlockParticleOverride(
        "biome_pine_leaf",
        "tinted_or_random_pixel",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> new class_2388(ModParticleTypes.FALLING_TINTED_PINE_LEAF, blockState),
        BlockOverrideOptions.PINE_LEAVES_PARTICLE_OVERRIDE,
        0.13f
    );
    public static final BlockParticleOverride TINTED_LEAF = new BlockParticleOverride(
        "biome_leaf",
        "tinted_or_random_pixel",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> new class_2388(ModParticleTypes.FALLING_TINTED_LEAF, blockState),
        BlockOverrideOptions.GENERIC_LEAVES_PARTICLE_OVERRIDE,
        0.13f
    );
    public static final BlockParticleOverride FLOWER_PETAL = new BlockParticleOverride(
        "flower_petal",
        "tinted_or_random_pixel",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> new class_2388(ModParticleTypes.FLOWER_PETAL, blockState),
        BlockOverrideOptions.FLOWER_PETAL_PARTICLE_OVERRIDE,
        0.18f
    );
    public static final BlockParticleOverride GRASS_BLADE = new BlockParticleOverride(
        "grass_blade",
        "tinted_or_random_pixel",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> {
            boolean spawnDirt = false;
            boolean spawnFirefly =
                level.method_22339(blockPos) <= 13 &&
                BiomeHelpers.isSwampyBiome(level, blockPos) &&
                level.field_9229.method_43057() > (overrideOrigin == BlockParticleOverride.ORIGIN_BLOCK_BROKEN || overrideOrigin == BlockParticleOverride.ORIGIN_BLOCK_PLACED ? 0.9f : 0.6f);

            if(
                (blockState.method_26204() == class_2246.field_10219 || blockState.method_26204() == class_2246.field_10194) &&
                (overrideOrigin == BlockParticleOverride.ORIGIN_BLOCK_CRACK || overrideOrigin == BlockParticleOverride.ORIGIN_BLOCK_PLACED || overrideOrigin == BlockParticleOverride.ORIGIN_BLOCK_BROKEN || overrideOrigin == BlockParticleOverride.ORIGIN_ITEM_PARTICLE_OVERRIDDEN)
            ) {
                // occasionally spawn dirt particles if a grass block is placed or broken
                spawnDirt = level.field_9229.method_43057() > 0.7;
            }

            if(spawnDirt) {
                return new class_2388(overrideOrigin == BlockParticleOverride.ORIGIN_BLOCK_CRACK ? ModParticleTypes.BLOCK_CRACK : ModParticleTypes.BLOCK_HIGH_VELOCITY, class_2246.field_10566.method_9564());
            }
            if(spawnFirefly) {
                return class_2398.field_56509;
            }
            return new class_2388(ModParticleTypes.GRASS_BLADE, blockState);
        },
        (int overrideOrigin) -> overrideOrigin != BlockParticleOverride.ORIGIN_ITEM_PARTICLE_OVERRIDDEN,
        BlockOverrideOptions.GRASS_BLADE_PARTICLE_OVERRIDE,
        0.13f
    );
    public static final BlockParticleOverride HEAVY_GRASS_BLADE = new BlockParticleOverride(
        "heavy_grass_blade",
        "tinted_or_random_pixel",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> new class_2388(ModParticleTypes.HEAVY_GRASS_BLADE, blockState),
        (int overrideOrigin) -> overrideOrigin != BlockParticleOverride.ORIGIN_ITEM_PARTICLE_OVERRIDDEN,
        BlockOverrideOptions.HEAVY_GRASS_BLADE_PARTICLE_OVERRIDE,
        0.13f
    );
    public static final BlockParticleOverride FIREFLY = new BlockParticleOverride(
        "firefly",
        "generic_block_override",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> {
            boolean firefly = level.field_9229.method_43057() > 0.6;
            if(overrideOrigin == BlockParticleOverride.ORIGIN_BLOCK_WALKED_THROUGH) {
                firefly = true;
            }
            return firefly ? class_2398.field_56509 : GRASS_BLADE.getParticleOptionForState(blockState, level, blockPos, overrideOrigin);
        },
        BlockOverrideOptions.FIREFLY_PARTICLE_OVERRIDE,
        0.13f
    );
    public static final BlockParticleOverride MOSS_CLUMP = new BlockParticleOverride(
        "moss_clump",
        "generic_block_override",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> ModParticleTypes.MOSS_CLUMP,
        BlockOverrideOptions.MOSS_CLUMP_PARTICLE_OVERRIDE,
        0.13f
    );
    public static final BlockParticleOverride PALE_MOSS_CLUMP = new BlockParticleOverride(
        "pale_moss_clump",
        "generic_block_override",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> ModParticleTypes.PALE_MOSS_CLUMP,
        BlockOverrideOptions.PALE_MOSS_CLUMP_PARTICLE_OVERRIDE,
        0.13f
    );
    public static final BlockParticleOverride DUST = new BlockParticleOverride(
        "dust",
        "tinted_or_random_pixel",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> new class_2388(ModParticleTypes.TINTED_DUST, blockState),
        BlockOverrideOptions.DUST_PARTICLE_OVERRIDE,
        0.1f
    );
    public static final BlockParticleOverride REDSTONE_DUST = new BlockParticleOverride(
        "redstone_dust",
        "generic_block_override",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> new class_2388(ModParticleTypes.REDSTONE_DUST, blockState),
        BlockOverrideOptions.REDSTONE_DUST_PARTICLE_OVERRIDE,
        0.1f
    );
    public static final BlockParticleOverride NETHER_PORTAL_SHATTER = new BlockParticleOverride(
        "nether_portal_shatter",
        "generic_block_override",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> new class_2388(ModParticleTypes.BLOCK_SHATTER, blockState),
        BlockOverrideOptions.BLOCK_SHATTER_PARTICLE_OVERRIDE,
        0.2f
    );
    public static final BlockParticleOverride CHAIN_SNAP = new BlockParticleOverride(
        "chain_snap",
        "tinted_or_random_pixel",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> {
            if(overrideOrigin == BlockParticleOverride.ORIGIN_BLOCK_BROKEN || overrideOrigin == BlockParticleOverride.ORIGIN_BLOCK_CRACK) {
                return level.field_9229.method_43057() > 0.9 ? ModParticleTypes.SPARK_FLASH : new class_2388(ModParticleTypes.CHAIN_SNAP, blockState);
            }
            return new class_2388(ModParticleTypes.CHAIN_SNAP, blockState);
        },
        BlockOverrideOptions.CHAIN_SNAP_PARTICLE_OVERRIDE,
        0.22f
    );
    public static final BlockParticleOverride SUGAR_CANE = new BlockParticleOverride(
        "sugar_cane",
        "tinted_or_random_pixel",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> new class_2388(ModParticleTypes.SUGAR_CANE, blockState),
        BlockOverrideOptions.SUGAR_CANE_PARTICLE_OVERRIDE,
        0.19f
    );

    public static void registerOverrides() {
        BlockParticleOverride.addBlockParticleOverride(SNOW_POWDER);
        BlockParticleOverride.addBlockParticleOverride(FIREFLY);
        BlockParticleOverride.addBlockParticleOverride(CHERRY_LEAF);
        BlockParticleOverride.addBlockParticleOverride(AZALEA_LEAF);
        BlockParticleOverride.addBlockParticleOverride(FLOWERING_AZALEA_LEAF);
        BlockParticleOverride.addBlockParticleOverride(PALE_LEAF);
        BlockParticleOverride.addBlockParticleOverride(TINTED_PINE_LEAF);
        BlockParticleOverride.addBlockParticleOverride(TINTED_LEAF);
        BlockParticleOverride.addBlockParticleOverride(FLOWER_PETAL);
        BlockParticleOverride.addBlockParticleOverride(GRASS_BLADE);
        BlockParticleOverride.addBlockParticleOverride(HEAVY_GRASS_BLADE);
        BlockParticleOverride.addBlockParticleOverride(MOSS_CLUMP);
        BlockParticleOverride.addBlockParticleOverride(PALE_MOSS_CLUMP);
        BlockParticleOverride.addBlockParticleOverride(DUST);
        BlockParticleOverride.addBlockParticleOverride(REDSTONE_DUST);
        BlockParticleOverride.addBlockParticleOverride(NETHER_PORTAL_SHATTER);
        BlockParticleOverride.addBlockParticleOverride(CHAIN_SNAP);
        BlockParticleOverride.addBlockParticleOverride(SUGAR_CANE);
    }
}
