package games.enchanted.eg_particle_interactions.common.particle.overrides;

import games.enchanted.eg_particle_interactions.common.config.categories.FluidPlacementOptions;
import games.enchanted.eg_particle_interactions.common.particle.ModParticleTypes;
import games.enchanted.eg_particle_interactions.common.registry.RegistryHelpers;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum FluidPlacementParticle {
    NONE("none"),
    TINTED_WATER("tinted_water", ModParticleTypes.WATER_BUCKET_TINTED_SPLASH, true),
    LAVA("lava", ModParticleTypes.LAVA_BUCKET_SPLASH, false),
    GENERIC("generic", ModParticleTypes.GENERIC_FLUID_BUCKET_SPLASH, true);

    private final String name;
    @Nullable private class_2394 particleType;
    @Nullable private class_2396<class_2388> blockParticleType;
    private final boolean isBlockStateParticle;

    FluidPlacementParticle(String overrideName, boolean isBlockStateParticle) {
        this.name = overrideName;
        this.isBlockStateParticle = isBlockStateParticle;
    }
    FluidPlacementParticle(String overrideName) {
        this(overrideName, false);
        this.particleType = null;
        this.blockParticleType = null;
    }
    FluidPlacementParticle(String overrideName, @Nullable class_2394 particle, boolean isBlockStateParticle) {
        this(overrideName, isBlockStateParticle);
        this.particleType = particle;
        this.blockParticleType = null;
    }
    FluidPlacementParticle(String overrideName, @Nullable class_2396<class_2388> particle, boolean isBlockStateParticle) {
        this(overrideName, isBlockStateParticle);
        this.particleType = null;
        this.blockParticleType = particle;
    }

    /**
     * @return the {@link class_2394} or null if this particle type is a blockstate particle.
     * @see #getBlockParticleOption
     * @see #isBlockStateParticle
     */
    public @Nullable class_2394 getParticleOption() {
        return this.particleType;
    }

    /**
     * @param blockState the {@link class_2680} to use when creating the particle options
     * @return a new {@link class_2388} or null if this particle type is not a blockstate particle.
     * @see #getParticleOption
     * @see #isBlockStateParticle
     */
    public @Nullable class_2388 getBlockParticleOption(class_2680 blockState) {
        if(this.blockParticleType == null) return null;
        return new class_2388(this.blockParticleType, blockState);
    }

    public boolean isBlockStateParticle() {
        return this.isBlockStateParticle;
    }

    @Override
    public @NotNull String toString() {
        return this.name;
    }

    public static FluidPlacementParticle getParticleForFluid(class_3611 fluid) {
        return getParticleForFluid(fluid, true);
    }

    public static FluidPlacementParticle getParticleForFluid(class_3611 fluid, boolean isFluidBeingPlaced) {
        class_2960 fluidLoc = RegistryHelpers.getLocationFromFluid(fluid);
        if (FluidPlacementOptions.WATER_SPLASH_FLUIDS.getValue().contains(fluidLoc) && shouldHaveParticle(isFluidBeingPlaced, FluidPlacementOptions.WATER_SPLASH_ENABLED.getValue())) {
            return TINTED_WATER;
        } else if (FluidPlacementOptions.LAVA_SPLASH_FLUIDS.getValue().contains(fluidLoc) && shouldHaveParticle(isFluidBeingPlaced, FluidPlacementOptions.LAVA_SPLASH_ENABLED.getValue())) {
            return LAVA;
        } else if (FluidPlacementOptions.GENERIC_SPLASH_FLUIDS.getValue().contains(fluidLoc) && shouldHaveParticle(isFluidBeingPlaced, FluidPlacementOptions.GENERIC_SPLASH_ENABLED.getValue())) {
            return GENERIC;
        }
        return NONE;
    }

    private static boolean shouldHaveParticle(boolean isFluidBeingPlaced, boolean spawnOnFluidPlace) {
        if(isFluidBeingPlaced) {
            return spawnOnFluidPlace;
        }
        return false;
    }

    public static int getParticleMultiplier(FluidPlacementParticle fluidPlacementParticle, boolean isBlockBeingPlaced) {
        switch (fluidPlacementParticle) {
            case TINTED_WATER -> {
                return getAppropriateMultiplier(isBlockBeingPlaced, FluidPlacementOptions.WATER_SPLASH_AMOUNT_ON_PLACE.getValue(), 0);
            }
            case LAVA -> {
                return getAppropriateMultiplier(isBlockBeingPlaced, FluidPlacementOptions.LAVA_SPLASH_AMOUNT_ON_PLACE.getValue(), 0);
            }
            case GENERIC -> {
                return getAppropriateMultiplier(isBlockBeingPlaced, FluidPlacementOptions.GENERIC_SPLASH_AMOUNT_ON_PLACE.getValue(), 0);
            }
            default -> {
                return 2;
            }
        }
    }

    private static int getAppropriateMultiplier(boolean isBlockBeingPlaced, int blockPlaceMultiplier, int blockBreakMultiplier) {
        if(isBlockBeingPlaced) {
            return blockPlaceMultiplier;
        }
        return blockBreakMultiplier;
    }
}
