//? if minecraft: > 1.21.8 {
package games.enchanted.eg_particle_interactions.common.particle.render.geometry;

import games.enchanted.eg_particle_interactions.common.particle.render.state.CustomParticleGeometryRenderState;
import net.minecraft.class_3940;
import org.joml.Quaternionf;

public class StateQuadConsumer implements QuadConsumer {
    final CustomParticleGeometryRenderState state;
    final class_3940.class_11941 layer;

    public StateQuadConsumer(CustomParticleGeometryRenderState state, class_3940.class_11941 layer) {
        this.state = state;
        this.layer = layer;
    }

    @Override
    public void addVertex(Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float scale, float u, float v, int packedLight, float rCol, float gCol, float bCol, float alpha) {
        this.state.addVertex(
            this.layer,
            quaternion,
            x,
            y,
            z,
            xOffset,
            yOffset,
            scale,
            u,
            v,
            packedLight,
            rCol,
            gCol,
            bCol,
            alpha
        );
    }

    @Override
    public void startQuad() {
        this.state.startQuad(this.layer);
    }

    @Override
    public void finishQuad() {
        this.state.finishQuad(this.layer);
    }
}
//?}