package games.enchanted.eg_particle_interactions.common.particle.types;

import games.enchanted.eg_particle_interactions.common.particle.render.ModParticleRenderTypes;
import games.enchanted.eg_particle_interactions.common.particle.render.geometry.QuadConsumer;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
//? if minecraft: <= 1.21.8 {
/*import com.mojang.blaze3d.vertex.VertexConsumer;
import games.enchanted.eg_particle_interactions.common.particle.render.geometry.VertexQuadConsumer;
*///?} else {
import games.enchanted.eg_particle_interactions.common.particle.render.geometry.StateQuadConsumer;
import games.enchanted.eg_particle_interactions.common.particle.render.state.CustomParticleGeometryRenderState;
import games.enchanted.eg_particle_interactions.common.rendering.ModRenderPipelines;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_703;

public abstract class ParticleInteractionsParticle extends class_703 {
    private float scale;
    private float prevScale;
    protected float roll;
    protected float prevRoll;
    protected float billboardYOffset = 0.0F;
    protected float billboardXOffset = 0.0F;

    protected class_1058 sprite;

    private float rCol = 1.0F;
    private float prevRCol = 1.0F;
    private float gCol = 1.0F;
    private float prevGCol = 1.0F;
    private float bCol = 1.0F;
    private float prevBCol = 1.0F;
    private float alpha = 1.0F;
    private float prevAlpha = 1.0F;

    protected ParticleInteractionsParticle(class_638 clientLevel, double x, double y, double z, class_1058 textureAtlasSprite) {
        this(clientLevel, x, y, z, 0, 0, 0, textureAtlasSprite);
        this.field_3852 = 0;
        this.field_3869 = 0;
        this.field_3850 = 0;
    }

    protected ParticleInteractionsParticle(class_638 clientLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_1058 textureAtlasSprite) {
        super(clientLevel, x, y, z, xSpeed, ySpeed, zSpeed);
        this.sprite = textureAtlasSprite;
        this.scale = 0.1F * (this.field_3840.method_43057() * 0.5F + 0.5F) * 2.0F;
    }

    //? if minecraft: <= 1.21.8 {
    /*@Override
    public @NotNull ParticleRenderType getRenderType() {
        ParticleLayer layer = getParticleLayer();
        if(layer == null) return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
        return layer.layer;
    }
    *///?} else {
    public static final class_3940.class_11941 BACKFACE_TERRAIN_LAYER = new class_3940.class_11941(true, class_1059.field_5275, ModRenderPipelines.BACKFACE_TRANSLUCENT_PARTICLE);

    protected @NotNull class_3940.class_11941 getLayer() {
        ParticleLayer layer = getParticleLayer();
        if(layer == null) return class_3940.class_11941.field_62640;
        return layer.layer;
    }

    @Override
    public @NotNull class_3999 method_74274() {
        return ModParticleRenderTypes.CUSTOM_GEOMETRY;
    }
    //?}

    //? if minecraft: <= 1.21.8 {
    /*@Override
    public void render(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
    *///?} else {
    public void extract(CustomParticleGeometryRenderState state, class_4184 camera, float partialTicks) {
    //?}
        Quaternionf quaternionf = new Quaternionf();
        this.getBillboardMode().rotate(quaternionf, camera, partialTicks);
        if (this.roll != 0.0F) {
            quaternionf.rotateZ(class_3532.method_16439(partialTicks, this.prevRoll, this.roll));
        }

        //? if minecraft: <= 1.21.8 {
        /*VertexQuadConsumer consumer = new VertexQuadConsumer(vertexConsumer);
        *///?} else {
        StateQuadConsumer consumer = new StateQuadConsumer(state, this.getLayer());
        //?}
        this.adjustPositionBeforeExtraction(consumer, camera, quaternionf, partialTicks);
    }

    protected void adjustPositionBeforeExtraction(QuadConsumer consumer, class_4184 camera, Quaternionf quaternionf, float partialTicks) {
        class_243 cameraPosition = camera.method_71156();
        float x = (float)(class_3532.method_16436(partialTicks, this.field_3858, this.field_3874) - cameraPosition.method_10216());
        float y = (float)(class_3532.method_16436(partialTicks, this.field_3838, this.field_3854) - cameraPosition.method_10214());
        float z = (float)(class_3532.method_16436(partialTicks, this.field_3856, this.field_3871) - cameraPosition.method_10215());
        this.extractGeometry(consumer, quaternionf, x, y, z, partialTicks);
    }

    protected void extractGeometry(QuadConsumer consumer, Quaternionf quaternion, float x, float y, float z, float partialTicks) {
        int light = method_3068(partialTicks);
        float scale = getLerpedScale(partialTicks);
        float r = this.getLerpedRed(partialTicks);
        float g = this.getLerpedGreen(partialTicks);
        float b = this.getLerpedBlue(partialTicks);
        float a = this.getLerpedAlpha(partialTicks);

        consumer.startQuad();
        consumer.addVertex(quaternion, x, y, z,  1.0F + this.billboardXOffset, -1.0F + this.billboardYOffset, scale, getU1(), getV1(), light, r, g, b, a);
        consumer.addVertex(quaternion, x, y, z,  1.0F + this.billboardXOffset,  1.0F + this.billboardYOffset, scale, getU1(), getV0(), light, r, g, b, a);
        consumer.addVertex(quaternion, x, y, z, -1.0F + this.billboardXOffset,  1.0F + this.billboardYOffset, scale, getU0(), getV0(), light, r, g, b, a);
        consumer.addVertex(quaternion, x, y, z, -1.0F + this.billboardXOffset, -1.0F + this.billboardYOffset, scale, getU0(), getV1(), light, r, g, b, a);
        consumer.finishQuad();
    }

    public BillboardMode getBillboardMode() {
        return BillboardMode.XYZ;
    }

    public void setSpriteFromAge(class_4002 sprites) {
        if (this.field_3843) return;
        this.setSprite(sprites.method_18138(this.field_3866, this.field_3847));
    }
    public void setSprite(class_1058 sprite) {
        this.sprite = sprite;
    }


    public class_238 getCullingBox(float partialTicks) {
        return this.method_3064();
    }


    protected float getU0() {
        return this.sprite.method_4594();
    }
    protected float getU1() {
        return this.sprite.method_4577();
    }
    protected float getV0() {
        return this.sprite.method_4593();
    }
    protected float getV1() {
        return this.sprite.method_4575();
    }


    public float getLerpedRed(float partialTicks) {
        return class_3532.method_16439(partialTicks, this.prevRCol, this.rCol);
    }
    public float getRed() {
        return this.rCol;
    }

    public float getLerpedGreen(float partialTicks) {
        return class_3532.method_16439(partialTicks, this.prevGCol, this.gCol);
    }
    public float getGreen() {
        return this.gCol;
    }

    public float getLerpedBlue(float partialTicks) {
        return class_3532.method_16439(partialTicks, this.prevBCol, this.bCol);
    }
    public float getBlue() {
        return this.bCol;
    }

    public float getLerpedAlpha(float partialTicks) {
        return class_3532.method_16439(partialTicks, this.prevAlpha, this.alpha);
    }
    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float a) {
        this.setAlpha(a, false);
    }
    public void setAlpha(float a, boolean lerp) {
        if(lerp) {
            this.prevAlpha = this.alpha;
        } else {
            this.prevAlpha = a;
        }
        this.alpha = a;
    }

    public void setRGB(float r, float g, float b) {
        this.setRGBA(r, g, b, this.getAlpha(), false);
    }
    public void setRGBA(float r, float g, float b, float a) {
        this.setRGBA(r, g, b, a, false);
    }
    public void setRGBA(float r, float g, float b, float a, boolean lerp) {
        if(lerp) {
            this.prevRCol = this.rCol;
            this.prevGCol = this.gCol;
            this.prevBCol = this.bCol;
            this.prevAlpha = this.alpha;
        } else {
            this.prevRCol = r;
            this.prevGCol = g;
            this.prevBCol = b;
            this.prevAlpha = a;
        }
        this.rCol = r;
        this.gCol = g;
        this.bCol = b;
        this.alpha = a;
    }


    public float getLerpedScale(float partialTicks) {
        return class_3532.method_16439(partialTicks, this.prevScale, this.scale);
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.setScale(scale, false);
    }

    public void setScale(float scale, boolean lerp) {
        if(lerp) {
            this.prevScale = this.scale;
        } else {
            this.prevScale = scale;
        }
        this.scale = scale;
    }

    protected abstract ParticleLayer getParticleLayer();

    public enum ParticleLayer {
        OPAQUE(
            //? if minecraft: <= 1.21.8 {
            /*ParticleRenderType.PARTICLE_SHEET_OPAQUE
             *///?} else {
            class_3940.class_11941.field_62640
            //?}
        ),
        TERRAIN(
            //? if minecraft: <= 1.21.8 {
            /*ParticleRenderType.TERRAIN_SHEET
             *///?} else {
            class_3940.class_11941.field_62639
            //?}
        ),
        TRANSLUCENT(
            //? if minecraft: <= 1.21.8 {
            /*ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT
             *///?} else {
            class_3940.class_11941.field_62641
            //?}
        ),
        BACKFACE_TERRAIN(
            //? if minecraft: <= 1.21.8 {
            /*ModParticleRenderTypes.BACKFACE_TERRAIN_PARTICLE
             *///?} else {
            BACKFACE_TERRAIN_LAYER
            //?}
        );

        //? if minecraft: <= 1.21.8 {
        /*public final ParticleRenderType layer;
         *///?} else {
        public final class_3940.class_11941 layer;
        //?}

        ParticleLayer(
            //? if minecraft: <= 1.21.8 {
            /*ParticleRenderType layer
            *///?} else {
            class_3940.class_11941 layer
            //?}
        ) {
            this.layer = layer;
        }
    }

    public interface BillboardMode {
        BillboardMode FIXED = (quaternion, camera, partialTicks) -> quaternion.set(0.0f, 0.0f, 0.0f, camera.method_23767().w);
        BillboardMode XYZ = (quaternion, camera, partialTicks) -> quaternion.set(camera.method_23767());

        void rotate(Quaternionf quaternion, class_4184 camera, float partialTicks);
    }
}
