package games.enchanted.eg_particle_interactions.common.particle.types.bubble;

import games.enchanted.eg_particle_interactions.common.duck.ParticleAccess;
import games.enchanted.eg_particle_interactions.common.particle.types.ParticleInteractionsParticle;
import games.enchanted.eg_particle_interactions.common.util.MathHelpers;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_3486;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.client.particle.*;
import org.jetbrains.annotations.Nullable;

public class UnderwaterRisingBubble extends ParticleInteractionsParticle {
    protected UnderwaterRisingBubble(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_4002 spriteSet) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, spriteSet.method_18139(level.field_9229));
        this.field_3844 = -0.35F;
        this.field_28786 = 0.85F;
        this.method_3080(0.02F, 0.02F);
        this.setScale(this.getScale() * (this.field_3840.method_43057() * 0.6F + 0.2F));
        this.field_3852 = xSpeed * 0.2F + (Math.random() * 2.0 - 1.0) * 0.02F;
        this.field_3869 = ySpeed * 0.2F + (Math.random() * 2.0 - 1.0) * 0.02F;
        this.field_3850 = zSpeed * 0.2F + (Math.random() * 2.0 - 1.0) * 0.02F;
        this.field_3847 = MathHelpers.randomBetween(100, 600);

        ((ParticleAccess) this).eg_particle_interactions$setBypassMovementCollisionCheck(true);
    }
    
    @Override
    public void method_3070() {
        super.method_3070();
        if (this.field_3866 > 1 && !this.field_3843 && !this.field_3851.method_8316(class_2338.method_49637(this.field_3874, this.field_3854 + 0.125f, this.field_3871)).method_15767(class_3486.field_15517)) {
            this.popAndRemove();
        }
        else if(this.field_3866 >= this.field_3847 - 1 || ((ParticleAccess) this).eg_particle_interactions$isStoppedByCollision()) {
            this.popAndRemove();
        }
        this.field_3852 *= 0.9;
        this.field_3850 *= 0.9;

        // if moving upwards
        if(this.field_3869 > 0 && ((ParticleAccess) this).eg_particle_interactions$getBypassMovementCollisionCheck()) {
            ((ParticleAccess) this).eg_particle_interactions$setBypassMovementCollisionCheck(false);
        }
    }

    private void popAndRemove() {
        this.field_3851.method_8406(class_2398.field_11241, this.field_3874, this.field_3854, this.field_3871, 0, 0, 0);
        this.method_3085();
    }

    @Override
    protected ParticleLayer getParticleLayer() {
        return ParticleLayer.OPAQUE;
    }

    public static class Provider implements class_707<class_2400> {
        private final class_4002 spriteSet;

        public Provider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            class_2400 options,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            , class_5819 random
            //?}
        ) {
            return new UnderwaterRisingBubble(level, x, y, z, xSpeed, ySpeed, zSpeed, spriteSet);
        }
    }

    public static class SmallProvider implements class_707<class_2400> {
        private final class_4002 spriteSet;

        public SmallProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            class_2400 options,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            , class_5819 random
            //?}
        ) {
            UnderwaterRisingBubble particle = new UnderwaterRisingBubble(level, x, y, z, xSpeed, ySpeed, zSpeed, spriteSet);
            particle.setScale(MathHelpers.randomBetween(0.02f, 0.05f));
            return particle;
        }
    }
}
