package games.enchanted.eg_particle_interactions.common.particle.types.drip;

import games.enchanted.eg_particle_interactions.common.duck.ParticleAccess;
import games.enchanted.eg_particle_interactions.common.particle.types.ParticleInteractionsParticle;
import games.enchanted.eg_particle_interactions.common.particle.options.DripParticleOption;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.client.particle.*;
import org.jetbrains.annotations.Nullable;

public class DripAndLandParticle extends ParticleInteractionsParticle {
    protected boolean hasLanded = false;
    protected final int startFallingAtTicks;
    protected final boolean translucent;

    protected float u0;
    protected float u1;
    protected float v0;
    protected float v1;

    DripAndLandParticle(class_638 level, double x, double y, double z, class_4002 sprites, DripParticleOption dripParticleOption, boolean translucent) {
        super(level, x, y, z, sprites.method_18139(level.field_9229));
        this.translucent = translucent;

        this.method_3080(0.01F, 0.01F);
        this.setScale(0.15f);
        this.field_3844 = dripParticleOption.getGravity() + (level.field_9229.method_43057() * dripParticleOption.getGravityRandomness());

        this.startFallingAtTicks = dripParticleOption.getStartFallingTicks();

        this.u0 = this.sprite.method_4594();
        this.u1 = this.sprite.method_4577();
        this.v0 = this.sprite.method_4593();
        float v1 = this.sprite.method_4575();
        float halfHeight = Math.abs(this.v0 - v1) / 2;
        this.v1 = v1 - halfHeight;

        this.field_3847 = level.field_9229.method_39332(350, 500);
    }

    @Override
    public void method_3070() {
        if (this.field_3843) return;

        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;

        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
        }

        if(this.startFallingAtTicks - this.field_3866 > 30) return;

        if(this.field_3866 < this.startFallingAtTicks) {
            this.field_3869 -= 0.004 / this.startFallingAtTicks;
            this.method_3069(this.field_3852, this.field_3869, this.field_3850);
            return;
        }

        this.field_3869 -= this.field_3844;
        this.method_3069(this.field_3852, this.field_3869, this.field_3850);

        if(this.field_3845) {
            land();
        }

        this.field_3852 *= 0.98F;
        this.field_3869 *= 0.98F;
        this.field_3850 *= 0.98F;
    }

    protected void land() {
        if(this.hasLanded) return;
        this.hasLanded = true;

        float v0 = this.sprite.method_4593();
        this.v1 = this.sprite.method_4575();
        float halfHeight = Math.abs(v0 - this.v1) / 2;
        this.v0 = v0 + halfHeight;

        this.field_3847 = this.field_3866 + field_3851.field_9229.method_43051(30, 60);

        ((ParticleAccess) this).eg_particle_interactions$moveUpBecauseParticleLanded();
        this.billboardYOffset = 1.0f;
    }

    @Override
    protected float getU0() {
        return this.u0;
    }

    @Override
    protected float getU1() {
        return this.u1;
    }

    @Override
    protected float getV0() {
        return this.v0;
    }

    @Override
    protected float getV1() {
        return this.v1;
    }

    @Override
    protected ParticleLayer getParticleLayer() {
        return this.translucent ? ParticleLayer.TRANSLUCENT : ParticleLayer.OPAQUE;
    }

    public static class UntintedDropProvider implements class_707<DripParticleOption> {
        class_4002 sprites;

        public UntintedDropProvider(class_4002 sprites) {
            this.sprites = sprites;
        }

        @Override
        public @Nullable class_703 createParticle(
            DripParticleOption options,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            , class_5819 random
            //?}
        ) {
            return new DripAndLandParticle(level, x, y, z, sprites, options, true);
        }
    }
}
