package games.enchanted.eg_particle_interactions.common.particle.types.dust;

import games.enchanted.eg_particle_interactions.common.config.categories.GeneralOptions;
import games.enchanted.eg_particle_interactions.common.particle.types.ParticleInteractionsParticle;
import net.minecraft.class_2394;
import net.minecraft.class_3532;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_765;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDust extends ParticleInteractionsParticle {
    public static float MIN_SIZE = 0.095f;
    public static float MAX_SIZE = 0.125f;

    protected boolean spawnSpecks;
    protected boolean spriteFromAge;
    protected class_4002 spriteSet;
    protected boolean emissive;

    protected AbstractDust(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_4002 spriteSet, float gravityMultiplier, boolean spawnSpecks, boolean spriteFromAge) {
        super(level, x, y, z, spriteSet.method_18139(level.field_9229));

        this.spawnSpecks = spawnSpecks;
        this.spriteSet = spriteSet;
        this.spriteFromAge = spriteFromAge;

        this.field_3844 = class_3532.method_32750(this.field_3840, 0.25F, 0.38F);;
        this.field_28786 = 1.0F;
        this.field_3852 = xSpeed + (Math.random() * 2.0 - 1.0) * 0.05000000074505806;
        this.field_3869 = ySpeed + (Math.random() * 2.0 - 1.0) * 0.05000000074505806;
        this.field_3850 = zSpeed + (Math.random() * 2.0 - 1.0) * 0.05000000074505806;
        this.field_3847 = (int)(16.0 / ((double)this.field_3840.method_43057() * 0.8 + 0.2)) + 2;
        this.roll = (float) Math.toRadians(this.field_3840.method_39332(0, 360));
        this.prevRoll = this.roll;

        float particleSize = this.field_3840.method_43056() ? MIN_SIZE : MAX_SIZE;
        this.setScale(particleSize);
        this.method_3080(particleSize, particleSize);
        this.field_3844 *= gravityMultiplier;

        if(this.spriteFromAge) {
            this.setSpriteFromAge(this.spriteSet);
        } else {
            this.setSprite(spriteSet.method_18139(this.field_3840));
        }

        this.emissive = false;
    }

    @Override
    public void method_3070() {
        if(this.spriteFromAge) {
            this.setSpriteFromAge(this.spriteSet);
        }

        this.field_3852 *= 0.949999988079071;
        this.field_3869 *= 0.8999999761581421;
        this.field_3850 *= 0.949999988079071;

        this.field_3844 = 0.98F * this.field_3844;
        this.field_28786 = 0.995F * this.field_28786;

        super.method_3070();

        if(!this.spawnSpecks || this.field_3843 || !this.field_3862 || this.field_3845) {
            return;
        }
        if(!GeneralOptions.DUST_SPECKS.getValue()) {
            return;
        }
        if((this.field_3866 < 3 && this.field_3840.method_43057() < 0.23f) || this.field_3840.method_43057() < 0.01f) {
            class_2394 particleOptions = this.getSpeckParticle();
            if(particleOptions != null) {
                this.field_3851.method_8406(particleOptions, this.field_3874, this.field_3854, this.field_3871, this.field_3852 / 2, (this.field_3869 / 2) + 0.05, this.field_3850 / 2);
            }
        }
    }

    @Override
    protected ParticleLayer getParticleLayer() {
        return ParticleLayer.OPAQUE;
    }

    @Override
    protected int method_3068(float partialTick) {
        return this.emissive ? class_765.field_32767 : super.method_3068(partialTick);
    }

    protected abstract @Nullable class_2394 getSpeckParticle();
}