package games.enchanted.eg_particle_interactions.common.particle.types.emitter.random_distribution;

import games.enchanted.eg_particle_interactions.common.particle.types.emitter.AbstractEmitterParticle;
import net.minecraft.class_2394;
import net.minecraft.class_638;
import games.enchanted.eg_particle_interactions.common.particle.options.RandomDistributionEmitterOptions;
import org.joml.Vector3f;

public abstract class AbstractRandomDistributionEmitter extends AbstractEmitterParticle {
    protected double emittedXSpeed;
    protected double emittedYSpeed;
    protected double emittedZSpeed;
    protected int emitterInterval;
    protected int emitterIterations;
    protected int particlesPerEmission;
    protected Vector3f emitterVariance;
    protected boolean emitOnFirstTick;

    protected AbstractRandomDistributionEmitter(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomDistributionEmitterOptions emitterOptions) {
        super(level, x, y, z, emitterOptions.getDimensions().x, emitterOptions.getDimensions().y, emitterOptions.getDimensions().z);
        this.emittedXSpeed = xSpeed;
        this.emittedYSpeed = ySpeed;
        this.emittedZSpeed = zSpeed;
        this.emitterInterval = emitterOptions.getTickInterval();
        this.emitterIterations = emitterOptions.getRepeat();
        this.particlesPerEmission = emitterOptions.getParticlesPerEmission();
        this.emitOnFirstTick = emitterOptions.getEmitOnFirstTick();
        this.emitterVariance = emitterOptions.getVelocityVariance();
        this.method_3077(emitterInterval * emitterIterations);
        this.field_3874 -= (this.emitterWidth / 2);
        this.field_3854 -= (this.emitterHeight / 2);
        this.field_3871 -= (this.emitterDepth / 2);
    }

    @Override
    protected void emitterTick() {
        if((this.field_3866 - (emitOnFirstTick ? 1 : 0)) % emitterInterval == 0) {
            for (int i = 0; i < particlesPerEmission; i++) {
                double[] emitPos = getRandomPositionInsideBounds();
                class_2394 particle = this.getParticleToEmit(field_3851, emitPos[0], emitPos[1], emitPos[2]);
                if(particle == null) continue;
                field_3851.method_8406(
                    particle,
                    emitPos[0],
                    emitPos[1],
                    emitPos[2],
                    this.emittedXSpeed + ((field_3851.field_9229.method_43057() * emitterVariance.x) - (emitterVariance.x / 2)),
                    this.emittedYSpeed + ((field_3851.field_9229.method_43057() * emitterVariance.y) - (emitterVariance.y / 2)),
                    this.emittedZSpeed + ((field_3851.field_9229.method_43057() * emitterVariance.z) - (emitterVariance.z / 2))
                );
            }
        }
    }

    protected double[] getRandomPositionInsideBounds() {
        double newX = field_3874 + (this.emitterWidth * this.field_3851.field_9229.method_43057());
        double newY = field_3854 + (this.emitterHeight * this.field_3851.field_9229.method_43057());
        double newZ = field_3871 + (this.emitterDepth * this.field_3851.field_9229.method_43057());
        return new double[]{newX, newY, newZ};
    }
}
