package games.enchanted.eg_particle_interactions.common.particle.types.physics;

import games.enchanted.eg_particle_interactions.common.particle.render.geometry.QuadConsumer;
import games.enchanted.eg_particle_interactions.common.shapes.QuadFaceShape;
import games.enchanted.eg_particle_interactions.common.shapes.ShapeDefinitions;
import games.enchanted.eg_particle_interactions.common.util.ColourUtil;
import games.enchanted.eg_particle_interactions.common.util.MathHelpers;
import org.jetbrains.annotations.NotNull;
import org.joml.*;

//? if minecraft: > 1.21.8 {
//?} else {
/*import com.mojang.blaze3d.vertex.VertexConsumer;
*///?}

import java.lang.Math;
import net.minecraft.class_1058;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_638;

public abstract class StretchyBouncyShapeParticle extends BouncyParticle {
    protected double prevPrevX;
    protected double prevPrevY;
    protected double prevPrevZ;
    private QuadFaceShape particleShape;
    /**
     * The scale that the particle will be rendered at
     */
    protected Vector3f particleShapeScale;
    protected float prevPitch;
    protected float prevYaw;

    /**
     * A 3d cube particle that stretches between its current and previous position when moving, this particle also has bounce physics
     * Set {@link #physics_canBounce} to false in your particle constructor to disable bouncing
     *
     * @param level  level
     * @param x      x pos
     * @param y      y pos
     * @param z      z pos
     * @param xSpeed x velocity
     * @param ySpeed y velocity
     * @param zSpeed z velocity
     */
    protected StretchyBouncyShapeParticle(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_1058 sprite) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprite);
        this.prevPrevX = this.field_3858;
        this.prevPrevY = this.field_3838;
        this.prevPrevZ = this.field_3856;
        this.field_28787 = true;

        this.particleShapeScale = new Vector3f(1);
        this.setShape(ShapeDefinitions.CUBE);
    }

    @Override
    public void method_3070() {
        this.prevPrevX = this.field_3858;
        this.prevPrevY = this.field_3838;
        this.prevPrevZ = this.field_3856;

        super.method_3070();
    }

    /**
     * Sets the shape that the particle will use to render
     *
     * @param newShape the new shape
     */
    protected void setShape(QuadFaceShape newShape) {
        this.particleShape = newShape;
    }

    protected boolean isParticleMoving() {
        return this.getTotalVelocity() < 0.001;
    }

    @Override
    public @NotNull BillboardMode getBillboardMode() {
        return BillboardMode.FIXED;
    }

    @Override
    protected void adjustPositionBeforeExtraction(QuadConsumer consumer, class_4184 camera, Quaternionf quaternionf, float partialTicks) {
        Vector3f cameraPosition = camera.method_71156().method_46409();

        float xPos = (float) class_3532.method_16436(partialTicks, this.field_3858, this.field_3874);
        float yPos = (float) class_3532.method_16436(partialTicks, this.field_3838, this.field_3854);
        float zPos = (float) class_3532.method_16436(partialTicks, this.field_3856, this.field_3871);
        Vector3f pos = new Vector3f(xPos, yPos, zPos).sub(cameraPosition);
        float prevXPos = (float) class_3532.method_16436(partialTicks, this.prevPrevX, this.field_3858);
        float prevYPos = (float) class_3532.method_16436(partialTicks, this.prevPrevY, this.field_3838);
        float prevZPos = (float) class_3532.method_16436(partialTicks, this.prevPrevZ, this.field_3856);
        Vector3f prevPos = new Vector3f(prevXPos, prevYPos, prevZPos).sub(cameraPosition);

        this.extractShapeGeometry(consumer, pos, prevPos, partialTicks);
    }

    private void extractShapeGeometry(QuadConsumer consumer, Vector3f pos, Vector3f prevPos, float partialTicks) {
        float cuboidSize = this.getLerpedScale(partialTicks);
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        int lightColor = this.method_3068(partialTicks);

        Vector3f normalisedMovementDir = new Vector3f(pos).sub(prevPos).normalize();
        float pitch = (float) Math.toDegrees(Math.asin(normalisedMovementDir.y));
        if(!Float.isFinite(pitch)) pitch = prevPitch;
        prevPitch = pitch;

        float yaw = (float) Math.toDegrees(Math.atan2(normalisedMovementDir.x, normalisedMovementDir.z));
        if(!Float.isFinite(yaw)) yaw = prevYaw;
        prevYaw = yaw;

        Vector3f shapePos = MathHelpers.getPosBetween3DPoints(pos, prevPos);
        Vector3f shapeScale = new Vector3f(1, Math.max(Math.abs(MathHelpers.getDistanceBetweenVectors(pos, prevPos) * 40), 1), 1).mul(this.particleShapeScale);
        Vector3f shapeRotation = new Vector3f(-(pitch - 90), yaw, 0);
        this.particleShape.extractShape(
            consumer,
            new Vector2f[]{new Vector2f(u0, v0), new Vector2f(u1, v1)},
            shapePos,
            shapeScale,
            shapeRotation,
            cuboidSize,
            lightColor,
            ColourUtil.ARGBfloats_to_ARGB(
                this.getLerpedAlpha(partialTicks),
                this.getLerpedRed(partialTicks),
                this.getLerpedGreen(partialTicks),
                this.getLerpedBlue(partialTicks)
            )
        );
    }

    @Override
    public @NotNull class_238 getCullingBox(float partialTicks) {
        // expand the culling box by the size of the particle and move it to the middle of the current pos and previous pos
        double diffX = this.field_3874 - this.field_3858;
        double diffY = this.field_3854 - this.field_3838;
        double diffZ = this.field_3871 - this.field_3856;
        return this.method_3064()
            .method_989(-diffX / 2, -diffY / 2, -diffZ / 2)
            .method_1014(Math.abs(new class_243(this.field_3874, this.field_3854, this.field_3871).method_1022(new class_243(this.field_3858, this.field_3838, this.field_3856)) / 2 ));
    }


    //? if neoforge && minecraft: <= 1.21.8 {
    /*@Override
    public @NotNull AABB getRenderBoundingBox(float partialTicks) {
        // expand the culling box by the size of the particle and move it to the middle of the current pos and previous pos
        double diffX = this.x - this.xo;
        double diffY = this.y - this.yo;
        double diffZ = this.z - this.zo;
        return super.getRenderBoundingBox(partialTicks).move(-diffX / 2, -diffY / 2, -diffZ / 2).inflate( Math.abs(new Vec3(this.x, this.y, this.z).distanceTo(new Vec3(this.xo, this.yo, this.zo)) / 2 ));
    }
    *///?}
}
