package games.enchanted.eg_particle_interactions.common.particle.types.spark;

import games.enchanted.eg_particle_interactions.common.config.categories.GeneralOptions;
import games.enchanted.eg_particle_interactions.common.particle.ModParticleTypes;
import games.enchanted.eg_particle_interactions.common.particle.types.physics.StretchyBouncyShapeParticle;
import games.enchanted.eg_particle_interactions.common.shapes.ShapeDefinitions;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2400;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_765;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlyingSpark extends StretchyBouncyShapeParticle {
    private final class_4002 sprites;
    private boolean isSoul;
    protected boolean hasSpawnedSmokeParticle = false;
    private static final int SPARK_UNDERWATER_DECAY_SPEED = 3;

    protected FlyingSpark(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, float gravity, int lifetime, class_4002 spriteSet) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, spriteSet.method_18139(level.field_9229));
        this.field_3844 = gravity;
        this.field_28786 = 1.0F;

        this.field_3852 = (xSpeed / 2) + (Math.random() * 3.0 - 1.5) * 0.05000000074505806 * (this.field_3840.method_43057() > 0.95 ? 2 : 1);
        this.field_3869 = (ySpeed / 2) + (Math.random() * 3.0 - 1.5) * 0.05000000074505806 * (this.field_3840.method_43057() > 0.95 ? 2 : 1);
        this.field_3850 = (zSpeed / 2) + (Math.random() * 3.0 - 1.5) * 0.05000000074505806 * (this.field_3840.method_43057() > 0.95 ? 2 : 1);

        this.physics_bounciness = 0.8f;
        this.physics_passThroughFluidSpeed = 0.93f;

        this.field_3847 = lifetime;

        float particleSize = (this.field_3840.method_43056() ? 0.025F : 0.03F);
        this.method_3080(particleSize, particleSize);
        this.setScale(particleSize);

        this.sprites = spriteSet;
        this.setSpriteFromAge(this.sprites);

        this.setShape(ShapeDefinitions.VERTICAL_CROSS);
        this.particleShapeScale.x = class_3532.method_32750(level.field_9229, 0.4f, 1.1f);
        this.particleShapeScale.z = class_3532.method_32750(level.field_9229, 0.4f, 1.1f);

        this.isSoul = false;
    }

    protected FlyingSpark(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, float gravity, int lifetime, class_4002 spriteSet, boolean isSoul) {
        this(level, x, y, z, xSpeed, ySpeed, zSpeed, gravity, lifetime, spriteSet);
        this.isSoul = isSoul;
    }

    @Override
    public void method_3070() {
        super.method_3070();
        if(field_3866 < 0 || this.field_3843) {
            return;
        }

        this.setSpriteFromAge(this.sprites);

        float percentageTimeUntilDeath = (float) this.field_3866 / this.field_3847;

        // spawn random spark flashes
        if(
            (
                GeneralOptions.ADDITIONAL_SPARK_FLASH_EFFECT.getValue() &&
                !this.hasEnteredWater
            )
            &&
            (
                this.field_3840.method_43057() > percentageTimeUntilDeath + 0.8f ||
                (this.field_3840.method_43057() < 0.01f && this.isParticleMoving())
            )
        ) {
            this.field_3851.method_8406(this.isSoul ? ModParticleTypes.SOUL_SPARK_FLASH : ModParticleTypes.SPARK_FLASH, this.prevPrevX, this.prevPrevY, this.prevPrevZ, 0, 0, 0);
        }

        if(!GeneralOptions.SPARK_WATER_EVAPORATION.getValue()) {
            this.hasSpawnedSmokeParticle = true;
        }
        if(this.hasEnteredWater && !this.hasSpawnedSmokeParticle) {
            this.field_3851.method_8406(ModParticleTypes.WATER_VAPOUR, this.field_3858, this.field_3838, this.field_3856, this.field_3852 / 6, -this.field_3869 / 2, this.field_3850 / 6);
            this.field_3851.method_8486(this.field_3858, this.field_3838, this.field_3856, class_3417.field_15222, class_3419.field_15256, 0.15f, 1.2f, false);
            this.hasSpawnedSmokeParticle = true;
        }
    }

    protected int getShortenedAge() {
        return Math.clamp((long) this.field_3866 * (this.hasEnteredWater ? SPARK_UNDERWATER_DECAY_SPEED : 1), 0, this.field_3847);
    }

    @Override
    public void setSpriteFromAge(@NotNull class_4002 sprite) {
        if (!this.field_3843) {
            int adjustedAge = this.getShortenedAge();
            this.setSprite(sprite.method_18138(adjustedAge, this.field_3847));
        }
    }

    @Override
    public int method_3068(float partialTicks) {
        int adjustedAge = this.getShortenedAge();
        float percentageTimeAlive = Math.abs(1 - ((float) adjustedAge / this.field_3847));
        int sparkLight = (int) (percentageTimeAlive * 15f);

        class_2338 pos = class_2338.method_49637(this.field_3874, this.field_3854, this.field_3871);
        int blockLight = this.field_3851.method_8314(class_1944.field_9282, pos);
        int skyLight = this.field_3851.method_8314(class_1944.field_9284, pos);

        return class_765.method_23687(Math.max(blockLight, sparkLight), skyLight);
    }

    @Override
    protected ParticleLayer getParticleLayer() {
        return ParticleLayer.OPAQUE;
    }

    public static class FlyingSparkProvider implements class_707<class_2400> {
        private final class_4002 spriteSet;

        public FlyingSparkProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            class_2400 type,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            , class_5819 random
            //?}
        ) {
            return new FlyingSpark(level, x, y, z, xSpeed, ySpeed, zSpeed, class_3532.method_32750(level.field_9229, 0.8F, 0.9F), class_3532.method_32751(level.field_9229, 20, 60), spriteSet);
        }
    }

    public static class FloatingSparkProvider implements class_707<class_2400> {
        private final class_4002 spriteSet;

        public FloatingSparkProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            class_2400 type,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            , class_5819 random
            //?}
        ) {
            return new FlyingSpark(level, x, y, z, xSpeed, ySpeed, zSpeed, class_3532.method_32750(level.field_9229, 0.2F, 0.3F), class_3532.method_32751(level.field_9229, 4, 12), spriteSet);
        }
    }

    public static class FlyingSoulSparkProvider implements class_707<class_2400> {
        private final class_4002 spriteSet;

        public FlyingSoulSparkProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            class_2400 type,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            , class_5819 random
            //?}
        ) {
            return new FlyingSpark(level, x, y, z, xSpeed, ySpeed, zSpeed, class_3532.method_32750(level.field_9229, 0.8F, 0.9F), class_3532.method_32751(level.field_9229, 20, 60), spriteSet, true);
        }
    }

    public static class FloatingSoulSparkProvider implements class_707<class_2400> {
        private final class_4002 spriteSet;

        public FloatingSoulSparkProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            class_2400 type,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            , class_5819 random
            //?}
        ) {
            return new FlyingSpark(level, x, y, z, xSpeed, ySpeed, zSpeed, class_3532.method_32750(level.field_9229, 0.2F, 0.3F), class_3532.method_32751(level.field_9229, 4, 12), spriteSet, true);
        }
    }
}
