package games.enchanted.eg_particle_interactions.common.particle_spawning;

import games.enchanted.eg_particle_interactions.common.util.MathHelpers;
import org.jetbrains.annotations.NotNull;

import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class SpawnParticlesUtil {
    public static boolean isParticleOutsideRenderDistance(@NotNull ParticleCategory particleCategory, class_2338 particlePos) {
        return isParticleOutsideRenderDistance(particleCategory, particlePos.method_10263(), particlePos.method_10264(), particlePos.method_10260());
    }

    public static boolean isParticleOutsideRenderDistance(@NotNull ParticleCategory particleCategory, double x, double y, double z) {
        class_746 player = class_310.method_1551().field_1724;
        if(player == null) return false;

        double distanceFromPlayer = MathHelpers.getDistanceBetweenPoints(player.method_23317() / 16, player.method_23318() / 16, player.method_23321() / 16, x / 16, y / 16, z / 16);
        double maxDistance = Math.min(particleCategory.getMaxDistance(), class_310.method_1551().field_1690.method_42503().method_41753());

        return distanceFromPlayer >= maxDistance;
    }

    /**
     * Spawns a particle option in a flat circular shape
     *
     * @param particleOptions            particle options to spawn
     * @param level                      level
     * @param center                     center of the circle
     * @param amount                     amount of particles to spawn
     * @param spread                     how far particles can deviate from the radius (in blocks)
     * @param radius                     the distance to spawn particles from the center position (in blocks)
     * @param outwardVelocityMultiplier  how quickly particles should fly out from the center
     * @param verticalVelocityBase       base vertical velocity for all particles
     * @param verticalVelocityMultiplier multiplied by particle distance from the center
     */
    public static void spawnParticleInCircle(class_2394 particleOptions, class_638 level, class_243 center, int amount, float spread, float radius, float outwardVelocityMultiplier, float verticalVelocityBase, float verticalVelocityMultiplier) {
        spawnParticleInCircle(() -> particleOptions, level, center, amount, spread, radius, outwardVelocityMultiplier, verticalVelocityBase, verticalVelocityMultiplier);
    }

    /**
     * Spawns a particle option in a flat circular shape
     *
     * @param particleOptions            supplier for particle options to spawn
     * @param level                      level
     * @param center                     center of the circle
     * @param amount                     amount of particles to spawn
     * @param spread                     how far particles can deviate from the radius (in blocks)
     * @param radius                     the distance to spawn particles from the center position (in blocks)
     * @param outwardVelocityMultiplier  how quickly particles should fly out from the center
     * @param verticalVelocityBase       base vertical velocity for all particles
     * @param verticalVelocityMultiplier multiplied by particle distance from the center
     */
    public static void spawnParticleInCircle(Supplier<class_2394> particleOptions, class_638 level, class_243 center, int amount, float spread, float radius, float outwardVelocityMultiplier, float verticalVelocityBase, float verticalVelocityMultiplier) {
        float randomAngleOffset = (float) Math.toRadians(MathHelpers.randomBetween(0, 360f));
        radius /= 2;
        for (int i = 0; i < amount; i++) {
            float progressRadians = (float) Math.toRadians(((float) i / amount) * 360f) + randomAngleOffset;
            double distX = (radius * Math.cos(progressRadians)) + MathHelpers.randomBetween(-(spread / 2), spread / 2);
            double distZ = (radius * Math.sin(progressRadians)) + MathHelpers.randomBetween(-(spread / 2), spread / 2);
            double x = center.field_1352 + distX;
            double z = center.field_1350 + distZ;
            double distFromCenter = Math.max(Math.abs(distX), Math.abs(distZ));
            level.method_8406(particleOptions.get(), x, center.field_1351, z, Math.clamp(distX, -1, 1) * outwardVelocityMultiplier, verticalVelocityBase + (Math.abs(radius + (spread / 2) - distFromCenter) * verticalVelocityMultiplier), Math.clamp(distZ, -1, 1) * outwardVelocityMultiplier);
        }
    }

    public static void spawnMostlyUpwardsMotionParticleOption(class_1937 level, class_2394 particleOptions, double xPos, double yPos, double zPos, double velocityIntensity) {
        level.method_8406(
            particleOptions,
            xPos,
            yPos,
            zPos,
            (level.field_9229.method_43058() - 0.5) * velocityIntensity * 0.4,
            Math.abs((level.field_9229.method_43058() - 0.25) * velocityIntensity) + 0.25,
            (level.field_9229.method_43058() - 0.5) * velocityIntensity * 0.4
        );
    }
}
