package games.enchanted.eg_particle_interactions.common.registry;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.class_2960;

/**
 * A type that stores a resource location for a {@link net.minecraft.class_2248} or the resource location of a block tag
 */
public record BlockOrTagLocation(class_2960 location, boolean isTag) {
    public static Codec<BlockOrTagLocation> CODEC = Codec.STRING.comapFlatMap(
        string -> {
            class_2960 parsedLocation = class_2960.method_60654(string.replace("#", ""));
            return DataResult.success(new BlockOrTagLocation(parsedLocation, string.startsWith("#")));
        },
        BlockOrTagLocation::toString
    );

    public BlockOrTagLocation(class_2960 location) {
        this(location, false);
    }

    @Override
    public String toString() {
        return (this.isTag() ? "#" : "") + location.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if(!(obj instanceof BlockOrTagLocation castedObj)) return false;
        return this.location.equals(castedObj.location);
    }
}
