package games.enchanted.eg_particle_interactions.common.registry;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_151;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class RegistryHelpers {
    @SuppressWarnings("unchecked")
    public static <R, T extends R> T register(class_5321<? extends class_2378<R>> registryKey, Supplier<T> entry, class_2960 key) {
        class_2378<R> registry = Objects.requireNonNull( class_7923.field_41167.method_29107((class_5321) registryKey));
        return class_2378.method_10230(registry, key, entry.get());
    }

    public static <T> Stream<class_2960> getMatchingLocations(String search, class_7922<T> registryToSearch) {
        int separatorIndex = search.indexOf(':');
        String unspacedSearch = search.replace(' ', '_');
        Predicate<class_2960> filterPredicate = getFilterPredicate(unspacedSearch, separatorIndex, registryToSearch);

        return registryToSearch.method_10235().stream()
            .filter(filterPredicate)
            .sorted((location1, location2) -> {
                String path = (separatorIndex == -1 ? unspacedSearch : unspacedSearch.substring(separatorIndex + 1)).toLowerCase();
                boolean location1StartsWith = location1.method_12832().toLowerCase().startsWith(path);
                boolean location2StartsWith = location2.method_12832().toLowerCase().startsWith(path);
                if (location1StartsWith) {
                    return location2StartsWith ? location1.method_12833(location2) : -1;
                } else {
                    return location2StartsWith ? 1 : location1.method_12833(location2);
                }
            }
        );
    }

    public static <T> Stream<class_2960> getMatchingTagLocations(String search, class_7922<T> registryToSearch) {
        int separatorIndex = search.indexOf(':');
        String unspacedSearch = search.replace(' ', '_');
        Predicate<class_2960> filterPredicate = getFilterPredicate(unspacedSearch, separatorIndex, registryToSearch);

        return registryToSearch.method_40272()
            .map(tag -> tag.method_40251().comp_327())
            .filter(filterPredicate)
            .sorted((location1, location2) -> {
                    String path = (separatorIndex == -1 ? unspacedSearch : unspacedSearch.substring(separatorIndex + 1)).toLowerCase();
                    boolean location1StartsWith = location1.method_12832().toLowerCase().startsWith(path);
                    boolean location2StartsWith = location2.method_12832().toLowerCase().startsWith(path);
                    if (location1StartsWith) {
                        return location2StartsWith ? location1.method_12833(location2) : -1;
                    } else {
                        return location2StartsWith ? 1 : location1.method_12833(location2);
                    }
                }
            );
    }

    private static @NotNull <T> Predicate<class_2960> getFilterPredicate(String search, int separatorIndex, class_7922<T> registryToSearch) {
        Predicate<class_2960> filterPredicate;
        if (separatorIndex == -1) {
            filterPredicate = (class_2960 location) -> location.method_12832().contains(search) || (registryToSearch.method_10223(location)).toString().toLowerCase().contains(search.toLowerCase());
        } else {
            String namespace = search.substring(0, separatorIndex);
            String path = search.substring(separatorIndex + 1);
            filterPredicate = (class_2960 location) -> location.method_12836().equals(namespace) && location.method_12832().startsWith(path);
        }
        return filterPredicate;
    }

    public static class_3611 getDefaultedFluid(String location, class_3611 fallback) {
        try {
            class_2960 fluidLocation = class_2960.method_60654(location.toLowerCase());
            Optional<class_3611> fluidFromLoc = class_7923.field_41173.method_17966(fluidLocation);
            if(fluidFromLoc.isEmpty()) {
                return fallback;
            }
            if(fluidFromLoc.get() == class_3612.field_15906) {
                return fallback;
            }
            return fluidFromLoc.get();
        } catch (class_151 ignored) {}
        return fallback;
    }

    public static class_2960 validateBlockLocationWithFallback(String location, class_2960 fallback) {
        try {
            class_2960 blockLocation = class_2960.method_60654(location.toLowerCase());
            Optional<class_2248> blockFromLoc = class_7923.field_41175.method_17966(blockLocation);
            if(blockFromLoc.isEmpty()) {
                return fallback;
            }
            if(blockFromLoc.get().method_9564().method_26215()) {
                return fallback;
            }
            return blockLocation;
        } catch (class_151 ignored) {}
        return fallback;
    }

    public static BlockOrTagLocation validateBlockOrTagLocationWithFallback(String location, BlockOrTagLocation fallback) {
        try {
            if(location.startsWith("#")) {
                return new BlockOrTagLocation(class_2960.method_60654(location.replace("#", "").toLowerCase()), true);
            }

            class_2960 blockLocation = class_2960.method_60654(location.toLowerCase());
            Optional<class_2248> blockFromLoc = class_7923.field_41175.method_17966(blockLocation);
            if(blockFromLoc.isEmpty()) {
                return fallback;
            }
            if(blockFromLoc.get().method_9564().method_26215()) {
                return fallback;
            }
            return new BlockOrTagLocation(blockLocation);
        } catch (class_151 ignored) {}

        return fallback;
    }

    public static class_2960 validateFluidLocationWithFallback(String location, class_2960 fallback) {
        try {
            class_2960 fluidLocation = class_2960.method_60654(location.toLowerCase());
            Optional<class_3611> blockFromLoc = class_7923.field_41173.method_17966(fluidLocation);
            if(blockFromLoc.isEmpty()) {
                return fallback;
            }
            if(blockFromLoc.get().method_15785().method_15759().method_26215()) {
                return fallback;
            }
            return fluidLocation;
        } catch (class_151 ignored) {}
        return fallback;
    }


    public static class_2960 getLocationFromFluid(class_3611 fluid) {
        return class_7923.field_41173.method_10221(fluid);
    }
    public static class_3611 getFluidFromLocation(class_2960 location) {
        return class_7923.field_41173.method_63535(location);
    }

    public static class_2960 getLocationFromBlock(class_2248 block) {
        return class_7923.field_41175.method_10221(block);
    }
    public static BlockOrTagLocation getBlockLocationFromBlock(class_2248 block) {
        return new BlockOrTagLocation(getLocationFromBlock(block));
    }
    public static class_2248 getBlockFromLocation(class_2960 location) {
        return class_7923.field_41175.method_63535(location);
    }
    public static class_6880<class_2248> getBlockHolderFromLocation(class_2960 location) {
        return class_7923.field_41175.method_47983(getBlockFromLocation(location));
    }

    public static boolean isBlockInTag(class_2960 blockLocation, class_6862<class_2248> tagKey) {
        Optional<class_6885.class_6888<class_2248>> tagHolder = class_7923.field_41175.method_46733(tagKey);
        if(tagHolder.isEmpty()) return false;

        class_6880<class_2248> blockHolder = getBlockHolderFromLocation(blockLocation);
        return tagHolder.get().method_40241(blockHolder);
    }
    public static class_6862<class_2248> getBlockTagKey(class_2960 tagLocation) {
        return class_6862.method_40092(class_7924.field_41254, tagLocation);
    }

    public static List<class_2960> getLoadedBlockTags() {
        return class_7923.field_41175.method_40272().map(t -> t.method_40251().comp_327()).toList();
    }


    public static @Nullable class_2378<class_1959> getBiomeRegistry() {
        if(class_310.method_1551().field_1687 == null) return null;
        return class_310.method_1551().field_1687.method_30349().method_30530(class_7924.field_41236);
    }
    public static @Nullable class_1959 getBiomeFromLocation(class_2960 location) {
        class_2378<class_1959> biomeReg = getBiomeRegistry();
        if(biomeReg == null) return null;
        return biomeReg.method_63535(location);
    }
    public static @Nullable class_2960 getLocationFromBiome(class_1959 biome) {
        class_2378<class_1959> biomeReg = getBiomeRegistry();
        if(biomeReg == null) return null;
        return biomeReg.method_10221(biome);
    }
    public static @Nullable class_6880<class_1959> getBiomeHolderFromLocation(class_2960 location) {
        class_2378<class_1959> biomeReg = getBiomeRegistry();
        class_1959 biome = getBiomeFromLocation(location);
        if(biomeReg == null || biome == null) return null;
        return biomeReg.method_47983(biome);
    }
    public static boolean isBiomeInTag(class_2960 biomeLocation, class_6862<class_1959> tagKey) {
        if(class_310.method_1551().field_1687 == null) return false;
        Optional<class_6885.class_6888<class_1959>> tagHolder = class_310.method_1551().field_1687.method_30349().method_30530(class_7924.field_41236).method_46733(tagKey);
        if(tagHolder.isEmpty()) return false;

        class_6880<class_1959> biomeHolder = getBiomeHolderFromLocation(biomeLocation);
        if(biomeHolder == null) return false;
        return tagHolder.get().method_40241(biomeHolder);
    }
    public static class_6862<class_1959> getBiomeTagKey(class_2960 tagLocation) {
        return class_6862.method_40092(class_7924.field_41236, tagLocation);
    }

}
