/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonReader;
import games.enchanted.eg_particle_interactions.common.Logging;
import games.enchanted.eg_particle_interactions.common.config.ConfigCategory;
import games.enchanted.eg_particle_interactions.common.config.categories.BlockInteractionOptions;
import games.enchanted.eg_particle_interactions.common.config.categories.BlockOverrideOptions;
import games.enchanted.eg_particle_interactions.common.config.categories.EntityOptions;
import games.enchanted.eg_particle_interactions.common.config.categories.FluidAmbientOptions;
import games.enchanted.eg_particle_interactions.common.config.categories.FluidPlacementOptions;
import games.enchanted.eg_particle_interactions.common.config.categories.GeneralOptions;
import games.enchanted.eg_particle_interactions.common.config.categories.ItemInteractionOptions;
import games.enchanted.eg_particle_interactions.common.config.option.ConfigOption;
import games.enchanted.eg_particle_interactions.common.platform.PlatformHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigOptions {
    private static final Map<ConfigCategory, List<ConfigOption<?>>> OPTIONS;
    private static Map<ConfigCategory, List<ConfigOption<?>>> TEMPORARY_REGISTRATION_MAP;
    private static final String FILE_NAME = "eg_particle_interactions.json";

    public static <T> ConfigOption<T> registerOption(ConfigCategory category, ConfigOption<T> option) {
        if (TEMPORARY_REGISTRATION_MAP == null) {
            throw new IllegalStateException("Tried to call registerOption after config has already been initialized. Category: " + category.id() + ", Option: " + option.getJsonKey());
        }
        TEMPORARY_REGISTRATION_MAP.computeIfAbsent(category, c -> new ArrayList());
        TEMPORARY_REGISTRATION_MAP.get(category).add(option);
        return option;
    }

    private static File getConfigFile() {
        return PlatformHelper.getConfigPath().resolve(FILE_NAME).toFile();
    }

    public static void applyAndSaveConfig() {
        boolean anyDirty = false;
        for (Map.Entry<ConfigCategory, List<ConfigOption<?>>> entry : OPTIONS.entrySet()) {
            List<ConfigOption<?>> options = entry.getValue();
            if (options.stream().noneMatch(ConfigOption::isDirty)) {
                anyDirty = true;
            }
            for (ConfigOption<?> option : options) {
                if (!option.isDirty()) continue;
                option.applyPendingValue();
            }
        }
        if (!anyDirty) {
            return;
        }
        ConfigOptions.saveConfig();
    }

    public static void saveConfig() {
        JsonObject root = new JsonObject();
        for (Map.Entry<ConfigCategory, List<ConfigOption<?>>> entry : OPTIONS.entrySet()) {
            List<ConfigOption<?>> options = entry.getValue();
            JsonObject categoryRoot = new JsonObject();
            for (ConfigOption<?> option : options) {
                JsonElement encodedOption;
                if (option.isDefault() || (encodedOption = option.toJson()) == null) continue;
                categoryRoot.add(option.getJsonKey(), encodedOption);
            }
            root.add(entry.getKey().id(), (JsonElement)categoryRoot);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String encodedJson = gson.toJson((JsonElement)root);
        try (FileWriter writer = new FileWriter(ConfigOptions.getConfigFile());){
            writer.write(encodedJson);
        }
        catch (IOException e) {
            Logging.error("Failed to write config file '{}', {}", FILE_NAME, e);
        }
    }

    public static void readConfig() {
        Gson gson = new Gson();
        JsonObject decodedConfig = new JsonObject();
        try {
            JsonReader jsonReader = gson.newJsonReader((Reader)new FileReader(ConfigOptions.getConfigFile()));
            jsonReader.setStrictness(Strictness.LENIENT);
            decodedConfig = JsonParser.parseReader((JsonReader)jsonReader).getAsJsonObject();
        }
        catch (JsonParseException e) {
            Logging.error("Failed to parse config file '{}', {}", new Object[]{FILE_NAME, e});
        }
        catch (FileNotFoundException e) {
            Logging.info("Config file '{}' not found", FILE_NAME);
            ConfigOptions.saveConfig();
        }
        for (Map.Entry<ConfigCategory, List<ConfigOption<?>>> entry : OPTIONS.entrySet()) {
            List<ConfigOption<?>> options = entry.getValue();
            JsonObject categoryRoot = decodedConfig.getAsJsonObject(entry.getKey().id());
            if (categoryRoot == null) continue;
            for (ConfigOption<?> option : options) {
                option.fromJson(categoryRoot);
                option.applyPendingValue();
            }
        }
    }

    public static void resetAndSaveAllOptions() {
        ConfigOptions.iterateOptions((category, option) -> option.resetToDefault(true));
        ConfigOptions.saveConfig();
    }

    public static void clearAllPendingValues() {
        ConfigOptions.iterateOptions((category, option) -> option.clearPendingValue());
    }

    public static void iterateOptions(OptionAcceptor optionAcceptor) {
        for (Map.Entry<ConfigCategory, List<ConfigOption<?>>> entry : OPTIONS.entrySet()) {
            ConfigCategory category = entry.getKey();
            for (ConfigOption<?> option : entry.getValue()) {
                optionAcceptor.accept(category, option);
            }
        }
    }

    static {
        TEMPORARY_REGISTRATION_MAP = new HashMap();
        GeneralOptions.init();
        BlockOverrideOptions.init();
        BlockInteractionOptions.init();
        ItemInteractionOptions.init();
        EntityOptions.init();
        FluidPlacementOptions.init();
        FluidAmbientOptions.init();
        OPTIONS = Map.copyOf(TEMPORARY_REGISTRATION_MAP);
        TEMPORARY_REGISTRATION_MAP = null;
    }

    @FunctionalInterface
    public static interface OptionAcceptor {
        public void accept(ConfigCategory var1, ConfigOption<?> var2);
    }
}

