/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.config.option;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.isxander.yacl3.api.Binding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigOption<T> {
    @Nullable
    private T pendingValue;
    protected T value;
    private final T defaultValue;
    private final String jsonKey;

    protected ConfigOption(T initialAndDefaultValue, String jsonKey) {
        this.value = initialAndDefaultValue;
        this.defaultValue = initialAndDefaultValue;
        this.jsonKey = jsonKey;
    }

    public String getJsonKey() {
        return this.jsonKey;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getValue() {
        return this.value;
    }

    @Nullable
    public T getPendingValue() {
        return this.pendingValue;
    }

    public T getPendingOrCurrentValue() {
        return this.pendingValue == null ? this.value : this.pendingValue;
    }

    public void setPendingValue(@NotNull T value) {
        this.pendingValue = value;
    }

    protected void setValueOrPending(T value) {
        if (this.isDirty()) {
            this.setPendingValue(value);
        } else {
            this.value = value;
        }
    }

    public void clearPendingValue() {
        this.pendingValue = null;
    }

    public void applyPendingValue() {
        if (this.pendingValue == null) {
            return;
        }
        this.value = this.pendingValue;
        this.pendingValue = null;
    }

    public void resetToDefault(boolean force) {
        if (force) {
            this.clearPendingValue();
            this.value = this.getDefaultValue();
        } else {
            this.setValueOrPending(this.getDefaultValue());
        }
    }

    public boolean isDefault() {
        return this.getValue().equals(this.getDefaultValue());
    }

    @Nullable
    public abstract JsonElement toJson();

    public abstract void fromJson(JsonObject var1);

    public boolean isDirty() {
        return this.pendingValue != null;
    }

    public Binding<T> createBinding() {
        return Binding.generic(this.getDefaultValue(), this::getPendingOrCurrentValue, this::setPendingValue);
    }
}

