/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.config.option.enums;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import games.enchanted.eg_particle_interactions.common.Logging;
import games.enchanted.eg_particle_interactions.common.config.option.ConfigOption;
import net.minecraft.class_3542;
import org.jetbrains.annotations.Nullable;

public abstract class EnumOption<T extends Enum<T>>
extends ConfigOption<T> {
    protected EnumOption(T initialAndDefaultValue, String jsonKey) {
        super(initialAndDefaultValue, jsonKey);
    }

    @Override
    @Nullable
    public JsonElement toJson() {
        DataResult encodedResult = this.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((Enum)this.getValue()));
        if (encodedResult.isError()) {
            Logging.error("Failed to encode config option {}", this.getJsonKey(), ((DataResult.Error)encodedResult.error().orElseThrow()).message());
        }
        return (JsonElement)encodedResult.getOrThrow();
    }

    @Override
    public void fromJson(JsonObject json) {
        JsonPrimitive jsonElement = json.getAsJsonPrimitive(this.getJsonKey());
        DataResult parsedResult = this.getCodec().parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
        if (parsedResult.isError()) {
            this.resetToDefault(false);
            return;
        }
        Enum result = (Enum)parsedResult.getOrThrow();
        this.setPendingValue(result);
    }

    protected abstract class_3542.class_7292<T> getCodec();
}

