/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.config.screen.yacl;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.ListOptionEntry;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import games.enchanted.eg_particle_interactions.common.config.categories.GeneralOptions;
import games.enchanted.eg_particle_interactions.common.config.option.ConfigOption;
import games.enchanted.eg_particle_interactions.common.config.screen.yacl.controller.BlockLocationController;
import games.enchanted.eg_particle_interactions.common.config.screen.yacl.controller.FluidLocationController;
import games.enchanted.eg_particle_interactions.common.localisation.ConfigTranslation;
import games.enchanted.eg_particle_interactions.common.particle.overrides.BlockParticleOverride;
import games.enchanted.eg_particle_interactions.common.registry.BlockOrTagLocation;
import games.enchanted.eg_particle_interactions.common.registry.RegistryHelpers;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

class ConfigScreenHelper {
    ConfigScreenHelper() {
    }

    public static OptionGroup createSeparator() {
        return OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"eg_particle_interactions.config.category_separator").method_54663(-9671572)).collapsed(true).option((Option)LabelOption.createBuilder().line((class_2561)class_2561.method_43473()).build()).build();
    }

    public static Option<Boolean> booleanOption(String booleanOptionLabelText, String particleTypeKey, ConfigOption<Boolean> option) {
        return Option.createBuilder().name(ConfigTranslation.createPlaceholder(ConfigTranslation.getGlobalOption(booleanOptionLabelText).toComponent(), class_2561.method_43471((String)ConfigTranslation.getParticleType(particleTypeKey).toString()).getString())).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createPlaceholder(ConfigTranslation.createDesc(ConfigTranslation.getGlobalOption(booleanOptionLabelText)), class_2561.method_43471((String)ConfigTranslation.getParticleType(particleTypeKey).toString()).getString())})).binding(option.createBinding()).controller(opt -> BooleanControllerBuilder.create((Option)opt).yesNoFormatter().coloured(true)).build();
    }

    public static Option<Boolean> genericBooleanOption(String optionName, ConfigOption<Boolean> option) {
        ConfigTranslation.TranslationKey translationKey = ConfigTranslation.getGlobalOption(optionName);
        return Option.createBuilder().name(translationKey.toComponent()).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createDesc(translationKey)})).binding(option.createBinding()).controller(opt -> BooleanControllerBuilder.create((Option)opt).yesNoFormatter().coloured(true)).build();
    }

    public static Option<Integer> integerSliderOption(String optionName, ConfigOption<Integer> option, int min, int max, int step) {
        return ConfigScreenHelper.createIntegerOption(option, ConfigTranslation.getGlobalOption(optionName).toComponent(), ConfigTranslation.createDesc(ConfigTranslation.getGlobalOption(optionName)), min, max, step);
    }

    public static Option<Integer> integerSliderOption(String optionName, String particleTypeKey, ConfigOption<Integer> option, int min, int max, int step) {
        return ConfigScreenHelper.createIntegerOption(option, ConfigTranslation.createPlaceholder(ConfigTranslation.getGlobalOption(optionName).toComponent(), class_2561.method_43471((String)ConfigTranslation.getParticleType(particleTypeKey).toString()).getString()), ConfigTranslation.createPlaceholder(ConfigTranslation.createDesc(ConfigTranslation.getGlobalOption(optionName)), class_2561.method_43471((String)ConfigTranslation.getParticleType(particleTypeKey).toString()).getString()), min, max, step);
    }

    public static Option<Integer> createIntegerOption(ConfigOption<Integer> option, class_2561 name, class_2561 description, int min, int max, int step) {
        return Option.createBuilder().name(name).description(OptionDescription.of((class_2561[])new class_2561[]{description})).binding(option.createBinding()).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)min, (Number)max)).step((Number)step)).build();
    }

    public static ListOption<BlockOrTagLocation> createBlockLocationListOption(String particleTypeKey, String groupName, String category, ConfigOption<List<BlockOrTagLocation>> option) {
        return ConfigScreenHelper.createListOption(new BlockOrTagLocation(RegistryHelpers.getLocationFromBlock(class_2246.field_10340)), BlockLocationController::new, particleTypeKey, groupName, category, GeneralOptions.AUTO_COLLAPSE_CONFIG_LISTS.getValue(), option);
    }

    public static ListOption<class_2960> createFluidListOption(String particleTypeKey, String groupName, String category, ConfigOption<List<class_2960>> option) {
        return ConfigScreenHelper.createListOption(RegistryHelpers.getLocationFromFluid((class_3611)class_3612.field_15910), FluidLocationController::new, particleTypeKey, groupName, category, GeneralOptions.AUTO_COLLAPSE_CONFIG_LISTS.getValue(), option);
    }

    public static <T> ListOption<T> createListOption(T initial, Function<ListOptionEntry<T>, Controller<T>> controller, String particleTypeKey, String groupName, String category, boolean collapsedByDefault, ConfigOption<List<T>> option) {
        ConfigTranslation.TranslationKey groupNameKey = ConfigTranslation.getGroupName(category, groupName);
        return ListOption.createBuilder().name(ConfigTranslation.createPlaceholder(groupNameKey.toComponent(), class_2561.method_43471((String)ConfigTranslation.getParticleType(particleTypeKey).toString()).getString())).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createPlaceholder(ConfigTranslation.createDesc(groupNameKey), class_2561.method_43471((String)ConfigTranslation.getParticleType(particleTypeKey).toString()).getString())})).binding(option.createBinding()).customController(controller).collapsed(collapsedByDefault).initial(initial).build();
    }

    public static Option<Integer> maxParticlesOnPlaceOption(String optionName, ConfigOption<Integer> option) {
        return ConfigScreenHelper.integerSliderOption(optionName, option, 0, 16, 1);
    }

    public static Option<Integer> maxParticlesOnBreakOption(String optionName, ConfigOption<Integer> option) {
        return ConfigScreenHelper.integerSliderOption(optionName, option, 0, 8, 1);
    }

    public static ConfigCategory.Builder createBlockParticleOverrideConfigWidgets(ConfigCategory.Builder configCategoryBuilder) {
        for (BlockParticleOverride override : BlockParticleOverride.getBlockParticleOverrides()) {
            if (override == BlockParticleOverride.NONE || override == BlockParticleOverride.VANILLA) continue;
            configCategoryBuilder.group(ConfigScreenHelper.createSeparator());
            configCategoryBuilder.group(ConfigScreenHelper.createOptionsForBlockOverride(override));
            configCategoryBuilder.group(ConfigScreenHelper.createBlockListForBlockOverride(override));
        }
        return configCategoryBuilder;
    }

    public static OptionGroup createOptionsForBlockOverride(BlockParticleOverride override) {
        String particleTypeKey = override.getName();
        Option isEnabledOption = Option.createBuilder().name(ConfigTranslation.getGlobalOption("is_override_enabled").toComponent()).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createPlaceholder(ConfigTranslation.createDesc(ConfigTranslation.getGlobalOption("is_override_enabled")), class_2561.method_43471((String)ConfigTranslation.getParticleType(particleTypeKey).toString()).getString())})).binding(override.getEnabledOption().createBinding()).controller(opt -> BooleanControllerBuilder.create((Option)opt).yesNoFormatter().coloured(true)).build();
        Option<Integer> maxParticlesOnPlaceOption = ConfigScreenHelper.maxParticlesOnPlaceOption("max_particles_block_place_along_edges", override.getMaxParticlesOnPlaceOption());
        Option<Integer> maxParticlesOnBreakOption = ConfigScreenHelper.maxParticlesOnBreakOption("max_particles_block_break_along_axis", override.getMaxParticlesOnBreakOption());
        return ConfigScreenHelper.createMultipleOptionsConfigGroup(override.getName(), override.getGroupName(), "blocks", isEnabledOption, maxParticlesOnPlaceOption, maxParticlesOnBreakOption);
    }

    public static ListOption<BlockOrTagLocation> createBlockListForBlockOverride(BlockParticleOverride override) {
        ConfigOption<List<BlockOrTagLocation>> option = override.getSupportedBlocksAndTagsOption();
        if (option == null) {
            throw new IllegalArgumentException("Cannot create list option for override with no supported blocks list");
        }
        return ConfigScreenHelper.createBlockLocationListOption(override.getName(), override.getGroupName() + "_blocks", "blocks", option);
    }

    public static <T extends Enum<T>> Option<T> enumCycleOption(String optionName, ConfigOption<T> option, Class<T> enumClass) {
        ConfigTranslation.TranslationKey translationKey = ConfigTranslation.getGlobalOption(optionName);
        return Option.createBuilder().name(translationKey.toComponent()).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createDesc(translationKey)})).binding(option.createBinding()).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(enumClass)).build();
    }

    public static OptionGroup createParticleToggleAndMaxAndIntensityConfigGroup(String particleTypeKey, String groupName, String category, ConfigOption<Boolean> particleEnabledOption, String particleEnabledTranslationOption, Option<Integer> maxParticlesOnUseOption, Option<Integer> particleIntensityOption) {
        Option<Boolean> particleToggleOption = ConfigScreenHelper.booleanOption(particleEnabledTranslationOption, particleTypeKey, particleEnabledOption);
        return ConfigScreenHelper.createMultipleOptionsConfigGroup(particleTypeKey, groupName, category, particleToggleOption, maxParticlesOnUseOption, particleIntensityOption);
    }

    public static OptionGroup createParticleToggleAndIntSliderConfigGroup(String particleTypeKey, String groupName, String category, ConfigOption<Boolean> particleEnabledOption, String particleEnabledTranslationOption, Option<Integer> intSlider) {
        Option<Boolean> particleToggleOption = ConfigScreenHelper.booleanOption(particleEnabledTranslationOption, particleTypeKey, particleEnabledOption);
        return ConfigScreenHelper.createMultipleOptionsConfigGroup(particleTypeKey, groupName, category, particleToggleOption, intSlider);
    }

    public static OptionGroup createMultipleOptionsConfigGroup(String particleTypeKey, String groupName, String category, Option<?> ... options) {
        return ConfigScreenHelper.createMultipleOptionsConfigGroup(particleTypeKey, groupName, category, false, options);
    }

    public static OptionGroup createMultipleOptionsConfigGroup(String particleTypeKey, String groupName, String category, boolean collapseByDefault, Option<?> ... options) {
        ConfigTranslation.TranslationKey groupNameKey = ConfigTranslation.getGroupName(category, groupName);
        OptionGroup.Builder optionGroupBuilder = OptionGroup.createBuilder().name(ConfigTranslation.createPlaceholder(groupNameKey.toComponent(), class_2561.method_43471((String)ConfigTranslation.getParticleType(particleTypeKey).toString()).getString())).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createPlaceholder(ConfigTranslation.createDesc(groupNameKey), class_2561.method_43471((String)ConfigTranslation.getParticleType(particleTypeKey).toString()).getString())}));
        for (Option<?> option : options) {
            optionGroupBuilder.option(option);
        }
        return optionGroupBuilder.collapsed(collapseByDefault).build();
    }

    public static OptionGroup createFluidParticleToggleAndMaxConfigGroup(String particleTypeKey, String groupName, String category, ConfigOption<Boolean> spawnOnFluidPlaceOption, Option<Integer> maxPlaceParticlesOption) {
        Option onFluidPlaceOption = Option.createBuilder().name(ConfigTranslation.getGlobalOption("spawn_fluid_particle_on_place").toComponent()).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createPlaceholder(ConfigTranslation.createDesc(ConfigTranslation.getGlobalOption("spawn_fluid_particle_on_place")), class_2561.method_43471((String)ConfigTranslation.getParticleType(particleTypeKey).toString()).getString())})).binding(spawnOnFluidPlaceOption.createBinding()).controller(opt -> BooleanControllerBuilder.create((Option)opt).yesNoFormatter().coloured(true)).build();
        return ConfigScreenHelper.createMultipleOptionsConfigGroup(particleTypeKey, groupName, category, onFluidPlaceOption, maxPlaceParticlesOption);
    }

    public static OptionGroup createGenericConfigGroup(String groupName, String category, boolean collapseByDefault, Option<?> ... options) {
        ConfigTranslation.TranslationKey groupNameKey = ConfigTranslation.getGroupName(category, groupName);
        OptionGroup.Builder optionGroupBuilder = OptionGroup.createBuilder().name(groupNameKey.toComponent()).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createDesc(groupNameKey)}));
        for (Option<?> option : options) {
            optionGroupBuilder.option(option);
        }
        return optionGroupBuilder.collapsed(collapseByDefault).build();
    }
}

