/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle.overrides;

import games.enchanted.eg_particle_interactions.common.config.categories.BlockOverrideOptions;
import games.enchanted.eg_particle_interactions.common.config.option.ConfigOption;
import games.enchanted.eg_particle_interactions.common.registry.BlockOrTagLocation;
import games.enchanted.eg_particle_interactions.common.registry.RegistryHelpers;
import games.enchanted.eg_particle_interactions.common.registry.TagUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockParticleOverride {
    public static final int ORIGIN_BLOCK_PLACED = 1;
    public static final int ORIGIN_BLOCK_BROKEN = 2;
    public static final int ORIGIN_BLOCK_PARTICLE_OVERRIDDEN = 3;
    public static final int ORIGIN_ITEM_PARTICLE_OVERRIDDEN = 4;
    public static final int ORIGIN_BLOCK_BRUSHED = 5;
    public static final int ORIGIN_BLOCK_CRACK = 6;
    public static final int ORIGIN_FALLING_BLOCK_LANDED = 7;
    public static final int ORIGIN_FALLING_BLOCK_FALLING = 8;
    public static final int ORIGIN_BLOCK_INTERACTED_WITH = 9;
    public static final int ORIGIN_BLOCK_WALKED_THROUGH = 10;
    public static final BlockParticleOverride NONE = new BlockParticleOverride("none");
    public static final BlockParticleOverride VANILLA = new BlockParticleOverride("vanilla_particle", "vanilla_block_override", (blockState, level, blockPos, overrideOrigin) -> new class_2388(class_2398.field_11217, blockState), BlockOverrideOptions.VANILLA_BLOCK_PARTICLE, 1.0f);
    private static final ArrayList<BlockParticleOverride> blockParticleOverrides = new ArrayList();
    private final String name;
    private final String groupName;
    @NotNull
    final ReplaceParticleFromOriginSupplier shouldReplaceParticleFromOrigin;
    @NotNull
    final ParticleSupplier particleSupplier;
    @Nullable
    final ConfigOption<List<BlockOrTagLocation>> supportedBlocksOption;
    final ConfigOption<Boolean> isEnabledOption;
    final ConfigOption<Integer> maxParticleOnPlaceOption;
    final ConfigOption<Integer> maxParticleOnBreakOption;
    final float particleVelocityMultiplier;

    BlockParticleOverride(String overrideName, String groupName, @NotNull ParticleSupplier particleSupplier, BlockOverrideOptions.BlockParticleOptionSet optionSet, float particleVelocityMultiplier) {
        this(overrideName, groupName, particleSupplier, overrideOrigin -> true, optionSet, particleVelocityMultiplier);
    }

    BlockParticleOverride(String overrideName, String groupName, @NotNull ParticleSupplier particleSupplier, @NotNull ReplaceParticleFromOriginSupplier shouldReplaceParticleFromOrigin, BlockOverrideOptions.BlockParticleOptionSet optionSet, float particleVelocityMultiplier) {
        this.name = overrideName;
        this.groupName = groupName;
        this.shouldReplaceParticleFromOrigin = shouldReplaceParticleFromOrigin;
        this.particleSupplier = particleSupplier;
        this.supportedBlocksOption = optionSet.blocksOption();
        this.isEnabledOption = optionSet.enabledOption();
        this.maxParticleOnPlaceOption = optionSet.maxOnPlaceOption();
        this.maxParticleOnBreakOption = optionSet.maxOnBreakOption();
        this.particleVelocityMultiplier = particleVelocityMultiplier;
    }

    private BlockParticleOverride(String overrideName) {
        this.name = overrideName;
        this.groupName = overrideName;
        this.shouldReplaceParticleFromOrigin = overrideOrigin -> true;
        this.particleSupplier = (state, level, pos, overrideOrigin) -> null;
        this.supportedBlocksOption = null;
        this.isEnabledOption = null;
        this.maxParticleOnPlaceOption = null;
        this.maxParticleOnBreakOption = null;
        this.particleVelocityMultiplier = 1.0f;
    }

    @Nullable
    public class_2394 getParticleOptionForState(class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) {
        return this.particleSupplier.consume(blockState, level, blockPos, overrideOrigin);
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    public static BlockParticleOverride getOverrideForBlockState(class_2680 blockState, int overrideOrigin) {
        class_2248 block = blockState.method_26204();
        if (blockState.method_26215()) {
            return NONE;
        }
        class_2960 blockIdentifier = RegistryHelpers.getLocationFromBlock(block);
        BlockParticleOverride returnOverride = null;
        for (BlockParticleOverride override : blockParticleOverrides) {
            if (!BlockParticleOverride.doesOverrideContainBlock(override, blockIdentifier) || !override.isEnabled()) continue;
            returnOverride = override;
            break;
        }
        if (returnOverride != null && returnOverride.shouldReplaceParticleFromOrigin(overrideOrigin)) {
            return returnOverride;
        }
        if (VANILLA.isEnabled()) {
            return VANILLA;
        }
        return NONE;
    }

    private static boolean doesOverrideContainBlock(BlockParticleOverride override, class_2960 blockIdentifier) {
        if (override.getSupportedBlocksAndTags() == null) {
            return false;
        }
        return TagUtil.doesListContainBlock(override.getSupportedBlocksAndTags(), blockIdentifier);
    }

    public static int getParticleMultiplierForOverride(BlockParticleOverride override, boolean isBlockBeingPlaced) {
        if (override == NONE) {
            return 0;
        }
        return BlockParticleOverride.getAppropriateMultiplier(isBlockBeingPlaced, override.getMaxParticlesOnPlace(), override.getMaxParticlesOnBreak());
    }

    private static int getAppropriateMultiplier(boolean isBlockBeingPlaced, int blockPlaceMultiplier, int blockBreakMultiplier) {
        if (isBlockBeingPlaced) {
            return blockPlaceMultiplier;
        }
        return blockBreakMultiplier;
    }

    public static List<BlockParticleOverride> getBlockParticleOverrides() {
        return blockParticleOverrides.stream().toList();
    }

    public static void addBlockParticleOverride(BlockParticleOverride override) {
        if (override == NONE || override == VANILLA) {
            throw new IllegalArgumentException("Cannot call BlockParticleOverride#addBlockParticleOverride with BlockParticleOverride.NONE or BlockParticleOverride.BLOCK");
        }
        blockParticleOverrides.add(override);
    }

    public String getName() {
        return this.name;
    }

    public String getGroupName() {
        return this.groupName;
    }

    @Nullable
    public List<BlockOrTagLocation> getSupportedBlocksAndTags() {
        if (this.supportedBlocksOption == null) {
            return null;
        }
        return this.supportedBlocksOption.getValue();
    }

    public boolean isEnabled() {
        return this.isEnabledOption.getValue();
    }

    public int getMaxParticlesOnPlace() {
        return this.maxParticleOnPlaceOption.getValue();
    }

    public int getMaxParticlesOnBreak() {
        return this.maxParticleOnBreakOption.getValue();
    }

    public float getParticleVelocityMultiplier() {
        return this.particleVelocityMultiplier;
    }

    public boolean shouldReplaceParticleFromOrigin(int overrideOrigin) {
        return this.shouldReplaceParticleFromOrigin.consume(overrideOrigin);
    }

    @Nullable
    public ConfigOption<List<BlockOrTagLocation>> getSupportedBlocksAndTagsOption() {
        return this.supportedBlocksOption;
    }

    public ConfigOption<Boolean> getEnabledOption() {
        return this.isEnabledOption;
    }

    public ConfigOption<Integer> getMaxParticlesOnPlaceOption() {
        return this.maxParticleOnPlaceOption;
    }

    public ConfigOption<Integer> getMaxParticlesOnBreakOption() {
        return this.maxParticleOnBreakOption;
    }

    public static interface ReplaceParticleFromOriginSupplier {
        public boolean consume(int var1);
    }

    public static interface ParticleSupplier {
        public class_2394 consume(class_2680 var1, class_638 var2, class_2338 var3, int var4);
    }
}

