/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle.types.dust;

import games.enchanted.eg_particle_interactions.common.particle.ModParticleTypes;
import games.enchanted.eg_particle_interactions.common.particle.types.ParticleInteractionsParticle;
import games.enchanted.eg_particle_interactions.common.particle.types.dust.AbstractDust;
import games.enchanted.eg_particle_interactions.common.util.ColourUtil;
import games.enchanted.eg_particle_interactions.common.util.ParticleUtil;
import net.minecraft.class_1920;
import net.minecraft.class_2246;
import net.minecraft.class_2286;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2457;
import net.minecraft.class_2459;
import net.minecraft.class_2462;
import net.minecraft.class_2680;
import net.minecraft.class_2747;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FloatingColouredDust
extends AbstractDust {
    protected final class_2680 dustBlockState;

    protected FloatingColouredDust(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_2338 blockPos, class_2680 blockState, class_4002 spriteSet, float gravityMultiplier, boolean spawnSpecks, boolean spriteFromAge) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, spriteSet, gravityMultiplier, spawnSpecks, spriteFromAge);
        this.dustBlockState = blockState;
        int tintColour = class_310.method_1551().method_1505().method_1697(blockState, (class_1920)level, blockPos, 0);
        int[] tintColourARGB = ColourUtil.RGBint_to_ARGB(tintColour);
        int[] averageTextureColourARGB = ColourUtil.getRandomBlockColour(blockState, tintColourARGB);
        this.setRGBA((float)averageTextureColourARGB[1] / 255.0f, (float)averageTextureColourARGB[2] / 255.0f, (float)averageTextureColourARGB[3] / 255.0f, (float)averageTextureColourARGB[0] / 255.0f);
    }

    @Override
    @NotNull
    public class_2394 getSpeckParticle() {
        return new class_2388(ModParticleTypes.TINTED_DUST_SPECK, this.dustBlockState);
    }

    @Override
    protected ParticleInteractionsParticle.ParticleLayer getParticleLayer() {
        if ((double)this.getAlpha() < 0.99) {
            return ParticleInteractionsParticle.ParticleLayer.TRANSLUCENT;
        }
        return super.getParticleLayer();
    }

    public static class RedstoneProvider
    implements class_707<class_2388> {
        private final class_4002 spriteSet;

        public RedstoneProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public class_703 createParticle(class_2388 type, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_5819 random) {
            class_2680 state = type.method_10278();
            int powerLevel = 15;
            if (state.method_28498((class_2769)class_2459.field_11446)) {
                powerLevel = (Boolean)state.method_11654((class_2769)class_2459.field_11446) != false ? 15 : 0;
            } else if (state.method_28498((class_2769)class_2286.field_10789)) {
                powerLevel = state.method_11654((class_2769)class_2286.field_10789) == class_2747.field_12578 ? 15 : 0;
            } else if (state.method_28498((class_2769)class_2457.field_11432)) {
                powerLevel = Math.clamp((long)((Integer)state.method_11654((class_2769)class_2457.field_11432)).intValue(), 0, 15);
            } else if (state.method_28498((class_2769)class_2462.field_10911)) {
                powerLevel = (Boolean)state.method_11654((class_2769)class_2462.field_10911) != false ? 15 : 0;
            }
            state = (class_2680)class_2246.field_10091.method_9564().method_11657((class_2769)class_2457.field_11432, (Comparable)Integer.valueOf(powerLevel));
            FloatingColouredDust particle = new FloatingColouredDust(level, x, y, z, xSpeed, ySpeed, zSpeed, ParticleUtil.getPosFromBlockParticleOption(type), state, this.spriteSet, -0.0f, false, true);
            particle.roll = 0.0f;
            particle.prevRoll = 0.0f;
            particle.field_3847 = (int)((float)particle.field_3847 * 0.4f);
            particle.field_28786 = 0.9f;
            return particle;
        }
    }

    public static class TintedDustSpeckProvider
    implements class_707<class_2388> {
        private final class_4002 spriteSet;

        public TintedDustSpeckProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public class_703 createParticle(class_2388 type, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_5819 random) {
            return new FloatingColouredDust(level, x, y, z, xSpeed, ySpeed, zSpeed, class_2338.method_49637((double)x, (double)y, (double)z), type.method_10278(), this.spriteSet, 0.35f, false, false);
        }
    }

    public static class TintedDustProvider
    implements class_707<class_2388> {
        private final class_4002 spriteSet;

        public TintedDustProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public class_703 createParticle(class_2388 type, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_5819 random) {
            return new FloatingColouredDust(level, x, y, z, xSpeed, ySpeed, zSpeed, class_2338.method_49637((double)x, (double)y, (double)z), type.method_10278(), this.spriteSet, 0.7f, true, true);
        }
    }
}

