/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.util;

import games.enchanted.eg_particle_interactions.common.Logging;
import games.enchanted.eg_particle_interactions.common.mixin.client.accessor.client.NativeImageAccessor;
import games.enchanted.eg_particle_interactions.common.mixin.client.accessor.client.SpriteContentsAccessor;
import games.enchanted.eg_particle_interactions.common.registry.RegistryHelpers;
import games.enchanted.eg_particle_interactions.common.resource.ParticlePaletteAtlasManager;
import games.enchanted.eg_particle_interactions.common.util.MathHelpers;
import games.enchanted.eg_particle_interactions.common.util.TextureHelpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7764;
import net.minecraft.class_9848;

public class ColourUtil {
    private static final int OPAQUE_PIXELS_THRESHOLD = 20;
    private static final HashMap<class_2680, Palette> BLOCKSTATE_TO_PALETTE_CACHE = new HashMap();

    public static int[] getRandomBlockColour(class_2680 blockState, int[] tintColour) {
        ParticlePaletteAtlasManager.ParticlePaletteSettingsMetadataSection paletteMetadata;
        if (BLOCKSTATE_TO_PALETTE_CACHE.containsKey(blockState)) {
            Palette palette = BLOCKSTATE_TO_PALETTE_CACHE.get(blockState);
            return ColourUtil.getRandomColourFromPalette(palette, tintColour);
        }
        class_1058 particleSprite = class_310.method_1551().method_1541().method_3349(blockState).method_68511();
        class_2960 particleSpriteLocation = particleSprite.method_45851().method_45816();
        class_1058 paletteSprite = TextureHelpers.getParticlePaletteOrBlockSprite(RegistryHelpers.getLocationFromBlock(blockState.method_26204()), particleSpriteLocation);
        class_7764 spriteContents = paletteSprite.method_45851();
        Palette palette = ColourUtil.collectValidPalettePixels(spriteContents, (paletteMetadata = ParticlePaletteAtlasManager.getMetadataFromSprite(paletteSprite)).useBiomeTint());
        if (palette.cacheable()) {
            BLOCKSTATE_TO_PALETTE_CACHE.put(blockState, palette);
        }
        return ColourUtil.getRandomColourFromPalette(palette, tintColour);
    }

    private static int[] getRandomColourFromPalette(Palette palette, int[] tintColour) {
        if (palette.hasTint()) {
            return ColourUtil.multiplyColours(palette.getRandomEntry().argbAsArray(), tintColour);
        }
        return palette.getRandomEntry().argbAsArray();
    }

    private static Palette collectValidPalettePixels(class_7764 paletteSprite, boolean hasTint) {
        ArrayList<Integer> colours = new ArrayList<Integer>();
        class_1011 image = ((SpriteContentsAccessor)paletteSprite).block_place_particle$getOriginalImage();
        if (((NativeImageAccessor)image).eg_particle_interactions$getPixels() == 0L) {
            Logging.textureDebugInfo("Sprite {} is not allocated", paletteSprite.method_45816());
            return Palette.BLANK;
        }
        for (int x = 0; x < paletteSprite.method_45807(); ++x) {
            for (int y = 0; y < paletteSprite.method_45815(); ++y) {
                int sampledColour = image.method_61940(x, y);
                int alpha = class_9848.method_61320((int)sampledColour);
                if (alpha <= 20) continue;
                colours.add(sampledColour);
            }
        }
        if (colours.isEmpty()) {
            Logging.textureDebugInfo("Sprite {} contains no valid pixels for palette", paletteSprite.method_45816());
            return Palette.BLANK;
        }
        Logging.textureDebugInfo("Sprite {} has {} valid palette pixels", paletteSprite.method_45816(), colours.size());
        PaletteEntry[] paletteEntries = new PaletteEntry[colours.size()];
        for (int i = 0; i < colours.size(); ++i) {
            paletteEntries[i] = new PaletteEntry((Integer)colours.get(i));
        }
        return new Palette(paletteEntries, true, hasTint);
    }

    public static void invalidateCaches() {
        BLOCKSTATE_TO_PALETTE_CACHE.clear();
    }

    public static int ARGB_to_ARGBint(int a, int r, int g, int b) {
        int alpha = MathHelpers.clampInt(a, 0, 255);
        int red = MathHelpers.clampInt(r, 0, 255);
        int green = MathHelpers.clampInt(g, 0, 255);
        int blue = MathHelpers.clampInt(b, 0, 255);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int[] ARGBint_to_ARGB(int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return new int[]{a, r, g, b};
    }

    public static int RGB_to_RGBint(int r, int g, int b) {
        int red = MathHelpers.clampInt(r, 0, 255);
        int green = MathHelpers.clampInt(g, 0, 255);
        int blue = MathHelpers.clampInt(b, 0, 255);
        return red << 16 | green << 8 | blue;
    }

    public static int[] RGBint_to_RGB(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return new int[]{r, g, b};
    }

    public static int[] RGBint_to_ARGB(int rgb) {
        int[] rgbArray = ColourUtil.RGBint_to_RGB(rgb);
        return new int[]{255, rgbArray[0], rgbArray[1], rgbArray[2]};
    }

    public static int[] ARGBfloats_to_ARGB(float a, float r, float g, float b) {
        return new int[]{(int)(a * 255.0f), (int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f)};
    }

    public static int[] randomiseNegative(int[] colours, float amount) {
        int[] randomised = new int[colours.length];
        for (int i = 0; i < colours.length; ++i) {
            randomised[i] = ColourUtil.variateColourComponent(colours[i], -MathHelpers.randomBetween(0.0f, amount));
        }
        return randomised;
    }

    public static int[] randomiseNegativeUniform(int[] colours, float amount) {
        float randomAmount = -MathHelpers.randomBetween(0.0f, amount);
        int[] randomised = new int[colours.length];
        for (int i = 0; i < colours.length; ++i) {
            randomised[i] = ColourUtil.variateColourComponent(colours[i], randomAmount);
        }
        return randomised;
    }

    public static int variateColourComponent(int colour, float variation) {
        return MathHelpers.clampInt(colour + (int)(variation * 255.0f), 0, 255);
    }

    public static int[] multiplyColours(int[] colour1, int[] colour2) {
        if (colour1.length != colour2.length) {
            throw new IllegalArgumentException(ColourUtil.class.getName() + "#multiplyColours: colour1 and colour2 must both be either ARGB or RGB arrays. colour1: " + Arrays.toString(colour1) + ", colour2: " + Arrays.toString(colour2));
        }
        if (colour1.length != 4 && colour1.length != 3) {
            throw new IllegalArgumentException(ColourUtil.class.getName() + "#multiplyColours: both colours must have 4 or 3 values. colour1: " + Arrays.toString(colour1) + ", colour2: " + Arrays.toString(colour2));
        }
        int[] multipliedColour = new int[colour1.length];
        for (int i = 0; i < colour1.length; ++i) {
            multipliedColour[i] = (int)(Math.clamp((float)colour1[i] / 255.0f * ((float)colour2[i] / 255.0f), 0.0f, 255.0f) * 255.0f);
        }
        return multipliedColour;
    }

    private record Palette(PaletteEntry[] entries, boolean cacheable, boolean hasTint) {
        static final Palette BLANK = new Palette(new PaletteEntry[]{new PaletteEntry(-1)}, false);

        Palette(PaletteEntry[] entries, boolean cacheable) {
            this(entries, cacheable, false);
        }

        PaletteEntry getRandomEntry() {
            return this.entries()[MathHelpers.randomBetween(0, this.entries().length - 1)];
        }
    }

    private record PaletteEntry(int argb) {
        int[] argbAsArray() {
            return ColourUtil.ARGBint_to_ARGB(this.argb());
        }
    }
}

