/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.spottedhyena.mob.goals;

import aquariusplayz.animalgarden.spottedhyena.mob.ModMob;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class ModLeapAtTargetGoal
extends Goal {
    private final Mob mob;
    private LivingEntity target;
    private final float yd;

    public ModLeapAtTargetGoal(Mob p_25492_, float p_25493_) {
        this.mob = p_25492_;
        this.yd = p_25493_;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        ModMob e;
        Mob mob = this.mob;
        if (mob instanceof ModMob && (e = (ModMob)mob).isTame() && e.getBehaviorType() == 4) {
            return false;
        }
        if (this.mob.hasControllingPassenger()) {
            return false;
        }
        this.target = this.mob.getTarget();
        if (this.target == null) {
            return false;
        }
        double d0 = this.mob.distanceToSqr((Entity)this.target);
        if (d0 < 4.0 || d0 > 16.0) {
            return false;
        }
        return !this.mob.onGround() ? false : this.mob.getRandom().nextInt(ModLeapAtTargetGoal.reducedTickDelay((int)5)) == 0;
    }

    public boolean canContinueToUse() {
        return !this.mob.onGround();
    }

    public void start() {
        Vec3 vec3 = this.mob.getDeltaMovement();
        Vec3 vec31 = new Vec3(this.target.getX() - this.mob.getX(), 0.0, this.target.getZ() - this.mob.getZ());
        if (vec31.lengthSqr() > 1.0E-7) {
            vec31 = vec31.normalize().scale(0.4).add(vec3.scale(0.2));
        }
        this.mob.setDeltaMovement(vec31.x, (double)this.yd, vec31.z);
    }
}

