/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.spottedhyena.mob.goals;

import aquariusplayz.animalgarden.spottedhyena.mob.ModMob;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;

public class ModBreedGoal
extends Goal {
    private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.forNonCombat().range(8.0).ignoreLineOfSight();
    protected final Animal animal;
    private final Class<? extends Animal> partnerClass;
    protected final ServerLevel level;
    @Nullable
    protected Animal partner;
    private int loveTime;
    private final double speedModifier;

    public ModBreedGoal(Animal p_25122_, double p_25123_) {
        this(p_25122_, p_25123_, p_25122_.getClass());
    }

    public ModBreedGoal(Animal p_25125_, double p_25126_, Class<? extends Animal> p_25127_) {
        this.animal = p_25125_;
        this.level = (ServerLevel)p_25125_.level();
        this.partnerClass = p_25127_;
        this.speedModifier = p_25126_;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        ModMob e;
        Animal animal = this.animal;
        if (animal instanceof ModMob && (e = (ModMob)animal).isTame() && e.getBehaviorType() == 4) {
            return false;
        }
        if (!this.animal.isInLove()) {
            return false;
        }
        this.partner = this.getFreePartner();
        return this.partner != null;
    }

    public boolean canContinueToUse() {
        ModMob mob;
        Animal animal = this.animal;
        if (animal instanceof ModMob && ((mob = (ModMob)animal).getBehaviorType() == 1 || mob.getBehaviorType() == 4)) {
            return false;
        }
        return this.partner.isAlive() && this.partner.isInLove() && this.loveTime < 60 && !this.partner.isPanicking();
    }

    public void stop() {
        this.partner = null;
        this.loveTime = 0;
    }

    public void tick() {
        this.animal.getLookControl().setLookAt((Entity)this.partner, 10.0f, (float)this.animal.getMaxHeadXRot());
        this.animal.getNavigation().moveTo((Entity)this.partner, this.speedModifier);
        ++this.loveTime;
        if (this.loveTime >= this.adjustedTickDelay(60) && this.animal.distanceToSqr((Entity)this.partner) < 9.0) {
            this.breed();
        }
    }

    @Nullable
    private Animal getFreePartner() {
        List list = this.level.getNearbyEntities(this.partnerClass, PARTNER_TARGETING, (LivingEntity)this.animal, this.animal.getBoundingBox().inflate(8.0));
        double d0 = Double.MAX_VALUE;
        Animal animal = null;
        for (Animal animal1 : list) {
            if (!this.animal.canMate(animal1) || animal1.isPanicking() || !(this.animal.distanceToSqr((Entity)animal1) < d0)) continue;
            animal = animal1;
            d0 = this.animal.distanceToSqr((Entity)animal1);
        }
        return animal;
    }

    protected void breed() {
        this.animal.spawnChildFromBreeding(this.level, this.partner);
    }
}

