/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.spottedhyena.mob.goals;

import aquariusplayz.animalgarden.spottedhyena.mob.ModMob;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ModTemptGoal
extends Goal {
    private static final TargetingConditions TEMPT_TARGETING = TargetingConditions.forNonCombat().ignoreLineOfSight();
    private static final double DEFAULT_STOP_DISTANCE = 2.5;
    private final TargetingConditions targetingConditions;
    protected final Mob mob;
    protected final double speedModifier;
    private double px;
    private double py;
    private double pz;
    private double pRotX;
    private double pRotY;
    @Nullable
    protected Player player;
    private int calmDown;
    private boolean isRunning;
    private final Predicate<ItemStack> items;
    private final boolean canScare;
    private final double stopDistance;

    public ModTemptGoal(PathfinderMob p_25939_, double p_25940_, Predicate<ItemStack> p_329244_, boolean p_25942_) {
        this((Mob)p_25939_, p_25940_, p_329244_, p_25942_, 2.5);
    }

    public ModTemptGoal(PathfinderMob p_406939_, double p_408370_, Predicate<ItemStack> p_409411_, boolean p_405821_, double p_409287_) {
        this((Mob)p_406939_, p_408370_, p_409411_, p_405821_, p_409287_);
    }

    ModTemptGoal(Mob p_405921_, double p_409743_, Predicate<ItemStack> p_409922_, boolean p_406295_, double p_407335_) {
        this.mob = p_405921_;
        this.speedModifier = p_409743_;
        this.items = p_409922_;
        this.canScare = p_406295_;
        this.stopDistance = p_407335_;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.targetingConditions = TEMPT_TARGETING.copy().selector((p_370043_, p_361565_) -> this.shouldFollow(p_370043_));
    }

    public boolean canUse() {
        ModMob e;
        Mob mob = this.mob;
        if (mob instanceof ModMob && (e = (ModMob)mob).isTame() && e.getBehaviorType() == 4) {
            return false;
        }
        if (this.calmDown > 0) {
            --this.calmDown;
            return false;
        }
        this.player = ModTemptGoal.getServerLevel((Entity)this.mob).getNearestPlayer(this.targetingConditions.range(this.mob.getAttributeValue(Attributes.TEMPT_RANGE)), (LivingEntity)this.mob);
        return this.player != null;
    }

    private boolean shouldFollow(LivingEntity p_148139_) {
        return this.items.test(p_148139_.getMainHandItem()) || this.items.test(p_148139_.getOffhandItem());
    }

    public boolean canContinueToUse() {
        Mob mob = this.mob;
        if (mob instanceof ModMob) {
            ModMob e = (ModMob)mob;
            if (e.targetFound || !e.isTame() || e.getBehaviorType() == 4) {
                return false;
            }
        }
        if (this.canScare()) {
            if (this.mob.distanceToSqr((Entity)this.player) < 36.0) {
                if (this.player.distanceToSqr(this.px, this.py, this.pz) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.player.getXRot() - this.pRotX) > 5.0 || Math.abs((double)this.player.getYRot() - this.pRotY) > 5.0) {
                    return false;
                }
            } else {
                this.px = this.player.getX();
                this.py = this.player.getY();
                this.pz = this.player.getZ();
            }
            this.pRotX = this.player.getXRot();
            this.pRotY = this.player.getYRot();
        }
        return this.canUse();
    }

    protected boolean canScare() {
        return this.canScare;
    }

    public void start() {
        this.px = this.player.getX();
        this.py = this.player.getY();
        this.pz = this.player.getZ();
        this.isRunning = true;
    }

    public void stop() {
        this.player = null;
        this.stopNavigation();
        this.calmDown = ModTemptGoal.reducedTickDelay((int)100);
        this.isRunning = false;
    }

    public void tick() {
        this.mob.getLookControl().setLookAt((Entity)this.player, (float)(this.mob.getMaxHeadYRot() + 20), (float)this.mob.getMaxHeadXRot());
        if (this.mob.distanceToSqr((Entity)this.player) < this.stopDistance * this.stopDistance) {
            this.stopNavigation();
        } else {
            this.navigateTowards(this.player);
        }
    }

    protected void stopNavigation() {
    }

    protected void navigateTowards(Player p_407647_) {
        this.mob.getNavigation().moveTo((Entity)p_407647_, this.speedModifier);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public static class ForNonPathfinders
    extends ModTemptGoal {
        public ForNonPathfinders(Mob p_407234_, double p_407396_, Predicate<ItemStack> p_410152_, boolean p_410644_, double p_408141_) {
            super(p_407234_, p_407396_, p_410152_, p_410644_, p_408141_);
        }

        @Override
        protected void stopNavigation() {
            this.mob.getMoveControl().setWait();
        }

        @Override
        protected void navigateTowards(Player p_410163_) {
            Vec3 vec3 = p_410163_.getEyePosition().subtract(this.mob.position()).scale(this.mob.getRandom().nextDouble()).add(this.mob.position());
            this.mob.getMoveControl().setWantedPosition(vec3.x, vec3.y, vec3.z, this.speedModifier);
        }
    }
}

