/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.spottedhyena.mob.goals;

import aquariusplayz.animalgarden.spottedhyena.mob.ModMob;
import aquariusplayz.animalgarden.spottedhyena.mob.goals.ModTargetingConditions;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;

public class ModNearestAttackableFoodTargetGoal<T extends ItemEntity>
extends TargetGoal {
    protected final Class<T> targetType;
    protected final int randomInterval;
    @Nullable
    protected Entity target;
    protected ModTargetingConditions targetConditions;
    protected final ModMob mob;

    public ModNearestAttackableFoodTargetGoal(ModMob p_26060_, Class<T> p_26061_, boolean p_26062_) {
        this(p_26060_, p_26061_, 10, p_26062_, false, null);
    }

    public ModNearestAttackableFoodTargetGoal(ModMob p_199891_, Class<T> p_199892_, boolean p_199893_, ModTargetingConditions.Selector p_365854_) {
        this(p_199891_, p_199892_, 10, p_199893_, false, p_365854_);
    }

    public ModNearestAttackableFoodTargetGoal(ModMob p_26064_, Class<T> p_26065_, boolean p_26066_, boolean p_26067_) {
        this(p_26064_, p_26065_, 10, p_26066_, p_26067_, null);
    }

    public ModNearestAttackableFoodTargetGoal(ModMob p_26053_, Class<T> p_26054_, int p_26055_, boolean p_26056_, boolean p_26057_, @Nullable ModTargetingConditions.Selector p_365081_) {
        super((Mob)p_26053_, p_26056_, p_26057_);
        this.mob = p_26053_;
        this.targetType = p_26054_;
        this.randomInterval = ModNearestAttackableFoodTargetGoal.reducedTickDelay((int)p_26055_);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        this.targetConditions = ModTargetingConditions.forCombat().range(this.getFollowDistance()).selector(p_365081_);
    }

    public boolean canUse() {
        ModMob e;
        ModMob modMob = this.mob;
        if (modMob instanceof ModMob && (e = modMob).isTame() && e.getBehaviorType() == 4) {
            return false;
        }
        if (this.randomInterval > 0 && this.mob.getRandom().nextInt(this.randomInterval) != 0) {
            return false;
        }
        this.findTarget();
        return this.target != null;
    }

    protected AABB getTargetSearchArea(double p_26069_) {
        return this.mob.getBoundingBox().inflate(p_26069_, p_26069_, p_26069_);
    }

    protected void findTarget() {
        T target = this.getNearestEntity(this.mob.level().getEntitiesOfClass(this.targetType, this.getTargetSearchArea(this.getFollowDistance()), p_148152_ -> true), this.getTargetConditions(), (LivingEntity)this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ());
        this.target = target;
    }

    @Nullable
    public <T extends ItemEntity> T getNearestEntity(List<? extends T> p_363565_, ModTargetingConditions p_366923_, @Nullable LivingEntity mob, double p_366460_, double p_364508_, double p_364611_) {
        double d0 = -1.0;
        ItemEntity t = null;
        for (ItemEntity t1 : p_363565_) {
            if (!this.test((ServerLevel)mob.level(), mob, (Entity)t1)) continue;
            double d1 = t1.distanceToSqr(p_366460_, p_364508_, p_364611_);
            if (d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            t = t1;
        }
        return (T)t;
    }

    public boolean canAttack(LivingEntity p_21171_) {
        return p_21171_ instanceof Player && p_21171_.level().getDifficulty() == Difficulty.PEACEFUL ? false : this.canBeSeenAsEnemy((Entity)p_21171_);
    }

    public boolean canBeSeenAsEnemy(Entity p_21171_) {
        return !p_21171_.isInvulnerable() && this.canBeSeenByAnyone(p_21171_);
    }

    public boolean canBeSeenByAnyone(Entity p_21171_) {
        return !p_21171_.isSpectator() && p_21171_.isAlive();
    }

    public double getVisibilityPercent(@Nullable Entity p_20969_, LivingEntity p_26886_) {
        double d0 = 1.0;
        if (p_26886_.isDiscrete()) {
            d0 *= 0.8;
        }
        if (p_26886_.isInvisible()) {
            float f = p_26886_.getArmorCoverPercentage();
            if (f < 0.1f) {
                f = 0.1f;
            }
            d0 *= 0.7 * (double)f;
        }
        if (p_20969_ != null) {
            ItemStack itemstack = p_26886_.getItemBySlot(EquipmentSlot.HEAD);
            EntityType entitytype = p_20969_.getType();
            if (entitytype == EntityType.SKELETON && itemstack.is(Items.SKELETON_SKULL) || entitytype == EntityType.ZOMBIE && itemstack.is(Items.ZOMBIE_HEAD) || entitytype == EntityType.PIGLIN && itemstack.is(Items.PIGLIN_HEAD) || entitytype == EntityType.PIGLIN_BRUTE && itemstack.is(Items.PIGLIN_HEAD) || entitytype == EntityType.CREEPER && itemstack.is(Items.CREEPER_HEAD)) {
                d0 *= 0.5;
            }
        }
        return d0;
    }

    public boolean test(ServerLevel p_364974_, @Nullable LivingEntity p_26886_, Entity p_26887_) {
        if (p_26886_ == p_26887_) {
            return false;
        }
        if (p_26887_.isSpectator() || !p_26887_.isAlive()) {
            return false;
        }
        if (this.targetConditions.selector != null && !this.targetConditions.selector.test(p_26887_, p_364974_)) {
            return false;
        }
        if (p_26886_ == null) {
            if (this.targetConditions.isCombat && (p_26887_.isInvulnerable() || p_26887_.isSpectator() || !p_26887_.isAlive() || p_364974_.getDifficulty() == Difficulty.PEACEFUL)) {
                return false;
            }
        } else {
            Mob mob;
            if (this.targetConditions.isCombat && (!this.canBeSeenAsEnemy(p_26887_) || !p_26886_.canAttackType(p_26887_.getType()) || p_26886_.isAlliedTo(p_26887_))) {
                return false;
            }
            if (this.targetConditions.range > 0.0) {
                double d0 = this.targetConditions.testInvisible ? this.getVisibilityPercent(p_26887_, p_26886_) : 1.0;
                double d1 = Math.max(this.targetConditions.range * d0, 2.0);
                double d2 = p_26886_.distanceToSqr(p_26887_.getX(), p_26887_.getY(), p_26887_.getZ());
                if (d2 > d1 * d1) {
                    return false;
                }
            }
            if (this.targetConditions.checkLineOfSight && p_26886_ instanceof Mob && !(mob = (Mob)p_26886_).getSensing().hasLineOfSight(p_26887_)) {
                return false;
            }
        }
        return true;
    }

    public void start() {
        this.mob.setItemEntityTarget(this.target);
        super.start();
    }

    public void setTarget(@Nullable LivingEntity p_26071_) {
        this.target = p_26071_;
    }

    private ModTargetingConditions getTargetConditions() {
        return this.targetConditions.range(this.getFollowDistance());
    }
}

