/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.spottedhyena.mob;

import aquariusplayz.animalgarden.spottedhyena.Registrations;
import aquariusplayz.animalgarden.spottedhyena.mob.ModAnimationState;
import aquariusplayz.animalgarden.spottedhyena.mob.controls.ModBodyRotationControl;
import aquariusplayz.animalgarden.spottedhyena.mob.controls.ModMobPathNavigation;
import aquariusplayz.animalgarden.spottedhyena.mob.controls.ModSmoothSwimmingLookControl;
import aquariusplayz.animalgarden.spottedhyena.mob.controls.ModSmoothSwimmingMoveControl;
import aquariusplayz.animalgarden.spottedhyena.mob.goals.ModBreedGoal;
import aquariusplayz.animalgarden.spottedhyena.mob.goals.ModEatGoal;
import aquariusplayz.animalgarden.spottedhyena.mob.goals.ModFollowParentGoal;
import aquariusplayz.animalgarden.spottedhyena.mob.goals.ModLeapAtTargetGoal;
import aquariusplayz.animalgarden.spottedhyena.mob.goals.ModMeleeAttackGoal;
import aquariusplayz.animalgarden.spottedhyena.mob.goals.ModNearestAttackableFoodTargetGoal;
import aquariusplayz.animalgarden.spottedhyena.mob.goals.ModNearestAttackableTargetGoal;
import aquariusplayz.animalgarden.spottedhyena.mob.goals.ModRandomSwimmingOrWalkingGoal;
import aquariusplayz.animalgarden.spottedhyena.mob.goals.ModTemptGoal;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class ModMob
extends TamableAnimal
implements NeutralMob {
    private static final EntityDataAccessor<Integer> BEHAVIOR = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_IS_LEFT_EYE_BLIND = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_IS_RIGHT_EYE_BLIND = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;
    public final ModAnimationState wink = new ModAnimationState();
    public final ModAnimationState lookLeft = new ModAnimationState();
    public final ModAnimationState lookRight = new ModAnimationState();
    public final ModAnimationState lookUp = new ModAnimationState();
    public final ModAnimationState lookDown = new ModAnimationState();
    public final ModAnimationState leftEyebrowUp = new ModAnimationState();
    public final ModAnimationState leftEyebrowDown = new ModAnimationState();
    public final ModAnimationState rightEyebrowUp = new ModAnimationState();
    public final ModAnimationState rightEyebrowDown = new ModAnimationState();
    public final ModAnimationState leftEyebrowAngry = new ModAnimationState();
    public final ModAnimationState rightEyebrowAngry = new ModAnimationState();
    public final ModAnimationState leftEyebrowSad = new ModAnimationState();
    public final ModAnimationState rightEyebrowSad = new ModAnimationState();
    public final ModAnimationState rightEar = new ModAnimationState();
    public final ModAnimationState rightEar2 = new ModAnimationState();
    public final ModAnimationState leftEar = new ModAnimationState();
    public final ModAnimationState leftEar2 = new ModAnimationState();
    public final ModAnimationState tail = new ModAnimationState();
    public final ModAnimationState tail2 = new ModAnimationState();
    public final ModAnimationState breathing = new ModAnimationState();
    public final ModAnimationState panting = new ModAnimationState();
    public final ModAnimationState biteInPlace = new ModAnimationState();
    public final ModAnimationState headUp = new ModAnimationState();
    public final ModAnimationState headDown = new ModAnimationState();
    public final ModAnimationState headRight = new ModAnimationState();
    public final ModAnimationState headLeft = new ModAnimationState();
    public final ModAnimationState sniffing = new ModAnimationState();
    public final ModAnimationState bite = new ModAnimationState();
    public final ModAnimationState sit = new ModAnimationState();
    public final ModAnimationState sitDown = new ModAnimationState();
    public final ModAnimationState howl = new ModAnimationState();
    public int attackCooldown;
    public boolean isRunning = false;
    public int howlCooldown;
    public LivingEntity nearestLivingEntity = null;
    public ItemEntity nearestItemEntity = null;
    public boolean targetFound = false;
    public int leapCooldown;
    public int outOfSight;

    public ModMob(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.setTame(false, false);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
        if (this.isInWater()) {
            this.moveControl = new ModSmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.02f, true);
            this.lookControl = new ModSmoothSwimmingLookControl((Mob)this, 10);
        } else {
            this.moveControl = new MoveControl((Mob)this);
            this.lookControl = new ModSmoothSwimmingLookControl((Mob)this, 5);
        }
    }

    public void travel(Vec3 p_30218_) {
        if (this.isInWater()) {
            this.moveRelative(0.1f, p_30218_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.7));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(p_30218_);
        }
    }

    protected PathNavigation createNavigation(Level p_30171_) {
        return new ModMobPathNavigation(this, p_30171_);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public void setAirSupply(int p_20302_) {
    }

    public int getMaxAirSupply() {
        return 4800;
    }

    public int getAirSupply() {
        return this.getMaxAirSupply();
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_335317_) {
        super.defineSynchedData(p_335317_);
        p_335317_.define(BEHAVIOR, (Object)0);
        p_335317_.define(DATA_IS_LEFT_EYE_BLIND, (Object)false);
        p_335317_.define(DATA_IS_RIGHT_EYE_BLIND, (Object)false);
        p_335317_.define(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public int getBehaviorType() {
        return (Integer)this.entityData.get(BEHAVIOR);
    }

    private void setBehaviorType(int p_30398_) {
        this.entityData.set(BEHAVIOR, (Object)p_30398_);
    }

    public boolean isRightEyeBlind() {
        return (Boolean)this.entityData.get(DATA_IS_RIGHT_EYE_BLIND);
    }

    private void isRightEyeBlind(boolean p_30398_) {
        this.entityData.set(DATA_IS_RIGHT_EYE_BLIND, (Object)p_30398_);
    }

    public boolean isLeftEyeBlind() {
        return (Boolean)this.entityData.get(DATA_IS_LEFT_EYE_BLIND);
    }

    private void isLeftEyeBlind(boolean p_30398_) {
        this.entityData.set(DATA_IS_LEFT_EYE_BLIND, (Object)p_30398_);
    }

    public void addAdditionalSaveData(CompoundTag p_29422_) {
        super.addAdditionalSaveData(p_29422_);
        this.addPersistentAngerSaveData(p_29422_);
        p_29422_.putBoolean("IsLeftEyeBlind", this.isLeftEyeBlind());
        p_29422_.putBoolean("IsRightEyeBlind", this.isRightEyeBlind());
        p_29422_.putInt("BehaviorType", this.getBehaviorType());
    }

    public void readAdditionalSaveData(CompoundTag p_29402_) {
        super.readAdditionalSaveData(p_29402_);
        this.readPersistentAngerSaveData(this.level(), p_29402_);
        this.isLeftEyeBlind(p_29402_.getBoolean("IsLeftEyeBlind"));
        this.isRightEyeBlind(p_29402_.getBoolean("IsRightEyeBlind"));
        this.setBehaviorType(p_29402_.getInt("BehaviorType"));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 25.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.TEMPT_RANGE, 16.0).add(Attributes.ATTACK_DAMAGE, 5.0);
    }

    public float getWalkTargetValue(BlockPos p_33895_, LevelReader p_33896_) {
        return 10.0f;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new ModBreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new ModTemptGoal((PathfinderMob)this, 1.0, p_334579_ -> p_334579_.is(ItemTags.MEAT), false));
        this.goalSelector.addGoal(4, (Goal)new ModFollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(4, (Goal)new ModEatGoal(this, 1.0, true));
        this.goalSelector.addGoal(5, (Goal)new ModLeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(6, (Goal)new ModMeleeAttackGoal(this, 1.0, true));
        this.goalSelector.addGoal(7, (Goal)new ModRandomSwimmingOrWalkingGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, (arg_0, arg_1) -> ((ModMob)this).isAngryAt(arg_0, arg_1)));
        this.targetSelector.addGoal(5, new ModNearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 10, true, false, this::targetSelector));
        this.targetSelector.addGoal(5, new ModNearestAttackableFoodTargetGoal<ItemEntity>(this, ItemEntity.class, 10, true, false, this::allowedFood));
        this.targetSelector.addGoal(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public boolean isWithinMeleeAttackRange(Entity p_217067_) {
        return this.getAttackBoundingBox().intersects(this.getHitbox(p_217067_));
    }

    protected AABB getHitbox(Entity p_217067_) {
        AABB aabb = p_217067_.getBoundingBox();
        Entity entity = p_217067_.getVehicle();
        if (entity != null) {
            Vec3 vec3 = entity.getPassengerRidingPosition(p_217067_);
            return aabb.setMinY(Math.max(vec3.y, aabb.minY));
        }
        return aabb;
    }

    @Nullable
    public void setItemEntityTarget(Entity p_21544_) {
        if (p_21544_ != null) {
            if (p_21544_ instanceof ItemEntity) {
                this.nearestItemEntity = (ItemEntity)p_21544_;
            } else if (p_21544_ instanceof LivingEntity) {
                this.nearestLivingEntity = (LivingEntity)p_21544_;
            }
            this.targetFound = true;
        } else {
            this.targetFound = false;
        }
    }

    public boolean allowedFood(Entity entity, ServerLevel p_366229_) {
        ItemEntity e;
        return entity.isAlive() && entity instanceof ItemEntity && ((e = (ItemEntity)entity).getItem().is(ItemTags.MEAT) || e.getItem().is(ItemTags.FISHES));
    }

    public boolean targetSelector(LivingEntity p_21675_, ServerLevel p_366229_) {
        ModMob mob;
        if (this.isTame()) {
            if (p_21675_ == this.getOwner()) {
                return false;
            }
            if (this.wantsToAttack(p_21675_, this.getOwner())) {
                return true;
            }
        } else if (p_21675_ instanceof ModMob && !(mob = (ModMob)p_21675_).isTame()) {
            return false;
        }
        return this.canAttack(p_21675_);
    }

    protected BodyRotationControl createBodyControl() {
        return new ModBodyRotationControl((Mob)this);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, EntitySpawnReason p_366700_, SpawnGroupData p_146749_) {
        if (this.getRandom().nextInt(10) == 0) {
            this.isLeftEyeBlind(true);
        }
        if (this.getRandom().nextInt(10) == 0) {
            this.isRightEyeBlind(true);
        }
        return super.finalizeSpawn(p_146746_, p_146747_, p_366700_, p_146749_);
    }

    public void stopDefaultAnimations() {
    }

    public void defaultAnimations() {
        if (!this.breathing.isStarted()) {
            this.breathing.start(this.tickCount);
        }
        if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.sniffing, 1.0f)) {
            this.sniffing.start(this.tickCount);
        }
        if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.wink, 0.5f)) {
            this.wink.start(this.tickCount);
        }
        if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.panting, 5.0f) && this.animationEnded(this.howl, 4.0f)) {
            this.panting.start(this.tickCount);
        }
        if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.headRight, 4.0f) && this.animationEnded(this.headLeft, 4.0f) && this.animationEnded(this.howl, 4.0f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.headRight.start(this.tickCount);
            } else {
                this.headLeft.start(this.tickCount);
            }
        }
        if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.headUp, 4.0f) && this.animationEnded(this.headDown, 4.0f) && this.animationEnded(this.howl, 4.0f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.headUp.start(this.tickCount);
            } else {
                this.headDown.start(this.tickCount);
            }
        }
        if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.lookLeft, 2.0f) && this.animationEnded(this.lookRight, 2.0f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.lookLeft.start(this.tickCount);
            } else {
                this.lookRight.start(this.tickCount);
            }
        }
        if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.lookUp, 2.0f) && this.animationEnded(this.lookDown, 2.0f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.lookUp.start(this.tickCount);
            } else {
                this.lookDown.start(this.tickCount);
            }
        }
        if (this.level().random.nextInt(200) == 0 && this.animationEnded(this.leftEyebrowDown, 2.0f) && this.animationEnded(this.leftEyebrowUp, 2.0f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.leftEyebrowDown.start(this.tickCount);
            } else {
                this.leftEyebrowUp.start(this.tickCount);
            }
        }
        if (this.level().random.nextInt(200) == 0 && this.animationEnded(this.rightEyebrowDown, 2.0f) && this.animationEnded(this.rightEyebrowUp, 2.0f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.rightEyebrowDown.start(this.tickCount);
            } else {
                this.rightEyebrowUp.start(this.tickCount);
            }
        }
        if (this.level().random.nextInt(300) == 0 && this.animationEnded(this.leftEyebrowAngry, 3.5f) && this.animationEnded(this.leftEyebrowSad, 3.5f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.leftEyebrowAngry.start(this.tickCount);
            } else {
                this.leftEyebrowSad.start(this.tickCount);
            }
        }
        if (this.level().random.nextInt(300) == 0 && this.animationEnded(this.rightEyebrowAngry, 3.5f) && this.animationEnded(this.rightEyebrowSad, 3.5f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.rightEyebrowAngry.start(this.tickCount);
            } else {
                this.rightEyebrowSad.start(this.tickCount);
            }
        }
        if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.leftEar, 4.0f) && this.animationEnded(this.leftEar2, 4.0f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.leftEar.start(this.tickCount);
            } else {
                this.leftEar2.start(this.tickCount);
            }
        }
        if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.rightEar, 4.0f) && this.animationEnded(this.rightEar2, 4.0f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.rightEar.start(this.tickCount);
            } else {
                this.rightEar2.start(this.tickCount);
            }
        }
        if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.tail, 5.0f) && this.animationEnded(this.tail2, 6.0f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.tail.start(this.tickCount);
            } else {
                this.tail2.start(this.tickCount);
            }
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.howlCooldown > 0) {
            --this.howlCooldown;
        }
        if (this.leapCooldown > 0) {
            --this.leapCooldown;
        }
        if (this.isInWater() && !(this.moveControl instanceof ModSmoothSwimmingMoveControl)) {
            this.moveControl = new ModSmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.02f, true);
            this.lookControl = new ModSmoothSwimmingLookControl((Mob)this, 10);
        } else if (this.moveControl instanceof ModSmoothSwimmingMoveControl) {
            this.moveControl = new MoveControl((Mob)this);
            this.lookControl = new ModSmoothSwimmingLookControl((Mob)this, 5);
        }
        if (this.level().isClientSide()) {
            if (this.getBehaviorType() == 4) {
                if (!this.sit.isStarted() && !this.sitDown.isStarted()) {
                    this.sitDown.start(this.tickCount);
                } else if (!this.sit.isStarted() && this.sitDown.isStarted() && this.animationEnded(this.sitDown, 0.5f)) {
                    this.sit.start(this.tickCount);
                    this.sitDown.stop();
                }
                this.defaultAnimations();
            } else {
                if (this.sit.isStarted() || this.sitDown.isStarted()) {
                    this.sitDown.stop();
                    this.sit.stop();
                }
                if (!this.isAggressive()) {
                    this.defaultAnimations();
                }
            }
        } else {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    public boolean doHurtTarget(ServerLevel p_365421_, Entity p_21372_) {
        p_365421_.broadcastEntityEvent((Entity)this, (byte)4);
        this.playSound(SoundEvents.FOX_BITE, 1.0f, this.getRandom().nextFloat() * 0.2f + 0.2f);
        return super.doHurtTarget(p_365421_, p_21372_);
    }

    public void handleEntityEvent(byte p_28844_) {
        if (p_28844_ == 4) {
            if (this.animationEnded(this.bite, 1.0f)) {
                this.bite.start(this.tickCount);
                this.playSound(SoundEvents.FOX_BITE, 1.0f, this.getRandom().nextFloat() * 0.2f + 0.2f);
            }
        } else if (p_28844_ == 5) {
            if (this.animationEnded(this.biteInPlace, 1.0f)) {
                this.biteInPlace.start(this.tickCount);
                this.playSound(SoundEvents.FOX_BITE, 1.0f, this.getRandom().nextFloat() * 0.2f + 0.2f);
            }
        } else if (p_28844_ == 10) {
            if (this.animationEnded(this.howl, 4.0f)) {
                this.howl.start(this.tickCount);
                this.playSound((SoundEvent)Registrations.HOWL.get(), 2.0f, this.getRandom().nextFloat() * 0.4f + 0.8f);
                this.howlCooldown = 300;
            }
        } else if (p_28844_ == 11) {
            this.isRunning = true;
        } else if (p_28844_ == 12) {
            this.isRunning = false;
        } else {
            super.handleEntityEvent(p_28844_);
        }
    }

    public boolean hurtServer(ServerLevel p_361743_, DamageSource p_361865_, float p_365677_) {
        if (super.hurtServer(p_361743_, p_361865_, p_365677_)) {
            Entity entity;
            if (this.isTame() && (this.getBehaviorType() == 1 || this.getBehaviorType() == 4)) {
                this.setBehaviorType(6);
            }
            if (p_361865_.getEntity() != null && (entity = p_361865_.getEntity()) instanceof LivingEntity) {
                LivingEntity li;
                this.nearestLivingEntity = li = (LivingEntity)entity;
                this.targetFound = true;
                this.nearestItemEntity = null;
            }
            return true;
        }
        return false;
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int p_30404_) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    public boolean wantsToAttack(LivingEntity enemy, LivingEntity p_30390_) {
        TamableAnimal tamableanimal;
        AbstractHorse abstracthorse;
        if (enemy instanceof Creeper || enemy instanceof Ghast || enemy instanceof ArmorStand) {
            return false;
        }
        if (enemy instanceof ModMob) {
            ModMob mob = (ModMob)enemy;
            return !mob.isTame() || mob.getOwner() != p_30390_;
        }
        if (enemy instanceof Player && this.isTame() && this.getOwner() == enemy) {
            return false;
        }
        if (enemy instanceof Player) {
            Player player1;
            Player player = (Player)enemy;
            if (p_30390_ instanceof Player && !(player1 = (Player)p_30390_).canHarmPlayer(player)) {
                return false;
            }
        }
        if (enemy instanceof AbstractHorse && (abstracthorse = (AbstractHorse)enemy).isTamed()) {
            return false;
        }
        return !(enemy instanceof TamableAnimal) || !(tamableanimal = (TamableAnimal)enemy).isTame();
    }

    @Nullable
    public SoundEvent getAmbientSound() {
        return (SoundEvent)Registrations.IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_29437_) {
        return (SoundEvent)Registrations.HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)Registrations.HURT.get();
    }

    public boolean animationEnded(ModAnimationState state, float animLength) {
        return (float)state.getTimeInMillis(this.tickCount) > animLength * 1000.0f;
    }

    public AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(0.5);
    }

    public boolean isFood(ItemStack p_27600_) {
        return p_27600_.is(ItemTags.MEAT);
    }

    protected float getSoundVolume() {
        return 0.25f;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_148993_, AgeableMob p_148994_) {
        ModMob mob = (ModMob)this.getType().create((Level)p_148993_, EntitySpawnReason.BREEDING);
        if (this.isTame()) {
            mob.setOwnerUUID(this.getOwnerUUID());
            mob.setTame(true, true);
        }
        return mob;
    }

    public void tryToTame(Player p_336244_) {
        if (this.random.nextInt(10) == 0) {
            this.setBehaviorType(4);
            this.tame(p_336244_);
            this.navigation.stop();
            this.setTarget(null);
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
    }

    protected void applyTamingSideEffects() {
        if (this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(50.0);
            this.setHealth(50.0f);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(25.0);
        }
    }

    public InteractionResult mobInteract(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.getItemInHand(p_30413_);
        if (this.isTame()) {
            if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                this.usePlayerItem(p_30412_, p_30413_, itemstack);
                FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                float f = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                this.heal(4.0f * f);
                if (this.animationEnded(this.biteInPlace, 1.0f)) {
                    this.biteInPlace.start(this.tickCount);
                }
                return super.mobInteract(p_30412_, p_30413_);
            }
            InteractionResult interactionresult = super.mobInteract(p_30412_, p_30413_);
            if (!interactionresult.consumesAction() && this.isOwnedBy((LivingEntity)p_30412_)) {
                if (this.getBehaviorType() == 0) {
                    this.setBehaviorType(4);
                    if (this.animationEnded(this.howl, 4.0f)) {
                        this.howl.start(this.tickCount);
                        this.playSound((SoundEvent)Registrations.HOWL.get(), 2.0f, this.getRandom().nextFloat() * 0.4f + 0.8f);
                    }
                    this.targetFound = false;
                    this.nearestItemEntity = null;
                    this.nearestLivingEntity = null;
                } else {
                    this.setBehaviorType(0);
                }
                this.jumping = false;
                this.navigation.stop();
                this.setTarget(null);
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (!this.level().isClientSide() && this.isFood(itemstack)) {
            itemstack.consume(1, (LivingEntity)p_30412_);
            this.tryToTame(p_30412_);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(p_30412_, p_30413_);
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    public boolean requiresCustomPersistence() {
        return true;
    }
}

