/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.spottedhyena.mob.controls;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.BodyRotationControl;

public class ModBodyRotationControl
extends BodyRotationControl {
    private final Mob mob;
    private static final int HEAD_STABLE_ANGLE = 15;
    private static final int DELAY_UNTIL_STARTING_TO_FACE_FORWARD = 10;
    private static final int HOW_LONG_IT_TAKES_TO_FACE_FORWARD = 10;
    private int headStableTime;
    private float lastStableYHeadRot;

    public ModBodyRotationControl(Mob p_24879_) {
        super(p_24879_);
        this.mob = p_24879_;
    }

    public void clientTick() {
        if (this.isMoving()) {
            this.mob.yBodyRot = Mth.lerp((float)0.2f, (float)this.mob.yBodyRot, (float)this.mob.getYRot());
            this.rotateHeadIfNecessary();
            this.lastStableYHeadRot = this.mob.yHeadRot;
            this.headStableTime = 0;
        } else if (this.notCarryingMobPassengers()) {
            if (Math.abs(this.mob.yHeadRot - this.lastStableYHeadRot) > 15.0f) {
                this.headStableTime = 0;
                this.lastStableYHeadRot = this.mob.yHeadRot;
                this.rotateBodyIfNecessary();
            } else {
                ++this.headStableTime;
                if (this.headStableTime > 10) {
                    this.rotateHeadTowardsFront();
                }
            }
        }
    }

    private void rotateBodyIfNecessary() {
        this.mob.yBodyRot = Mth.rotateIfNecessary((float)this.mob.yBodyRot, (float)this.mob.yHeadRot, (float)this.mob.getMaxHeadYRot());
    }

    private void rotateHeadIfNecessary() {
        this.mob.yHeadRot = Mth.rotateIfNecessary((float)this.mob.yHeadRot, (float)this.mob.yBodyRot, (float)this.mob.getMaxHeadYRot());
    }

    private void rotateHeadTowardsFront() {
        int i = this.headStableTime - 10;
        float f = Mth.clamp((float)((float)i / 10.0f), (float)0.0f, (float)1.0f);
        float f1 = (float)this.mob.getMaxHeadYRot() * (1.0f - f);
        this.mob.yBodyRot = Mth.rotateIfNecessary((float)this.mob.yBodyRot, (float)this.mob.yHeadRot, (float)f1);
    }

    private boolean notCarryingMobPassengers() {
        return !(this.mob.getFirstPassenger() instanceof Mob);
    }

    private boolean isMoving() {
        double d1;
        double d0 = this.mob.getX() - this.mob.xo;
        return d0 * d0 + (d1 = this.mob.getZ() - this.mob.zo) * d1 > 2.500000277905201E-7;
    }
}

