/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.spottedhyena.mob.goals;

import aquariusplayz.animalgarden.spottedhyena.mob.ModMob;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;

public class ModFollowParentGoal
extends Goal {
    public static final int HORIZONTAL_SCAN_RANGE = 8;
    public static final int VERTICAL_SCAN_RANGE = 4;
    public static final int DONT_FOLLOW_IF_CLOSER_THAN = 3;
    private final Animal animal;
    @Nullable
    private Animal parent;
    private final double speedModifier;
    private int timeToRecalcPath;

    public ModFollowParentGoal(Animal p_25319_, double p_25320_) {
        this.animal = p_25319_;
        this.speedModifier = p_25320_;
    }

    public boolean canUse() {
        ModMob e;
        Animal animal = this.animal;
        if (animal instanceof ModMob && (e = (ModMob)animal).isTame() && e.getBehaviorType() == 4) {
            return false;
        }
        if (this.animal.getAge() >= 0) {
            return false;
        }
        List list = this.animal.level().getEntitiesOfClass(this.animal.getClass(), this.animal.getBoundingBox().inflate(8.0, 4.0, 8.0));
        Animal animal2 = null;
        double d0 = Double.MAX_VALUE;
        for (Animal animal1 : list) {
            double d1;
            if (animal1.getAge() < 0 || (d1 = this.animal.distanceToSqr((Entity)animal1)) > d0) continue;
            d0 = d1;
            animal2 = animal1;
        }
        if (animal2 == null) {
            return false;
        }
        if (d0 < 9.0) {
            return false;
        }
        this.parent = animal2;
        return true;
    }

    public boolean canContinueToUse() {
        Animal animal = this.animal;
        if (animal instanceof ModMob) {
            ModMob e = (ModMob)animal;
            if (e.targetFound || e.isTame() && e.getBehaviorType() == 4) {
                return false;
            }
        }
        if (this.animal.getAge() >= 0) {
            return false;
        }
        if (!this.parent.isAlive()) {
            return false;
        }
        double d0 = this.animal.distanceToSqr((Entity)this.parent);
        return !(d0 < 9.0) && !(d0 > 256.0);
    }

    public void start() {
        this.timeToRecalcPath = 0;
    }

    public void stop() {
        this.parent = null;
    }

    public void tick() {
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            this.animal.getNavigation().moveTo((Entity)this.parent, this.speedModifier);
        }
    }
}

