/*
 * Decompiled with CFR 0.152.
 */
package com.gharielsl.dragonpet;

import com.gharielsl.dragonpet.entity.ModEntities;
import com.gharielsl.dragonpet.entity.ModItems;
import com.gharielsl.dragonpet.entity.TamableDragon;
import com.gharielsl.dragonpet.entity.renderer.TamableDragonModel;
import com.gharielsl.dragonpet.entity.renderer.TamableDragonRenderer;
import com.gharielsl.dragonpet.sound.ModSounds;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;

@Mod(value="dragon_pet")
public class DragonPet {
    public static final String MOD_ID = "dragon_pet";

    public DragonPet(IEventBus modEventBus, ModContainer modContainer) {
        this.init(modEventBus);
    }

    private void init(IEventBus modEventBus) {
        modEventBus.addListener(this::registerAttributes);
        modEventBus.addListener(this::onClientSetup);
        modEventBus.addListener(this::registerLayerDefinitions);
        ModSounds.SOUND_EVENTS.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
    }

    private void registerAttributes(EntityAttributeCreationEvent event) {
        event.put(ModEntities.TAMABLE_DRAGON.get(), TamableDragon.createAttributes().build());
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> EntityRenderers.register(ModEntities.TAMABLE_DRAGON.get(), TamableDragonRenderer::new));
    }

    private void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(TamableDragonModel.LAYER_LOCATION, TamableDragonModel::createBodyLayer);
    }
}

