/*
 * Decompiled with CFR 0.152.
 */
package com.gharielsl.dragonpet.entity;

import com.gharielsl.dragonpet.entity.ModEntities;
import com.gharielsl.dragonpet.sound.ModSounds;
import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TamableDragon
extends TamableAnimal {
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(TamableDragon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;

    public TamableDragon(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level world) {
        FlyingPathNavigation nav = new FlyingPathNavigation((Mob)this, world);
        nav.setCanOpenDoors(false);
        nav.setCanFloat(true);
        nav.setCanPassDoors(true);
        return nav;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 1000.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ARMOR_TOUGHNESS, 2.0).add(Attributes.FLYING_SPEED, 0.8).add(Attributes.ATTACK_DAMAGE, 6.0);
    }

    public void tick() {
        LivingEntity livingEntity;
        super.tick();
        if (this.level().isClientSide()) {
            if (this.idleAnimationTimeout <= 0) {
                this.idleAnimationTimeout = this.random.nextInt(40) + 80;
                this.idleAnimationState.start(this.tickCount);
            } else {
                --this.idleAnimationTimeout;
            }
        }
        if (this.isVehicle() && (livingEntity = this.getControllingPassenger()) instanceof Player) {
            Player player = (Player)livingEntity;
            Vec3 look = player.getLookAngle();
            Vec3 movement = Vec3.ZERO;
            Minecraft client = Minecraft.getInstance();
            boolean forward = client.options.keyUp.isDown();
            boolean jump = client.options.keyJump.isDown();
            boolean down = client.options.keyDown.isDown();
            if (forward) {
                movement = new Vec3(look.x, 0.0, look.z).normalize().scale(0.8);
            }
            if (jump) {
                movement = movement.add(0.0, 0.6, 0.0);
            }
            if (down) {
                movement = movement.add(0.0, -0.6, 0.0);
            }
            this.setDeltaMovement(movement);
            this.yRotO = this.getYRot();
            this.setYRot(player.getYRot());
            this.yBodyRot = this.getYRot();
            this.yHeadRot = this.getYRot();
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new RandomFlyingGoal(this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.CHORUS_FLOWER);
    }

    @NotNull
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!this.isTame() && this.isFood(itemstack)) {
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            if (this.random.nextInt(3) == 0) {
                this.tame(player);
                this.level().playSound(null, this.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.NEUTRAL, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            this.level().playSound(null, this.blockPosition(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        if (this.isTame() && !this.isFood(itemstack) && !this.isBaby()) {
            player.startRiding((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Sitting", this.isSitting());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSitting(tag.getBoolean("Sitting"));
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        return (AgeableMob)ModEntities.TAMABLE_DRAGON.get().create((Level)serverLevel);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SITTING, (Object)false);
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public void setSitting(boolean sitting) {
        this.entityData.set(SITTING, (Object)sitting);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        return this.getFirstPassenger() instanceof LivingEntity ? (LivingEntity)this.getFirstPassenger() : null;
    }

    public boolean isPushable() {
        return !this.isVehicle();
    }

    protected boolean canRide(@NotNull Entity entity) {
        return false;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return ModSounds.DRAGON_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return SoundEvents.ENDER_DRAGON_HURT;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return ModSounds.DRAGON_ROAR.get();
    }

    public static class RandomFlyingGoal
    extends Goal {
        private final TamableDragon dragon;
        private final double speed;
        private double x;
        private double y;
        private double z;

        public RandomFlyingGoal(TamableDragon dragon, double speed) {
            this.dragon = dragon;
            this.speed = speed;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return !this.dragon.isOrderedToSit() && this.dragon.getTarget() == null && this.dragon.getControllingPassenger() == null && this.dragon.random.nextInt(5) == 0;
        }

        public boolean canContinueToUse() {
            return !this.dragon.getNavigation().isDone();
        }

        public void start() {
            BlockPos pos = this.dragon.blockPosition();
            for (int i = 0; i < 10; ++i) {
                double dx = (double)pos.getX() + (this.dragon.getRandom().nextDouble() * 32.0 - 16.0);
                double dy = (double)pos.getY() + (this.dragon.getRandom().nextDouble() * 16.0 - 8.0);
                double dz = (double)pos.getZ() + (this.dragon.getRandom().nextDouble() * 32.0 - 16.0);
                if (!this.dragon.level().isEmptyBlock(BlockPos.containing((double)dx, (double)dy, (double)dz))) continue;
                this.x = dx;
                this.y = dy;
                this.z = dz;
                this.dragon.getNavigation().moveTo(this.x, this.y, this.z, this.speed);
                break;
            }
        }
    }

    public static class WaterAvoidingRandomFlyingGoal
    extends net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal {
        public WaterAvoidingRandomFlyingGoal(PathfinderMob mob, double speedModifier) {
            super(mob, speedModifier);
        }

        @Nullable
        protected Vec3 getPosition() {
            Vec3 vec3 = DefaultRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)7);
            return vec3 == null ? super.getPosition() : vec3;
        }
    }
}

