/*
 * Decompiled with CFR 0.152.
 */
package com.gharielsl.dragonpet.entity.renderer;

import com.gharielsl.dragonpet.entity.TamableDragon;
import com.gharielsl.dragonpet.entity.animation.TamableDragonAnimations;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class TamableDragonModel<T extends TamableDragon>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"dragon_pet", (String)"tamable_dragon_layer"), "main");
    private final ModelPart bone;
    private final ModelPart head;
    private final ModelPart neck;
    private final ModelPart body;
    private final ModelPart tail_1;
    private final ModelPart tail_2;
    private final ModelPart tail_3;
    private final ModelPart tail_4;
    private final ModelPart wing_right;
    private final ModelPart wing_left;
    private final ModelPart leg_left;
    private final ModelPart leg_right;
    private final ModelPart leg_back_left;
    private final ModelPart leg_back_right;

    public TamableDragonModel(ModelPart root) {
        this.bone = root.getChild("bone");
        this.head = this.bone.getChild("head");
        this.neck = this.bone.getChild("neck");
        this.body = this.bone.getChild("body");
        this.tail_1 = this.bone.getChild("tail_1");
        this.tail_2 = this.bone.getChild("tail_2");
        this.tail_3 = this.bone.getChild("tail_3");
        this.tail_4 = this.bone.getChild("tail_4");
        this.wing_right = this.bone.getChild("wing_right");
        this.wing_left = this.bone.getChild("wing_left");
        this.leg_left = this.bone.getChild("leg_left");
        this.leg_right = this.bone.getChild("leg_right");
        this.leg_back_left = this.bone.getChild("leg_back_left");
        this.leg_back_right = this.bone.getChild("leg_back_right");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bone = partdefinition.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)16.0f, (float)-3.0f));
        PartDefinition head = bone.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 49).addBox(-3.0f, -2.0f, -10.0f, 6.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(34, 61).addBox(-2.0f, 1.0f, -15.0f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(52, 61).addBox(-2.0f, 3.0f, -15.0f, 4.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(62, 57).addBox(-2.0f, -4.0f, -8.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(16, 68).addBox(1.0f, -4.0f, -8.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(16, 72).addBox(1.0f, 0.0f, -14.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(70, 64).addBox(-2.0f, 0.0f, -14.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bone.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(68, 67).addBox(-2.0f, 0.0f, -5.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(40, 76).addBox(1.0f, -2.0f, -5.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(78, 49).addBox(-1.0f, -2.0f, -5.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = bone.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -1.0f, 8.0f, 9.0f, 22.0f, new CubeDeformation(0.0f)).texOffs(12, 76).addBox(-1.0f, -6.0f, 0.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(15, 78).addBox(0.0f, -7.0f, 1.0f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(15, 78).addBox(0.0f, -7.0f, 9.0f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(15, 78).addBox(0.0f, -7.0f, 17.0f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(12, 76).addBox(-1.0f, -6.0f, 8.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(12, 76).addBox(-1.0f, -6.0f, 16.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail_1 = bone.addOrReplaceChild("tail_1", CubeListBuilder.create().texOffs(62, 49).addBox(-2.0f, -2.0f, 21.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(80, 29).addBox(1.0f, -4.0f, 21.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(80, 35).addBox(-1.0f, -4.0f, 21.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail_2 = bone.addOrReplaceChild("tail_2", CubeListBuilder.create().texOffs(62, 49).addBox(-2.0f, -2.0f, 21.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(80, 29).addBox(1.0f, -4.0f, 21.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(80, 35).addBox(-1.0f, -4.0f, 21.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)4.0f));
        PartDefinition tail_3 = bone.addOrReplaceChild("tail_3", CubeListBuilder.create().texOffs(62, 49).addBox(-2.0f, -2.0f, 21.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(80, 29).addBox(1.0f, -4.0f, 21.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(80, 35).addBox(-1.0f, -4.0f, 21.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)8.0f));
        PartDefinition tail_4 = bone.addOrReplaceChild("tail_4", CubeListBuilder.create().texOffs(62, 49).addBox(-2.0f, -2.0f, 21.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(80, 29).addBox(1.0f, -4.0f, 21.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(80, 35).addBox(-1.0f, -4.0f, 21.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)12.0f));
        PartDefinition wing_right = bone.addOrReplaceChild("wing_right", CubeListBuilder.create().texOffs(60, 0).addBox(4.0f, -2.0f, -1.0f, 11.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 31).addBox(4.0f, -1.0f, 1.0f, 11.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 40).addBox(15.0f, -1.0f, 1.0f, 11.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition wing_left = bone.addOrReplaceChild("wing_left", CubeListBuilder.create().texOffs(60, 0).mirror().addBox(-15.0f, -2.0f, -1.0f, 11.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 31).mirror().addBox(-15.0f, -1.0f, 1.0f, 11.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 40).mirror().addBox(-26.0f, -1.0f, 1.0f, 11.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition leg_left = bone.addOrReplaceChild("leg_left", CubeListBuilder.create().texOffs(50, 75).addBox(-7.0f, 2.0f, 1.0f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(72, 16).addBox(-7.0f, 13.0f, -3.0f, 3.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)-3.0f, (float)1.0908f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = leg_left.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(32, 76).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)10.0f, (float)2.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition leg_right = bone.addOrReplaceChild("leg_right", CubeListBuilder.create().texOffs(50, 75).mirror().addBox(4.0f, 2.0f, 1.0f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(72, 16).mirror().addBox(4.0f, 13.0f, -3.0f, 3.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)-3.0f, (float)1.0908f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = leg_right.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(32, 76).mirror().addBox(-1.0f, -2.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)5.0f, (float)10.0f, (float)2.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition leg_back_left = bone.addOrReplaceChild("leg_back_left", CubeListBuilder.create().texOffs(22, 61).addBox(-7.0f, 7.0f, 14.0f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(60, 8).addBox(-8.0f, 19.0f, 12.0f, 5.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)8.0f, (float)1.3963f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = leg_back_left.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(42, 49).addBox(-3.0f, -2.0f, -2.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)3.0f, (float)17.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition leg_back_right = bone.addOrReplaceChild("leg_back_right", CubeListBuilder.create().texOffs(22, 61).mirror().addBox(4.0f, 7.0f, 14.0f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(60, 8).mirror().addBox(3.0f, 19.0f, 12.0f, 5.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)8.0f, (float)1.3963f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = leg_back_right.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(42, 49).mirror().addBox(-2.0f, -2.0f, -2.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)5.0f, (float)3.0f, (float)17.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    private void applyHeadRotation(float pNetHeadYaw, float pHeadPitch, float pAgeInTicks) {
        pNetHeadYaw = Mth.clamp((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.clamp((float)pHeadPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = pHeadPitch * ((float)Math.PI / 180);
    }

    public void setupAnim(TamableDragon entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch, ageInTicks);
        this.animateWalk(TamableDragonAnimations.IDLE, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.animate(entity.idleAnimationState, TamableDragonAnimations.IDLE, ageInTicks, 1.0f);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.bone.render(poseStack, buffer, packedLight, packedOverlay);
    }

    public ModelPart root() {
        return this.bone;
    }
}

