/*
 * Decompiled with CFR 0.152.
 */
package com.gharielsl.dragonpet.event;

import com.gharielsl.dragonpet.entity.ModEntities;
import com.gharielsl.dragonpet.entity.TamableDragon;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber
public class BlockPlacementEvents {
    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        Level level = (Level)event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        BlockPos placedPos = event.getPos();
        BlockState placedState = event.getPlacedBlock();
        if (placedState.getBlock() == Blocks.DRAGON_EGG && BlockPlacementEvents.checkStructure(level, placedPos)) {
            TamableDragon dragon = new TamableDragon(ModEntities.TAMABLE_DRAGON.get(), level);
            dragon.setPos(Vec3.atCenterOf((Vec3i)placedPos.above(2)));
            level.addFreshEntity((Entity)dragon);
            BlockPlacementEvents.clearStructure(level, placedPos);
        }
    }

    private static boolean checkStructure(Level level, BlockPos center) {
        BlockPos[] offsets = new BlockPos[]{new BlockPos(-1, 0, -1), new BlockPos(0, 0, -1), new BlockPos(1, 0, -1), new BlockPos(-1, 0, 0), new BlockPos(1, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(0, 0, 1), new BlockPos(1, 0, 1)};
        BlockState[] expected = new BlockState[]{Blocks.END_ROD.defaultBlockState(), Blocks.DRAGON_HEAD.defaultBlockState(), Blocks.END_ROD.defaultBlockState(), Blocks.DRAGON_HEAD.defaultBlockState(), Blocks.DRAGON_HEAD.defaultBlockState(), Blocks.END_ROD.defaultBlockState(), Blocks.DRAGON_HEAD.defaultBlockState(), Blocks.END_ROD.defaultBlockState()};
        for (int i = 0; i < offsets.length; ++i) {
            BlockPos checkPos = center.offset((Vec3i)offsets[i]);
            BlockState state = level.getBlockState(checkPos);
            if (state.is(expected[i].getBlock())) continue;
            return false;
        }
        return true;
    }

    private static void clearStructure(Level level, BlockPos center) {
        BlockPos[] offsets;
        for (BlockPos offset : offsets = new BlockPos[]{new BlockPos(-1, 0, -1), new BlockPos(0, 0, -1), new BlockPos(1, 0, -1), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 0), new BlockPos(1, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(0, 0, 1), new BlockPos(1, 0, 1)}) {
            level.destroyBlock(center.offset((Vec3i)offset), false);
        }
    }
}

