/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.ancestralarchetypes;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.UUID;
import net.borisshoes.ancestralarchetypes.ArchetypeAbility;
import net.borisshoes.ancestralarchetypes.ArchetypeRegistry;
import net.borisshoes.ancestralarchetypes.callbacks.CommandRegisterCallback;
import net.borisshoes.ancestralarchetypes.callbacks.EntityAttackedCallback;
import net.borisshoes.ancestralarchetypes.callbacks.EntityLoadCallbacks;
import net.borisshoes.ancestralarchetypes.callbacks.EntityUseCallback;
import net.borisshoes.ancestralarchetypes.callbacks.PlayerConnectionCallback;
import net.borisshoes.ancestralarchetypes.callbacks.PlayerRespawnCallback;
import net.borisshoes.ancestralarchetypes.callbacks.TickCallback;
import net.borisshoes.ancestralarchetypes.cca.IArchetypeProfile;
import net.borisshoes.ancestralarchetypes.cca.PlayerComponentInitializer;
import net.borisshoes.ancestralarchetypes.misc.SpyglassRevealEvent;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.config.ConfigManager;
import net.borisshoes.borislib.utils.ItemModDataHandler;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AncestralArchetypes
implements ModInitializer,
ClientModInitializer {
    private static final Logger LOGGER = LogManager.getLogger((String)"Ancestral Archetypes");
    private static final String CONFIG_NAME = "AncestralArchetypes.properties";
    public static final String MOD_ID = "ancestralarchetypes";
    public static ConfigManager CONFIG;
    public static final ArrayList<SpyglassRevealEvent> SPYGLASS_REVEAL_EVENTS;
    public static boolean hasArcana;
    public static final boolean DEV_MODE = false;
    public static final ItemModDataHandler archetypes$ITEM_DATA;

    public void onInitialize() {
        CONFIG = new ConfigManager(MOD_ID, "Ancestral Archetypes", CONFIG_NAME, ArchetypeRegistry.CONFIG_SETTINGS);
        hasArcana = FabricLoader.getInstance().isModLoaded("arcananovum");
        ServerTickEvents.END_SERVER_TICK.register(TickCallback::onTick);
        CommandRegistrationCallback.EVENT.register(CommandRegisterCallback::registerCommands);
        ServerEntityEvents.ENTITY_UNLOAD.register(EntityLoadCallbacks::unloadEntity);
        UseEntityCallback.EVENT.register(EntityUseCallback::useEntity);
        ServerPlayConnectionEvents.DISCONNECT.register(PlayerConnectionCallback::onPlayerLeave);
        ServerPlayConnectionEvents.JOIN.register(PlayerConnectionCallback::onPlayerJoin);
        ServerPlayerEvents.AFTER_RESPAWN.register(PlayerRespawnCallback::onRespawn);
        AttackEntityCallback.EVENT.register(EntityAttackedCallback::attackedEntity);
        ArchetypeRegistry.initialize();
        LOGGER.info("Evolving Ancestral Archetypes Into Your World!");
    }

    public void onInitializeClient() {
        LOGGER.info("Evolving Ancestral Archetypes Into Your Client!");
    }

    public static ArchetypeAbility abilityFromTag(String tag) {
        int lastDotIndex = tag.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return null;
        }
        return (ArchetypeAbility)ArchetypeRegistry.ABILITIES.method_63535(class_2960.method_60655((String)MOD_ID, (String)tag.substring(lastDotIndex + 1)));
    }

    public static IArchetypeProfile profile(class_1657 player) {
        if (player == null) {
            return null;
        }
        try {
            return (IArchetypeProfile)PlayerComponentInitializer.PLAYER_DATA.get((Object)player);
        }
        catch (Exception e) {
            AncestralArchetypes.log(3, "Failed to get Archetype Profile for " + player.method_5820() + " (" + player.method_5845() + ")");
            AncestralArchetypes.log(3, e.toString());
            return null;
        }
    }

    public static IArchetypeProfile getPlayerOrOffline(UUID playerId) {
        MinecraftServer server = BorisLib.SERVER;
        class_3222 player = server.method_3760().method_14602(playerId);
        if (player != null) {
            return (IArchetypeProfile)PlayerComponentInitializer.PLAYER_DATA.get((Object)player);
        }
        GameProfile profile = server.method_3793().method_14512(playerId).orElse(null);
        if (profile == null) {
            return null;
        }
        player = MinecraftUtils.getRequestedPlayer((MinecraftServer)server, (GameProfile)profile);
        return (IArchetypeProfile)PlayerComponentInitializer.PLAYER_DATA.get((Object)player);
    }

    public static void log(int level, String msg) {
        switch (level) {
            case 0: {
                LOGGER.info(msg);
                break;
            }
            case 1: {
                LOGGER.warn(msg);
                break;
            }
            case 2: {
                LOGGER.error(msg);
                break;
            }
            case 3: {
                LOGGER.fatal(msg);
                break;
            }
            default: {
                LOGGER.debug(msg);
            }
        }
    }

    static {
        SPYGLASS_REVEAL_EVENTS = new ArrayList();
        hasArcana = false;
        archetypes$ITEM_DATA = new ItemModDataHandler(MOD_ID);
    }
}

