/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.ancestralarchetypes;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.borisshoes.ancestralarchetypes.AncestralArchetypes;
import net.borisshoes.ancestralarchetypes.Archetype;
import net.borisshoes.ancestralarchetypes.ArchetypeAbility;
import net.borisshoes.ancestralarchetypes.ArchetypeRegistry;
import net.borisshoes.ancestralarchetypes.SubArchetype;
import net.borisshoes.ancestralarchetypes.cca.IArchetypeProfile;
import net.borisshoes.ancestralarchetypes.gui.ArchetypeSelectionGui;
import net.borisshoes.borislib.config.ConfigValue;
import net.borisshoes.borislib.config.IConfigSetting;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_3324;
import net.minecraft.class_3544;
import net.minecraft.class_5148;
import net.minecraft.class_5149;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7417;
import net.minecraft.class_7924;
import net.minecraft.class_8054;
import net.minecraft.server.MinecraftServer;

public class ArchetypeCommands {
    public static CompletableFuture<Suggestions> getPlayerSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        String start = builder.getRemaining().toLowerCase(Locale.ROOT);
        HashSet items = new HashSet();
        ((class_2168)context.getSource()).method_9262().forEach(name -> items.add(name.toLowerCase(Locale.ROOT)));
        items.stream().filter(s -> s.startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> getSubArchetypeSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        String start = builder.getRemaining().toLowerCase(Locale.ROOT);
        HashSet<String> items = new HashSet<String>();
        ArchetypeRegistry.SUBARCHETYPES.method_42021().forEach(key -> items.add(key.method_29177().method_12832().toLowerCase(Locale.ROOT)));
        items.add("none");
        items.stream().filter(s -> s.startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> getTrimSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        String start = builder.getRemaining().toLowerCase(Locale.ROOT);
        HashSet<String> items = new HashSet<String>();
        ((class_2168)context.getSource()).method_9211().method_30611().method_30530(class_7924.field_42083).method_42017().forEach(entry -> items.add(entry.method_55840().replaceAll("^minecraft:", "").toLowerCase(Locale.ROOT)));
        items.add("");
        items.stream().filter(s -> s.startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static <E extends Enum<E>> CompletableFuture<Suggestions> getEnumSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder, Class<E> enumClass) {
        String start = builder.getRemaining().toLowerCase(Locale.ROOT);
        HashSet<String> items = new HashSet<String>();
        for (Enum value : (Enum[])enumClass.getEnumConstants()) {
            items.add(value.name().toLowerCase(Locale.ROOT));
        }
        items.stream().filter(s -> s.startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static int setSubArchetype(CommandContext<class_2168> context, Collection<class_3222> targets, String archetypeId) {
        try {
            class_2168 source = (class_2168)context.getSource();
            SubArchetype subArchetype = (SubArchetype)ArchetypeRegistry.SUBARCHETYPES.method_63535(class_2960.method_60655((String)"ancestralarchetypes", (String)archetypeId));
            if (subArchetype == null && !archetypeId.equals("none")) {
                source.method_9213((class_2561)class_2561.method_43469((String)"command.ancestralarchetypes.invalid_archetype", (Object[])new Object[]{archetypeId}));
                return 0;
            }
            for (class_3222 target : targets) {
                IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)target);
                if (archetypeId.equals("none")) {
                    profile.changeArchetype(null);
                    continue;
                }
                profile.changeArchetype(subArchetype);
            }
            source.method_9226(() -> class_2561.method_43469((String)"command.ancestralarchetypes.changed_archetypes", (Object[])new Object[]{targets.size(), archetypeId}).method_27692(class_124.field_1075), true);
            return 1;
        }
        catch (Exception e) {
            AncestralArchetypes.log(2, e.toString());
            return -1;
        }
    }

    public static int addChanges(CommandContext<class_2168> context, Collection<class_3222> targets, int changes) {
        try {
            class_2168 source = (class_2168)context.getSource();
            for (class_3222 target : targets) {
                IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)target);
                profile.increaseAllowedChanges(changes);
            }
            source.method_9226(() -> class_2561.method_43469((String)"command.ancestralarchetypes.added_changes", (Object[])new Object[]{changes, targets.size()}).method_27692(class_124.field_1075), true);
            return 1;
        }
        catch (Exception e) {
            AncestralArchetypes.log(2, e.toString());
            return -1;
        }
    }

    public static int getAbilities(CommandContext<class_2168> context, String archetypeId) {
        try {
            SubArchetype subArchetype;
            class_2168 source = (class_2168)context.getSource();
            if (!source.method_43737() || source.method_44023() == null) {
                source.method_9213((class_2561)class_2561.method_43471((String)"command.ancestralarchetypes.not_player_error"));
                return -1;
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)player);
            boolean personal = false;
            if (archetypeId == null || archetypeId.isEmpty()) {
                subArchetype = profile.getSubArchetype();
                personal = true;
                if (subArchetype == null) {
                    source.method_9213((class_2561)class_2561.method_43470((String)"You have no archetype"));
                    return 0;
                }
            } else {
                subArchetype = (SubArchetype)ArchetypeRegistry.SUBARCHETYPES.method_63535(class_2960.method_60655((String)"ancestralarchetypes", (String)archetypeId));
                if (subArchetype == null) {
                    source.method_9213((class_2561)class_2561.method_43469((String)"command.ancestralarchetypes.invalid_archetype", (Object[])new Object[]{archetypeId}));
                    return 0;
                }
            }
            class_5250 feedback = class_2561.method_43473();
            if (personal) {
                feedback.method_10852((class_2561)class_2561.method_43469((String)"command.ancestralarchetypes.abilities_get_personal", (Object[])new Object[]{subArchetype.getName().method_54663(subArchetype.getColor()).method_27692(class_124.field_1067), subArchetype.getArchetype().getName().method_54663(subArchetype.getArchetype().getColor()).method_27692(class_124.field_1067)}).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"\n"));
            } else {
                feedback.method_10852((class_2561)class_2561.method_43469((String)"command.ancestralarchetypes.archetype_get", (Object[])new Object[]{subArchetype.getName().method_54663(subArchetype.getColor()).method_27692(class_124.field_1067), subArchetype.getArchetype().getName().method_54663(subArchetype.getArchetype().getColor()).method_27692(class_124.field_1067)}).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"\n"));
            }
            for (ArchetypeAbility ability : subArchetype.getActualAbilities()) {
                feedback.method_10852((class_2561)ability.getName().method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"\n"));
                for (IConfigSetting<?> config : ability.getReliantConfigs()) {
                    class_5250 text = AncestralArchetypes.CONFIG.values.stream().filter(confVal -> confVal.getName().equals(config.getName())).map(confVal -> class_5250.method_43477((class_7417)new class_2588(ConfigValue.getTranslation((String)confVal.getName(), (String)"ancestralarchetypes", (String)"getter_setter"), null, (Object[])new String[]{String.valueOf(confVal.getValueString())}))).findFirst().orElse(class_2561.method_43473());
                    feedback.method_10852((class_2561)class_2561.method_43469((String)"text.ancestralarchetypes.list_item", (Object[])new Object[]{text}).method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"\n"));
                }
            }
            source.method_9226(() -> feedback, false);
            return 1;
        }
        catch (Exception e) {
            AncestralArchetypes.log(2, e.toString());
            return -1;
        }
    }

    public static int resetAbilityCooldowns(CommandContext<class_2168> context) {
        try {
            class_2168 source = (class_2168)context.getSource();
            if (!source.method_43737() || source.method_44023() == null) {
                source.method_9213((class_2561)class_2561.method_43471((String)"command.ancestralarchetypes.not_player_error"));
                return -1;
            }
            return ArchetypeCommands.resetAbilityCooldowns(context, List.of(source.method_44023()));
        }
        catch (Exception e) {
            AncestralArchetypes.log(2, e.toString());
            return -1;
        }
    }

    public static int resetAbilityCooldowns(CommandContext<class_2168> context, Collection<class_3222> targets) {
        try {
            class_2168 source = (class_2168)context.getSource();
            for (class_3222 target : targets) {
                IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)target);
                profile.resetAbilityCooldowns();
            }
            source.method_9226(() -> class_2561.method_43469((String)"command.ancestralarchetypes.reset_cooldowns", (Object[])new Object[]{targets.size()}).method_27692(class_124.field_1075), false);
            return 1;
        }
        catch (Exception e) {
            AncestralArchetypes.log(2, e.toString());
            return -1;
        }
    }

    public static int test(CommandContext<class_2168> context) {
        return 0;
    }

    public static int setGliderColor(CommandContext<class_2168> context, String color, String trimColor) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737() || source.method_44023() == null) {
            source.method_9213((class_2561)class_2561.method_43471((String)"command.ancestralarchetypes.not_player_error"));
            return -1;
        }
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)player);
        try {
            if (color.startsWith("0x")) {
                color = color.substring(2);
            } else if (color.startsWith("#")) {
                color = color.substring(1);
            }
            int parsedColor = color.matches("[0-9A-Fa-f]{6}") ? Integer.parseInt(color, 16) : Integer.parseInt(color);
            if (trimColor.isEmpty()) {
                profile.setGliderTrimMaterial(null);
            } else {
                Optional material = ((class_2168)context.getSource()).method_9211().method_30611().method_30530(class_7924.field_42083).method_10223(class_2960.method_60654((String)trimColor));
                if (material.isEmpty()) {
                    source.method_9213((class_2561)class_2561.method_43471((String)"command.ancestralarchetypes.trim_error"));
                    return -1;
                }
                profile.setGliderTrimMaterial((class_6880<class_8054>)((class_6880)material.get()));
            }
            profile.setGliderColor(parsedColor);
            source.method_9226(() -> class_2561.method_43469((String)"command.ancestralarchetypes.glider_success", (Object[])new Object[]{String.format("%06X", parsedColor), trimColor.isEmpty() ? "none" : trimColor}), false);
            return 1;
        }
        catch (Exception e) {
            try {
                source.method_9213((class_2561)class_2561.method_43471((String)"command.ancestralarchetypes.glider_error"));
                return -1;
            }
            catch (Exception e2) {
                AncestralArchetypes.log(2, e2.toString());
                return -1;
            }
        }
    }

    public static int setHelmetColor(CommandContext<class_2168> context, String color, String trimColor) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737() || source.method_44023() == null) {
            source.method_9213((class_2561)class_2561.method_43471((String)"command.ancestralarchetypes.not_player_error"));
            return -1;
        }
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)player);
        try {
            if (color.startsWith("0x")) {
                color = color.substring(2);
            } else if (color.startsWith("#")) {
                color = color.substring(1);
            }
            int parsedColor = color.matches("[0-9A-Fa-f]{6}") ? Integer.parseInt(color, 16) : Integer.parseInt(color);
            if (trimColor.isEmpty()) {
                profile.setHelmetTrimMaterial(null);
            } else {
                Optional material = ((class_2168)context.getSource()).method_9211().method_30611().method_30530(class_7924.field_42083).method_10223(class_2960.method_60654((String)trimColor));
                if (material.isEmpty()) {
                    source.method_9213((class_2561)class_2561.method_43471((String)"command.ancestralarchetypes.trim_error"));
                    return -1;
                }
                profile.setHelmetTrimMaterial((class_6880<class_8054>)((class_6880)material.get()));
            }
            profile.setHelmetColor(parsedColor);
            source.method_9226(() -> class_2561.method_43469((String)"command.ancestralarchetypes.helmet_success", (Object[])new Object[]{String.format("%06X", parsedColor), trimColor.isEmpty() ? "none" : trimColor}), false);
            return 1;
        }
        catch (Exception e) {
            try {
                source.method_9213((class_2561)class_2561.method_43471((String)"command.ancestralarchetypes.helmet_error"));
                return -1;
            }
            catch (Exception e2) {
                AncestralArchetypes.log(2, e2.toString());
                return -1;
            }
        }
    }

    public static int setHorseVariant(CommandContext<class_2168> context, String color, String markings) {
        try {
            class_2168 source = (class_2168)context.getSource();
            if (!source.method_43737() || source.method_44023() == null) {
                source.method_9213((class_2561)class_2561.method_43471((String)"command.ancestralarchetypes.not_player_error"));
                return -1;
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)player);
            class_5149 horseColor = Arrays.stream(class_5149.values()).filter(value -> value.name().equalsIgnoreCase(color)).findFirst().orElse(null);
            class_5148 marking = Arrays.stream(class_5148.values()).filter(value -> value.name().equalsIgnoreCase(markings)).findFirst().orElse(null);
            if (horseColor == null || marking == null) {
                source.method_9213((class_2561)class_2561.method_43471((String)"command.ancestralarchetypes.horse_error"));
                return -1;
            }
            profile.setHorseVariant(horseColor, marking);
            source.method_9226(() -> class_2561.method_43469((String)"command.ancestralarchetypes.horse_success", (Object[])new Object[]{horseColor.name() + " " + marking.name()}), false);
            return 1;
        }
        catch (Exception e) {
            AncestralArchetypes.log(2, e.toString());
            return -1;
        }
    }

    public static int setMountName(CommandContext<class_2168> context, String name) {
        try {
            class_2168 source = (class_2168)context.getSource();
            if (!source.method_43737() || source.method_44023() == null) {
                source.method_9213((class_2561)class_2561.method_43471((String)"command.ancestralarchetypes.not_player_error"));
                return -1;
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)player);
            if (name != null) {
                String sanitized = class_3544.method_57180((String)name);
                if (sanitized.length() > 50) {
                    source.method_9213((class_2561)class_2561.method_43471((String)"command.ancestralarchetypes.mount_name_error"));
                    return -1;
                }
                name = sanitized;
            }
            profile.setMountName(name);
            String finalName = name;
            if (name != null) {
                source.method_9226(() -> class_2561.method_43469((String)"command.ancestralarchetypes.mount_name_success", (Object[])new Object[]{finalName}), false);
            } else {
                source.method_9226(() -> class_2561.method_43471((String)"command.ancestralarchetypes.mount_name_reset"), false);
            }
            return 1;
        }
        catch (Exception e) {
            AncestralArchetypes.log(2, e.toString());
            return -1;
        }
    }

    public static int getItems(CommandContext<class_2168> context) {
        try {
            class_2168 source = (class_2168)context.getSource();
            if (!source.method_43737() || source.method_44023() == null) {
                source.method_9213((class_2561)class_2561.method_43471((String)"command.ancestralarchetypes.not_player_error"));
                return -1;
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)player);
            if (!profile.giveAbilityItems(false)) {
                source.method_9213((class_2561)class_2561.method_43471((String)"command.ancestralarchetypes.ability_items_error"));
                return -1;
            }
            source.method_9226(() -> class_2561.method_43471((String)"command.ancestralarchetypes.ability_items_success"), false);
            return 1;
        }
        catch (Exception e) {
            AncestralArchetypes.log(2, e.toString());
            return -1;
        }
    }

    public static int toggleReminders(CommandContext<class_2168> context) {
        try {
            class_2168 source = (class_2168)context.getSource();
            if (!source.method_43737() || source.method_44023() == null) {
                source.method_9213((class_2561)class_2561.method_43471((String)"command.ancestralarchetypes.not_player_error"));
                return -1;
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)player);
            boolean giveReminders = !profile.giveReminders();
            profile.setReminders(giveReminders);
            source.method_9226(() -> class_2561.method_43469((String)"command.ancestralarchetypes.reminders", (Object[])new Object[]{giveReminders ? "true" : "false"}), false);
            return 1;
        }
        catch (Exception e) {
            AncestralArchetypes.log(2, e.toString());
            return -1;
        }
    }

    public static int changeArchetype(CommandContext<class_2168> context) {
        try {
            class_2168 source = (class_2168)context.getSource();
            if (!source.method_43737() || source.method_44023() == null) {
                source.method_9213((class_2561)class_2561.method_43471((String)"command.ancestralarchetypes.not_player_error"));
                return -1;
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)player);
            if (!profile.canChangeArchetype()) {
                source.method_9213((class_2561)class_2561.method_43471((String)"command.ancestralarchetypes.change_archetype_error"));
                return -1;
            }
            ArchetypeSelectionGui selectionGui = new ArchetypeSelectionGui(player, null, false);
            selectionGui.open();
            return 1;
        }
        catch (Exception e) {
            AncestralArchetypes.log(2, e.toString());
            return -1;
        }
    }

    public static int archetypeList(CommandContext<class_2168> context) {
        try {
            class_2168 source = (class_2168)context.getSource();
            if (!source.method_43737() || source.method_44023() == null) {
                source.method_9213((class_2561)class_2561.method_43471((String)"command.ancestralarchetypes.not_player_error"));
                return -1;
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)player);
            ArchetypeSelectionGui selectionGui = new ArchetypeSelectionGui(player, null, true);
            selectionGui.open();
            return 1;
        }
        catch (Exception e) {
            AncestralArchetypes.log(2, e.toString());
            return -1;
        }
    }

    private static HashMap<class_3222, IArchetypeProfile> getAllPlayerData(MinecraftServer server) {
        HashMap<class_3222, IArchetypeProfile> data = new HashMap<class_3222, IArchetypeProfile>();
        try {
            class_3312 userCache = server.method_3793();
            ArrayList<class_3222> allPlayers = new ArrayList<class_3222>();
            List cacheEntries = userCache.method_14517();
            for (class_3312.class_3313 cacheEntry : cacheEntries) {
                GameProfile reqProfile = cacheEntry.method_14519();
                class_3222 reqPlayer = MinecraftUtils.getRequestedPlayer((MinecraftServer)server, (GameProfile)reqProfile);
                allPlayers.add(reqPlayer);
            }
            for (class_3222 player : allPlayers) {
                IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)player);
                data.put(player, profile);
            }
            return data;
        }
        catch (Exception e) {
            AncestralArchetypes.log(2, e.toString());
            return data;
        }
    }

    public static int getDistribution(CommandContext<class_2168> context) {
        try {
            class_2168 src = (class_2168)context.getSource();
            HashMap<SubArchetype, Integer> archetypeCounter = new HashMap<SubArchetype, Integer>();
            for (SubArchetype subarchetype : ArchetypeRegistry.SUBARCHETYPES) {
                archetypeCounter.put(subarchetype, 0);
            }
            archetypeCounter.put(null, 0);
            for (IArchetypeProfile profile : ArchetypeCommands.getAllPlayerData(src.method_9211()).values()) {
                if (profile == null) {
                    AncestralArchetypes.log(1, "An error occurred loading a null profile");
                    continue;
                }
                SubArchetype subArchetype2 = profile.getSubArchetype();
                archetypeCounter.compute(subArchetype2, (k, count) -> count + 1);
            }
            StringBuilder masterString = new StringBuilder(class_2561.method_43471((String)"text.ancestralarchetypes.distribution_header").getString());
            src.method_9226(() -> class_2561.method_43471((String)"text.ancestralarchetypes.distribution_header"), false);
            archetypeCounter.forEach((subArchetype, integer) -> {
                int color = subArchetype == null ? 0xFFFFFF : subArchetype.getColor();
                class_5250 name = subArchetype == null ? class_2561.method_43471((String)"text.ancestralarchetypes.none") : subArchetype.getName();
                class_5250 text = class_2561.method_43473().method_54663(color).method_10852((class_2561)name).method_10852((class_2561)class_2561.method_43470((String)" - ").method_10852((class_2561)class_2561.method_43470((String)String.format("%,d", integer))));
                src.method_9226(() -> ArchetypeCommands.lambda$getDistribution$24((class_2561)text), false);
                masterString.append("\n").append(text.getString());
            });
            src.method_9226(() -> class_2561.method_43471((String)"text.ancestralarchetypes.dump_copy").method_27694(s -> s.method_10958((class_2558)new class_2558.class_10606(masterString.toString()))), false);
            return 1;
        }
        catch (Exception e) {
            AncestralArchetypes.log(2, e.toString());
            return -1;
        }
    }

    public static int getAllPlayerArchetypes(CommandContext<class_2168> context) {
        try {
            class_2168 src = (class_2168)context.getSource();
            AncestralArchetypes.log(0, class_2561.method_43471((String)"text.ancestralarchetypes.dump_init").getString());
            StringBuilder masterString = new StringBuilder(class_2561.method_43471((String)"text.ancestralarchetypes.dump_header").getString());
            ArchetypeCommands.getAllPlayerData(src.method_9211()).forEach((player, profile) -> {
                SubArchetype subArchetype = profile.getSubArchetype();
                Archetype archetype = profile.getArchetype();
                class_5250 subName = subArchetype == null ? class_2561.method_43471((String)"text.ancestralarchetypes.none") : subArchetype.getName();
                class_5250 name = archetype == null ? class_2561.method_43471((String)"text.ancestralarchetypes.none") : archetype.getName();
                String str = "\n" + class_2561.method_43469((String)"text.ancestralarchetypes.archetype_player_get", (Object[])new Object[]{player.method_55423(), subName, name}).getString();
                masterString.append(str);
            });
            src.method_9226(() -> class_2561.method_43471((String)"text.ancestralarchetypes.dump_copy").method_27694(s -> s.method_10958((class_2558)new class_2558.class_10606(masterString.toString()))), false);
            AncestralArchetypes.log(0, masterString.toString());
            return 1;
        }
        catch (Exception e) {
            AncestralArchetypes.log(2, e.toString());
            return -1;
        }
    }

    public static int getPlayersOfArchetype(CommandContext<class_2168> context, String archetypeId) {
        try {
            class_2168 src = (class_2168)context.getSource();
            SubArchetype subArchetype = (SubArchetype)ArchetypeRegistry.SUBARCHETYPES.method_63535(class_2960.method_60655((String)"ancestralarchetypes", (String)archetypeId));
            if (subArchetype == null && !archetypeId.equals("none")) {
                src.method_9213((class_2561)class_2561.method_43469((String)"command.ancestralarchetypes.invalid_archetype", (Object[])new Object[]{archetypeId}));
                return 0;
            }
            class_5250 subName = subArchetype == null ? class_2561.method_43471((String)"text.ancestralarchetypes.none") : subArchetype.getName();
            AncestralArchetypes.log(0, class_2561.method_43469((String)"text.ancestralarchetypes.type_dump_init", (Object[])new Object[]{subName}).getString());
            StringBuilder masterString = new StringBuilder(class_2561.method_43469((String)"text.ancestralarchetypes.dump_type_header", (Object[])new Object[]{subName}).getString());
            ArchetypeCommands.getAllPlayerData(src.method_9211()).forEach((player, profile) -> {
                SubArchetype playerArchetype = profile.getSubArchetype();
                if (playerArchetype == subArchetype) {
                    Archetype archetype = profile.getArchetype();
                    class_5250 name = archetype == null ? class_2561.method_43471((String)"text.ancestralarchetypes.none") : archetype.getName();
                    String str = "\n" + class_2561.method_43469((String)"text.ancestralarchetypes.archetype_player_get", (Object[])new Object[]{player.method_55423(), subName, name}).getString();
                    masterString.append(str);
                }
            });
            src.method_9226(() -> class_2561.method_43471((String)"text.ancestralarchetypes.dump_copy").method_27694(s -> s.method_10958((class_2558)new class_2558.class_10606(masterString.toString()))), false);
            AncestralArchetypes.log(0, masterString.toString());
            return 1;
        }
        catch (Exception e) {
            AncestralArchetypes.log(2, e.toString());
            return -1;
        }
    }

    public static int getArchetype(CommandContext<class_2168> context, String target) {
        try {
            class_2168 source = (class_2168)context.getSource();
            MinecraftServer server = source.method_9211();
            class_3324 manger = server.method_3760();
            class_3222 player = manger.method_14566(target);
            IArchetypeProfile profile = null;
            if (player != null) {
                profile = AncestralArchetypes.profile((class_1657)player);
            } else {
                class_3312 userCache = server.method_3793();
                List cacheEntries = userCache.method_14517();
                for (class_3312.class_3313 cacheEntry : cacheEntries) {
                    GameProfile reqProfile = cacheEntry.method_14519();
                    if (!reqProfile.getName().equalsIgnoreCase(target)) continue;
                    player = MinecraftUtils.getRequestedPlayer((MinecraftServer)server, (GameProfile)reqProfile);
                    profile = AncestralArchetypes.profile((class_1657)player);
                    break;
                }
                if (profile == null) {
                    source.method_9213((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.no_player_found"));
                    return 0;
                }
            }
            SubArchetype subArchetype = profile.getSubArchetype();
            Archetype archetype = profile.getArchetype();
            class_5250 subName = subArchetype == null ? class_2561.method_43471((String)"text.ancestralarchetypes.none") : subArchetype.getName();
            class_5250 name = archetype == null ? class_2561.method_43471((String)"text.ancestralarchetypes.none") : archetype.getName();
            int color = subArchetype == null ? 0xFFFFFF : subArchetype.getColor();
            class_3222 finalPlayer = player;
            source.method_9226(() -> class_2561.method_43469((String)"text.ancestralarchetypes.archetype_player_get", (Object[])new Object[]{finalPlayer.method_55423(), subName, name}).method_54663(color), false);
            return 1;
        }
        catch (Exception e) {
            AncestralArchetypes.log(2, e.toString());
            return -1;
        }
    }

    private static /* synthetic */ class_2561 lambda$getDistribution$24(class_2561 text) {
        return text;
    }
}

