/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.ancestralarchetypes.callbacks;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.borisshoes.ancestralarchetypes.AncestralArchetypes;
import net.borisshoes.ancestralarchetypes.ArchetypeAbility;
import net.borisshoes.ancestralarchetypes.ArchetypeRegistry;
import net.borisshoes.ancestralarchetypes.SubArchetype;
import net.borisshoes.ancestralarchetypes.cca.IArchetypeProfile;
import net.borisshoes.ancestralarchetypes.items.AbilityItem;
import net.borisshoes.ancestralarchetypes.misc.SpyglassRevealEvent;
import net.borisshoes.ancestralarchetypes.mixins.EntityAccessor;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.tracker.PlayerMovementEntry;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_10124;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1702;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2743;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class TickCallback {
    public static void onTick(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            double lavaHeight;
            IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)player);
            class_3218 world = player.method_51469();
            TickCallback.deathReductionSize(profile, player);
            class_1661 inv = player.method_31548();
            for (int i = 0; i < inv.method_5439(); ++i) {
                class_1799 stack = inv.method_5438(i);
                TickCallback.inventoryItem(profile, player, stack);
            }
            profile.tick();
            TickCallback.stopEat(profile, player);
            TickCallback.slowfaller(profile, player);
            TickCallback.spyglass(profile, player);
            if (profile.hasAbility(ArchetypeRegistry.ANTIVENOM) && player.method_6059(class_1294.field_5899)) {
                player.method_6016(class_1294.field_5899);
            }
            if (profile.hasAbility(ArchetypeRegistry.WITHERING) && player.method_6059(class_1294.field_5920)) {
                player.method_6016(class_1294.field_5920);
            }
            if (profile.hasAbility(ArchetypeRegistry.REGEN_WHEN_LOW) && (double)player.method_6032() < (double)player.method_6063() / 2.0 && !player.method_29504()) {
                player.method_6025((float)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.REGENERATION_RATE));
            }
            if (profile.hasAbility(ArchetypeRegistry.HEALTH_BASED_SPRINT)) {
                boolean canSprint;
                class_1702 hungerManager = player.method_7344();
                boolean bl = canSprint = player.method_6032() / player.method_6063() > (float)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.HEALTH_SPRINT_CUTOFF);
                if (canSprint) {
                    hungerManager.method_7580(20);
                } else {
                    hungerManager.method_7580(2);
                }
            }
            if (profile.hasAbility(ArchetypeRegistry.LAVA_WALKER) && player.method_5861(class_3486.field_15518) > 0.0 && !player.method_5715() && (lavaHeight = player.method_5861(class_3486.field_15518)) > 0.1) {
                class_243 v = player.method_18798();
                double targetDepth = (double)player.method_17682() * 0.25;
                double error = lavaHeight - targetDepth;
                double gain = 0.16;
                double bobAmp = 0.025;
                double bobFreq = 0.2;
                double bobBand = 0.18;
                boolean inBand = Math.abs(error) < bobBand;
                double damping = inBand ? 0.8 : 0.95;
                double cmd = gain * error - damping * v.field_1351;
                if (Math.abs(error) < bobBand) {
                    cmd += bobAmp * Math.sin((double)player.field_6012 * bobFreq);
                }
                double vyDelta = class_3532.method_15350((double)cmd, (double)-0.08, (double)0.08);
                double newVy = class_3532.method_15350((double)(v.field_1351 + vyDelta), (double)-0.35, (double)0.35);
                class_243 newVel = new class_243(v.field_1352 * 0.99, newVy, v.field_1350 * 0.99);
                player.method_18799(newVel);
                if (newVel.method_1025(v) > 1.0E-7) {
                    player.field_13987.method_14364((class_2596)new class_2743(player.method_5628(), newVel));
                }
            }
            if (server.method_3780() % 5 == 0 && profile.hasAbility(ArchetypeRegistry.SHY) && !world.method_18766(p -> p.method_5739((class_1297)player) < 255.0f && !player.method_5845().equals(p.method_5845()) && class_1309.field_54564.test(player) && player.method_64619((class_1309)p, 1.0 - Math.cos(AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.SHY_VIEWING_ANGLE)), true, false, new double[]{player.method_23320()}) && class_1309.field_54564.test(p) && p.method_64619((class_1309)player, 1.0 - Math.cos(AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.SHY_NOTICING_ANGLE)), true, false, new double[]{p.method_23320()})).isEmpty()) {
                player.method_6092(new class_1293(class_1294.field_5909, 6, 9, false, false, true));
            }
            TickCallback.importantAttributes(profile, player);
            if (server.method_3780() % 5 == 0) {
                TickCallback.attributes(profile, player);
                TickCallback.effects(profile, player);
            }
            if (server.method_3780() % 20 == 0) {
                boolean shouldMelt;
                boolean bl = shouldMelt = profile.hasAbility(ArchetypeRegistry.HURT_BY_WATER) && !player.method_6059(class_1294.field_5923) && player.method_5721() && !player.method_68878() && !player.method_7325();
                if (shouldMelt) {
                    if (player.method_5799()) {
                        player.method_64397(world, world.method_48963().method_48824(), (float)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.HURT_BY_WATER_SWIM_DAMAGE));
                    } else if (((EntityAccessor)player).rainedOn() && server.method_3780() % 40 == 0) {
                        player.method_64397(world, world.method_48963().method_48824(), (float)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.HURT_BY_WATER_RAIN_DAMAGE));
                    }
                    world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14821, player.method_5634(), 0.4f, 2.0f + player.method_59922().method_43057() * 0.4f);
                }
            }
            if (server.method_3780() % 40 == 0) {
                TickCallback.temperatureCheck(profile, player);
            }
            if (player.method_5682().method_3780() % 18000 != 0 || !profile.giveReminders()) continue;
            TickCallback.reminders(profile, player);
        }
        AncestralArchetypes.SPYGLASS_REVEAL_EVENTS.forEach(SpyglassRevealEvent::tickCooldown);
        AncestralArchetypes.SPYGLASS_REVEAL_EVENTS.removeIf(event -> event.getCooldown() < 0);
    }

    private static void slowfaller(IArchetypeProfile profile, class_3222 player) {
        if (profile.hasAbility(ArchetypeRegistry.SLOW_FALLER)) {
            double yMov;
            boolean shouldTriggerSlowFall;
            int predictedFallDist = 0;
            for (int y = player.method_31478(); y >= player.method_31478() - player.method_51469().method_31605(); --y) {
                class_2338 blockPos = new class_2338(player.method_31477(), y, player.method_31479());
                class_2680 state = player.method_51469().method_8320(blockPos);
                if (!state.method_26215() && !state.method_26220((class_1922)player.method_51469(), blockPos).method_1110()) break;
                ++predictedFallDist;
            }
            boolean bl = shouldTriggerSlowFall = (yMov = BorisLib.PLAYER_MOVEMENT_TRACKER.getOrDefault(player, PlayerMovementEntry.blankEntry((class_3222)player)).velocity().method_10214()) < -AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.SLOW_FALLER_TRIGGER_SPEED) && !player.method_6128() && !player.method_31549().field_7479 && (double)predictedFallDist > player.method_45325(class_5134.field_49079) && !player.method_5681();
            if (shouldTriggerSlowFall) {
                if (!player.method_5715()) {
                    if (!player.method_6059(class_1294.field_5906)) {
                        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14550, (float)0.3f, (float)1.0f);
                    } else if (yMov < -1.25 * AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.SLOW_FALLER_TRIGGER_SPEED)) {
                        player.method_5762(0.0, 0.2, 0.0);
                        player.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
                    }
                    class_1293 slowFall = new class_1293(class_1294.field_5906, 60, 0, false, false, true);
                    player.method_6092(slowFall);
                }
                player.field_13987.field_14138 = 0;
            }
        }
    }

    private static void temperatureCheck(IArchetypeProfile profile, class_3222 player) {
        boolean shouldDryOut;
        boolean shouldFreeze;
        class_3218 world = player.method_51469();
        class_6880 biome = player.method_51469().method_23753(player.method_24515());
        float temp = ((class_1959)biome.comp_349()).method_8712();
        boolean bl = shouldFreeze = (biome.method_40220(ArchetypeRegistry.COLD_DAMAGE_INCLUDE_BIOMES) || (double)temp < 0.1 && !biome.method_40220(ArchetypeRegistry.COLD_DAMAGE_EXCEPTION_BIOMES)) && profile.hasAbility(ArchetypeRegistry.DAMAGED_BY_COLD) && !player.method_6059(class_1294.field_5923) && !player.method_68878() && !player.method_7325();
        if (shouldFreeze) {
            player.method_64397(world, world.method_48963().method_48836(), (float)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.BIOME_DAMAGE));
            player.method_7353((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.freeze_warning").method_27695(new class_124[]{class_124.field_1075, class_124.field_1056}), true);
            SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_27853, (float)1.0f, (float)1.0f);
        }
        boolean bl2 = shouldDryOut = (biome.method_40220(ArchetypeRegistry.DRY_OUT_INCLUDE_BIOMES) || !((class_1959)biome.comp_349()).method_48163() && !biome.method_40220(ArchetypeRegistry.DRY_OUT_EXCEPTION_BIOMES)) && profile.hasAbility(ArchetypeRegistry.DRIES_OUT) && !player.method_5799() && !player.method_6059(class_1294.field_5918) && !player.method_68878() && !player.method_7325() && !player.method_6118(class_1304.field_6169).method_31574(class_1802.field_8090);
        if (shouldDryOut) {
            player.method_64397(world, world.method_48963().method_48834(), (float)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.BIOME_DAMAGE));
            player.method_7353((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.dry_out_warning").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
            SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15013, (float)1.0f, (float)1.0f);
        }
    }

    private static void reminders(IArchetypeProfile profile, class_3222 player) {
        if (profile.getSubArchetype() == null && profile.canChangeArchetype()) {
            player.method_64398((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.archetype_reminder").method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/archetypes changeArchetype")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.change_hover"))).method_10977(class_124.field_1075)));
        }
        List<ArchetypeAbility> abilities = profile.getAbilities();
        boolean giveWarning = false;
        block0: for (ArchetypeAbility ability : abilities) {
            if (!ability.isActive()) continue;
            for (class_1792 item : ArchetypeRegistry.ITEMS) {
                if (!(item instanceof AbilityItem)) continue;
                AbilityItem abilityItem = (AbilityItem)item;
                if (!ability.equals(abilityItem.ability)) continue;
                boolean found = false;
                class_1661 inv = player.method_31548();
                for (int i = 0; i < inv.method_5439(); ++i) {
                    class_1799 stack = inv.method_5438(i);
                    if (!stack.method_31574((class_1792)abilityItem)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                giveWarning = true;
                break block0;
            }
        }
        if (giveWarning) {
            player.method_64398((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.ability_reminder").method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/archetypes items")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.items_hover"))).method_10977(class_124.field_1075)));
        }
    }

    private static void spyglass(IArchetypeProfile profile, class_3222 player) {
        boolean spyglass = AncestralArchetypes.CONFIG.getBoolean(ArchetypeRegistry.SPYGLASS_REVEALS_ARCHETYPE);
        if (spyglass) {
            int warmup = AncestralArchetypes.CONFIG.getInt(ArchetypeRegistry.SPYGLASS_INVESTIGATE_DURATION);
            boolean alert = AncestralArchetypes.CONFIG.getBoolean(ArchetypeRegistry.SPYGLASS_REVEAL_ALERTS_PLAYER);
            class_1799 activeStack = player.method_6030();
            if (activeStack != null && activeStack.method_31574(class_1802.field_27070)) {
                MinecraftUtils.LasercastResult lasercast = MinecraftUtils.lasercast((class_1937)player.method_51469(), (class_243)player.method_33571(), (class_243)player.method_5663(), (double)(player.method_5682().method_3760().method_14568() * 16), (boolean)true, (class_1297)player);
                for (class_1297 entity : lasercast.sortedHits()) {
                    if (!(entity instanceof class_3222)) continue;
                    class_3222 target = (class_3222)entity;
                    if (AncestralArchetypes.SPYGLASS_REVEAL_EVENTS.stream().anyMatch(event -> event.isReset() && event.getTarget().equals((Object)target) && event.getInspector().equals((Object)player))) continue;
                    AncestralArchetypes.SPYGLASS_REVEAL_EVENTS.add(new SpyglassRevealEvent(player, target, (int)((double)warmup * 1.125), false));
                    break;
                }
            }
            HashMap<class_3222, Integer> revealers = new HashMap<class_3222, Integer>();
            for (SpyglassRevealEvent event2 : AncestralArchetypes.SPYGLASS_REVEAL_EVENTS) {
                if (!event2.getTarget().equals((Object)player) || event2.isReset()) continue;
                revealers.compute(event2.getInspector(), (k, count) -> count == null ? 1 : count + 1);
            }
            AtomicInteger highestRevealCount = new AtomicInteger();
            revealers.forEach((inspector, count) -> {
                if (count > highestRevealCount.get()) {
                    highestRevealCount.set((int)count);
                }
                double percentage = (double)count.intValue() / (double)warmup;
                StringBuilder message = new StringBuilder("\ud83d\udd0d ");
                for (int i = 0; i < 20; ++i) {
                    if (percentage * 20.0 > (double)i) {
                        message.append("|");
                        continue;
                    }
                    message.append("\u00a6");
                }
                message.append(" \ud83d\udd0d");
                if (inspector.method_6030() != null && inspector.method_6030().method_31574(class_1802.field_27070)) {
                    inspector.method_7353((class_2561)class_2561.method_43470((String)message.toString()).method_27692(class_124.field_1065), true);
                }
                if (percentage > 1.0) {
                    SubArchetype subArchetype = profile.getSubArchetype();
                    if (subArchetype == null) {
                        inspector.method_7353((class_2561)class_2561.method_43469((String)"text.ancestralarchetypes.inspect_no_archetype", (Object[])new Object[]{player.method_55423()}).method_27692(class_124.field_1075), false);
                    } else {
                        inspector.method_7353((class_2561)class_2561.method_43469((String)"text.ancestralarchetypes.inspect_results", (Object[])new Object[]{player.method_55423(), subArchetype.getName().method_27692(TextUtils.getClosestFormatting((int)subArchetype.getColor()))}).method_27692(class_124.field_1075), false);
                    }
                    if (alert) {
                        player.method_64398((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.inspected").method_27692(class_124.field_1061));
                    }
                    AncestralArchetypes.SPYGLASS_REVEAL_EVENTS.removeIf(event -> event.getInspector().equals(inspector) && event.getTarget().equals((Object)player));
                    AncestralArchetypes.SPYGLASS_REVEAL_EVENTS.add(new SpyglassRevealEvent((class_3222)inspector, player, 1200, true));
                }
            });
            if (alert && highestRevealCount.get() > 0) {
                double percentage = (double)highestRevealCount.get() / (double)warmup;
                StringBuilder message = new StringBuilder();
                for (int i = 0; i < 20; ++i) {
                    if (percentage * 20.0 > (double)i) {
                        message.append("|");
                        continue;
                    }
                    message.append("\u00a6");
                }
                player.method_7353((class_2561)class_2561.method_43469((String)"text.ancestralarchetypes.inspection_in_progress", (Object[])new Object[]{message.toString()}).method_27692(class_124.field_1065), true);
            }
        }
    }

    private static void effects(IArchetypeProfile profile, class_3222 player) {
        if (profile.hasAbility(ArchetypeRegistry.FIRE_IMMUNE)) {
            class_1293 fireRes = new class_1293(class_1294.field_5918, 110, 0, false, false, true);
            player.method_6092(fireRes);
            if (player.method_5809()) {
                player.method_5646();
            }
        }
        if (profile.hasAbility(ArchetypeRegistry.INSATIABLE)) {
            class_1702 hungerManager = player.method_7344();
            hungerManager.method_7583((float)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.INSATIATBLE_HUNGER_RATE));
        }
        if (profile.hasAbility(ArchetypeRegistry.WEAVING)) {
            player.method_6092(new class_1293(class_1294.field_50119, 110, 0, false, false, true));
        }
        if (profile.hasAbility(ArchetypeRegistry.MOONLIT_CAVE_SPIDER) && player.method_51469().method_27983().equals(class_3218.field_25179)) {
            long timeOfDay = player.method_51469().method_8532();
            int day = (int)(timeOfDay / 24000L % Integer.MAX_VALUE);
            int curPhase = day % 8;
            int moonLevel = Math.abs(-curPhase + 4);
            if (moonLevel == 2) {
                player.method_6092(new class_1293(class_1294.field_5904, 110, 0, false, false, true));
            } else if (moonLevel == 3) {
                player.method_6092(new class_1293(class_1294.field_5910, 110, 0, false, false, true));
            } else if (moonLevel == 4) {
                player.method_6092(new class_1293(class_1294.field_5924, 110, 0, false, false, true));
            }
        }
    }

    public static void importantAttributes(IArchetypeProfile profile, class_3222 player) {
        if (profile.hasAbility(ArchetypeRegistry.GOOD_SWIMMER)) {
            if (player.method_5869()) {
                class_1293 conduitPower = new class_1293(class_1294.field_5927, 110, 0, false, false, true);
                player.method_6092(conduitPower);
            }
            MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_51578, (double)1.0, (class_1322.class_1323)class_1322.class_1323.field_6328, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"swim_buff"), (boolean)false);
        } else {
            MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_51578, (double)1.0, (class_1322.class_1323)class_1322.class_1323.field_6328, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"swim_buff"), (boolean)true);
        }
        if (profile.hasAbility(ArchetypeRegistry.GREAT_SWIMMER) && player.method_5721()) {
            MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_23719, (double)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.GREAT_SWIMMER_MOVE_SPEED_MODIFIER), (class_1322.class_1323)class_1322.class_1323.field_6330, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"great_swimmer"), (boolean)false);
        } else {
            MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_23719, (double)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.GREAT_SWIMMER_MOVE_SPEED_MODIFIER), (class_1322.class_1323)class_1322.class_1323.field_6330, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"great_swimmer"), (boolean)true);
        }
        MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_23719, (double)-1.0, (class_1322.class_1323)class_1322.class_1323.field_6331, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"fortify"), (!profile.isFortifyActive() ? 1 : 0) != 0);
        MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_23728, (double)-1.0, (class_1322.class_1323)class_1322.class_1323.field_6331, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"fortify"), (!profile.isFortifyActive() ? 1 : 0) != 0);
        MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_23719, (double)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.FUNGUS_SPEED_BOOST_MULTIPLIER), (class_1322.class_1323)class_1322.class_1323.field_6330, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"fungus_speed_boost"), (!profile.isFungusBoosted() ? 1 : 0) != 0);
        class_1297 vehicle = player.method_5854();
        boolean gaveReach = false;
        if (vehicle != null && !vehicle.method_5752().stream().filter(s -> s.contains("$ancestralarchetypes.spirit_mount")).toList().isEmpty()) {
            MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_47758, (double)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.MOUNTED_RANGE), (class_1322.class_1323)class_1322.class_1323.field_6328, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"mounted_reach"), (boolean)false);
            MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_47759, (double)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.MOUNTED_RANGE), (class_1322.class_1323)class_1322.class_1323.field_6328, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"mounted_reach"), (boolean)false);
            MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_49079, (double)10.0, (class_1322.class_1323)class_1322.class_1323.field_6328, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"mounted_fall"), (boolean)false);
            gaveReach = true;
        }
        if (!gaveReach) {
            MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_47758, (double)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.MOUNTED_RANGE), (class_1322.class_1323)class_1322.class_1323.field_6328, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"mounted_reach"), (boolean)true);
            MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_47759, (double)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.MOUNTED_RANGE), (class_1322.class_1323)class_1322.class_1323.field_6328, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"mounted_reach"), (boolean)true);
            MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_49079, (double)10.0, (class_1322.class_1323)class_1322.class_1323.field_6328, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"mounted_fall"), (boolean)true);
        }
    }

    public static void attributes(IArchetypeProfile profile, class_3222 player) {
        MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_47760, (double)-0.5, (class_1322.class_1323)class_1322.class_1323.field_6330, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"half_sized"), (!profile.hasAbility(ArchetypeRegistry.HALF_SIZED) ? 1 : 0) != 0);
        MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_23716, (double)-0.5, (class_1322.class_1323)class_1322.class_1323.field_6330, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"half_sized"), (!profile.hasAbility(ArchetypeRegistry.HALF_SIZED) ? 1 : 0) != 0);
        MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_47760, (double)0.25, (class_1322.class_1323)class_1322.class_1323.field_6330, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"tall_sized"), (!profile.hasAbility(ArchetypeRegistry.TALL_SIZED) ? 1 : 0) != 0);
        MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_47760, (double)0.5, (class_1322.class_1323)class_1322.class_1323.field_6330, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"giant_sized"), (!profile.hasAbility(ArchetypeRegistry.GIANT_SIZED) ? 1 : 0) != 0);
        MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_23716, (double)1.0, (class_1322.class_1323)class_1322.class_1323.field_6330, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"giant_sized"), (!profile.hasAbility(ArchetypeRegistry.GIANT_SIZED) ? 1 : 0) != 0);
        MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_47760, (double)0.75, (class_1322.class_1323)class_1322.class_1323.field_6330, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"massive_sized"), (!profile.hasAbility(ArchetypeRegistry.MASSIVE_SIZED) ? 1 : 0) != 0);
        MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_23716, (double)1.0, (class_1322.class_1323)class_1322.class_1323.field_6330, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"massive_sized"), (!profile.hasAbility(ArchetypeRegistry.MASSIVE_SIZED) ? 1 : 0) != 0);
        MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_47759, (double)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.LONG_ARMS_RANGE), (class_1322.class_1323)class_1322.class_1323.field_6328, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"long_arms"), (!profile.hasAbility(ArchetypeRegistry.LONG_ARMS) ? 1 : 0) != 0);
        MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_47758, (double)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.LONG_ARMS_RANGE), (class_1322.class_1323)class_1322.class_1323.field_6328, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"long_arms"), (!profile.hasAbility(ArchetypeRegistry.LONG_ARMS) ? 1 : 0) != 0);
        MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_23719, (double)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.SPEEDY_SPEED_BOOST), (class_1322.class_1323)class_1322.class_1323.field_6330, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"speedy"), (!profile.hasAbility(ArchetypeRegistry.SPEEDY) ? 1 : 0) != 0);
        MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_51584, (double)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.SNEAKY_SPEED_BOOST), (class_1322.class_1323)class_1322.class_1323.field_6330, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"sneaky"), (!profile.hasAbility(ArchetypeRegistry.SNEAKY) ? 1 : 0) != 0);
        MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_23728, (double)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.JUMPY_JUMP_BOOST), (class_1322.class_1323)class_1322.class_1323.field_6328, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"jumpy"), (!profile.hasAbility(ArchetypeRegistry.JUMPY) ? 1 : 0) != 0);
        MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_49079, (double)(AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.JUMPY_JUMP_BOOST) * 10.0), (class_1322.class_1323)class_1322.class_1323.field_6328, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"jumpy"), (!profile.hasAbility(ArchetypeRegistry.JUMPY) ? 1 : 0) != 0);
        MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_23722, (double)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.HARD_HITTER_KNOCKBACK_INCREASE), (class_1322.class_1323)class_1322.class_1323.field_6328, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"hard_hitter"), (!profile.hasAbility(ArchetypeRegistry.HARD_HITTER) ? 1 : 0) != 0);
        MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_23723, (double)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.HASTY_ATTACK_SPEED_INCREASE), (class_1322.class_1323)class_1322.class_1323.field_6331, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"hasty"), (!profile.hasAbility(ArchetypeRegistry.HASTY) ? 1 : 0) != 0);
        MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_49079, (double)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.RESILIENT_JOINTS_EXTRA_FALL_BLOCKS), (class_1322.class_1323)class_1322.class_1323.field_6328, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"resilient_joints"), (!profile.hasAbility(ArchetypeRegistry.RESILIENT_JOINTS) ? 1 : 0) != 0);
        long timeOfDay = player.method_51469().method_8532();
        int day = (int)(timeOfDay / 24000L % Integer.MAX_VALUE);
        int curPhase = day % 8;
        int moonLevel = Math.abs(-curPhase + 4);
        for (int i = 0; i <= 4; ++i) {
            class_2960 id = class_2960.method_60655((String)"ancestralarchetypes", (String)("slime_moonlit_" + i));
            if (moonLevel == i && profile.hasAbility(ArchetypeRegistry.MOONLIT_SLIME) && profile.hasAbility(ArchetypeRegistry.SLIME_TOTEM)) {
                MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_23716, (double)(AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.MOONLIT_SLIME_HEALTH_PER_PHASE) * (double)i), (class_1322.class_1323)class_1322.class_1323.field_6330, (class_2960)id, (boolean)false);
                MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_47760, (double)(AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.MOONLIT_SLIME_SIZE_PER_PHASE) * (double)i), (class_1322.class_1323)class_1322.class_1323.field_6331, (class_2960)id, (boolean)false);
                continue;
            }
            MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_23716, (double)(AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.MOONLIT_SLIME_HEALTH_PER_PHASE) * (double)i), (class_1322.class_1323)class_1322.class_1323.field_6330, (class_2960)id, (boolean)true);
            MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_47760, (double)(AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.MOONLIT_SLIME_SIZE_PER_PHASE) * (double)i), (class_1322.class_1323)class_1322.class_1323.field_6331, (class_2960)id, (boolean)true);
        }
    }

    public static void deathReductionSize(IArchetypeProfile profile, class_3222 player) {
        if (profile.getHealthUpdate() != 0.0f) {
            double scale = -(1.0 - Math.pow(0.5, profile.getDeathReductionSizeLevel()));
            MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_23716, (double)scale, (class_1322.class_1323)class_1322.class_1323.field_6331, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"death_reduction_size_level"), (boolean)true);
            MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_47760, (double)scale, (class_1322.class_1323)class_1322.class_1323.field_6331, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"death_reduction_size_level"), (boolean)true);
            MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_23716, (double)scale, (class_1322.class_1323)class_1322.class_1323.field_6331, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"death_reduction_size_level"), (boolean)false);
            MinecraftUtils.attributeEffect((class_1309)player, (class_6880)class_5134.field_47760, (double)scale, (class_1322.class_1323)class_1322.class_1323.field_6331, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"death_reduction_size_level"), (boolean)false);
            if (player.method_6063() >= profile.getHealthUpdate()) {
                player.method_6033(profile.getHealthUpdate());
                profile.setHealthUpdate(0.0f);
            }
        }
    }

    public static void inventoryItem(IArchetypeProfile profile, class_3222 player, class_1799 stack) {
        boolean shouldHaveWaxEatComponent;
        HashMap<class_1792, class_3545<Float, Integer>> map = null;
        boolean unusualFood = ArchetypeRegistry.TUFF_FOODS.containsKey(stack.method_7909()) || ArchetypeRegistry.COPPER_FOODS.containsKey(stack.method_7909()) || ArchetypeRegistry.IRON_FOODS.containsKey(stack.method_7909()) || stack.method_31573(ArchetypeRegistry.MAGMA_CUBE_GROW_ITEMS) || stack.method_31573(ArchetypeRegistry.SLIME_GROW_ITEMS) || stack.method_31574(class_1802.field_21988) || stack.method_31574(class_1802.field_20414);
        float durationMod = 1.0f;
        if (profile.hasAbility(ArchetypeRegistry.TUFF_EATER) && ArchetypeRegistry.TUFF_FOODS.containsKey(stack.method_7909())) {
            map = ArchetypeRegistry.TUFF_FOODS;
            durationMod = (float)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.TUFF_FOOD_DURATION_MODIFIER);
        }
        if (profile.hasAbility(ArchetypeRegistry.COPPER_EATER) && ArchetypeRegistry.COPPER_FOODS.containsKey(stack.method_7909())) {
            map = ArchetypeRegistry.COPPER_FOODS;
            durationMod = (float)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.COPPER_FOOD_DURATION_MODIFIER);
        }
        if (profile.hasAbility(ArchetypeRegistry.IRON_EATER) && ArchetypeRegistry.IRON_FOODS.containsKey(stack.method_7909())) {
            map = ArchetypeRegistry.IRON_FOODS;
            durationMod = (float)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.IRON_FOOD_DURATION_MODIFIER);
        }
        class_1799 mainhand = player.method_6047();
        class_1799 offhand = player.method_6079();
        boolean inHand = stack.equals(mainhand) || stack.equals(offhand);
        boolean shouldHaveGolemEatComponent = inHand && map != null && player.method_6032() < player.method_6063();
        boolean shouldHaveGelatianEatComponent = inHand && profile.getDeathReductionSizeLevel() != 0 && (profile.hasAbility(ArchetypeRegistry.SLIME_TOTEM) && stack.method_31573(ArchetypeRegistry.SLIME_GROW_ITEMS) || profile.hasAbility(ArchetypeRegistry.MAGMA_TOTEM) && stack.method_31573(ArchetypeRegistry.MAGMA_CUBE_GROW_ITEMS));
        boolean shouldHaveFungusEatComponent = inHand && profile.hasAbility(ArchetypeRegistry.FUNGUS_SPEED_BOOST) && stack.method_31574(class_1802.field_21988);
        boolean bl = shouldHaveWaxEatComponent = inHand && profile.hasAbility(ArchetypeRegistry.WAX_SHIELD) && stack.method_31574(class_1802.field_20414) && (double)player.method_6067() < AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.WAX_SHIELD_MAX_HEALTH);
        if (shouldHaveGolemEatComponent) {
            if (!stack.method_57826(class_9334.field_53964)) {
                class_3545<Float, Integer> pair = map.get(stack.method_7909());
                class_10124 comp = class_10124.method_62850().method_62855((class_6880)class_3417.field_20614).method_62853(class_1839.field_8950).method_62852((float)((Integer)pair.method_15441()).intValue() / 20.0f * durationMod).method_62856(true).method_62851();
                stack.method_57379(class_9334.field_53964, (Object)comp);
            }
        } else if (shouldHaveGelatianEatComponent) {
            if (!stack.method_57826(class_9334.field_53964)) {
                class_10124 comp = class_10124.method_62850().method_62855((class_6880)class_3417.field_20614).method_62853(class_1839.field_8950).method_62852((float)AncestralArchetypes.CONFIG.getInt(ArchetypeRegistry.GELATIAN_GROW_ITEM_EAT_DURATION) / 20.0f).method_62856(true).method_62851();
                stack.method_57379(class_9334.field_53964, (Object)comp);
            }
        } else if (shouldHaveFungusEatComponent) {
            if (!stack.method_57826(class_9334.field_53964)) {
                class_10124 comp = class_10124.method_62850().method_62855(class_7923.field_41172.method_47983((Object)class_3417.field_23207)).method_62853(class_1839.field_8950).method_62852((float)AncestralArchetypes.CONFIG.getInt(ArchetypeRegistry.FUNGUS_SPEED_BOOST_CONSUME_DURATION) / 20.0f).method_62856(true).method_62851();
                stack.method_57379(class_9334.field_53964, (Object)comp);
            }
        } else if (shouldHaveWaxEatComponent) {
            if (!stack.method_57826(class_9334.field_53964)) {
                class_10124 comp = class_10124.method_62850().method_62855(class_7923.field_41172.method_47983((Object)class_3417.field_29543)).method_62853(class_1839.field_8950).method_62852((float)AncestralArchetypes.CONFIG.getInt(ArchetypeRegistry.WAX_SHIELD_CONSUME_DURATION) / 20.0f).method_62856(true).method_62851();
                stack.method_57379(class_9334.field_53964, (Object)comp);
            }
        } else if (unusualFood && stack.method_57826(class_9334.field_53964)) {
            stack.method_57381(class_9334.field_53964);
        }
    }

    private static void stopEat(IArchetypeProfile profile, class_3222 player) {
        if (player.method_6115() && player.method_6030().method_57826(class_9334.field_50075)) {
            boolean stopUsing = false;
            if (profile.hasAbility(ArchetypeRegistry.CARNIVORE) && !player.method_6030().method_31573(ArchetypeRegistry.CARNIVORE_FOODS)) {
                stopUsing = true;
            } else if (profile.hasAbility(ArchetypeRegistry.COPPER_EATER) || profile.hasAbility(ArchetypeRegistry.IRON_EATER) || profile.hasAbility(ArchetypeRegistry.TUFF_EATER)) {
                stopUsing = true;
            }
            if (stopUsing) {
                player.method_7357().method_62835(player.method_6030(), 20);
                player.method_6075();
                player.method_7353((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.cannot_eat").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_19149, (float)1.0f, (float)0.5f);
            }
        }
    }
}

