/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.ancestralarchetypes.cca;

import io.github.ladysnake.pal.VanillaAbilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.borisshoes.ancestralarchetypes.AncestralArchetypes;
import net.borisshoes.ancestralarchetypes.Archetype;
import net.borisshoes.ancestralarchetypes.ArchetypeAbility;
import net.borisshoes.ancestralarchetypes.ArchetypeRegistry;
import net.borisshoes.ancestralarchetypes.SubArchetype;
import net.borisshoes.ancestralarchetypes.cca.IArchetypeProfile;
import net.borisshoes.ancestralarchetypes.items.AbilityItem;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.utils.AlgoUtils;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.ParticleEffectUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_11343;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1277;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2696;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_5134;
import net.minecraft.class_5148;
import net.minecraft.class_5149;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8054;

public class ArchetypeProfile
implements IArchetypeProfile {
    private final class_1657 player;
    private boolean giveReminders = AncestralArchetypes.CONFIG.getBoolean(ArchetypeRegistry.REMINDERS_ON_BY_DEFAULT);
    private boolean gliderActive;
    private boolean hoverActive;
    private boolean fortifyActive;
    private int deathReductionSizeLevel;
    private float glideTime;
    private float hoverTime;
    private float fortifyTime;
    private float savedFlySpeed = 0.05f;
    private int fungusBoostTime;
    private int gliderColor = 0xFFFFFF;
    private int helmetColor = 10511680;
    private class_6880<class_8054> gliderTrimMaterial;
    private class_6880<class_8054> helmetTrimMaterial;
    private int archetypeChangesAllowed = AncestralArchetypes.CONFIG.getInt(ArchetypeRegistry.STARTING_ARCHETYPE_CHANGES);
    private int giveItemsCooldown;
    private float healthUpdate;
    private class_1799 potionBrewerStack = class_1799.field_8037;
    private class_5148 horseMarking = class_5148.field_23808;
    private class_5149 horseColor = class_5149.field_23818;
    private String mountName = null;
    private SubArchetype subArchetype;
    private final ArrayList<ArchetypeAbility> abilities = new ArrayList();
    private final HashMap<ArchetypeAbility, CooldownEntry> abilityCooldowns = new HashMap();
    private final HashMap<ArchetypeAbility, class_3545<UUID, Float>> mountData = new HashMap();
    private final class_1277 mountInventory = new class_1277(54);
    private final class_1277 backpackInventory = new class_1277(18);

    public ArchetypeProfile(class_1657 player) {
        this.player = player;
    }

    public void readData(class_11368 view) {
        ArchetypeAbility ability;
        this.deathReductionSizeLevel = view.method_71424("deathReductionSizeLevel", 0);
        this.glideTime = view.method_71423("glideTime", 0.0f);
        this.hoverTime = view.method_71423("hoverTime", 0.0f);
        this.fortifyTime = view.method_71423("fortifyTime", 0.0f);
        this.savedFlySpeed = view.method_71423("savedFlySpeed", 0.05f);
        this.gliderActive = view.method_71433("gliderActive", false);
        this.hoverActive = view.method_71433("hoverActive", false);
        this.fortifyActive = view.method_71433("fortifyActive", false);
        this.archetypeChangesAllowed = view.method_71424("archetypeChangesAllowed", 0);
        this.fungusBoostTime = view.method_71424("fungusBoostTime", 0);
        this.gliderColor = view.method_71424("gliderColor", 0xFFFFFF);
        this.helmetColor = view.method_71424("helmetColor", 10511680);
        this.gliderTrimMaterial = BorisLib.SERVER.method_30611().method_30530(class_7924.field_42083).method_10223(class_2960.method_60654((String)view.method_71428("gliderTrimMaterial", ""))).orElse(null);
        this.helmetTrimMaterial = BorisLib.SERVER.method_30611().method_30530(class_7924.field_42083).method_10223(class_2960.method_60654((String)view.method_71428("helmetTrimMaterial", ""))).orElse(null);
        this.giveReminders = view.method_71433("giveReminders", AncestralArchetypes.CONFIG.getBoolean(ArchetypeRegistry.REMINDERS_ON_BY_DEFAULT));
        this.subArchetype = (SubArchetype)ArchetypeRegistry.SUBARCHETYPES.method_63535(class_2960.method_60655((String)"ancestralarchetypes", (String)view.method_71428("subArchetype", "")));
        this.giveItemsCooldown = view.method_71424("giveItemsCooldown", 0);
        this.healthUpdate = view.method_71423("loginHealth", 20.0f);
        this.calculateAbilities();
        this.abilityCooldowns.clear();
        class_2487 cooldownTag = view.method_71426("cooldowns", class_2487.field_25128).orElse(new class_2487());
        for (String key : cooldownTag.method_10541()) {
            class_2487 compound = cooldownTag.method_10562(key).orElse(new class_2487());
            ability = (ArchetypeAbility)ArchetypeRegistry.ABILITIES.method_63535(class_2960.method_60655((String)"ancestralarchetypes", (String)key));
            if (ability == null) continue;
            this.abilityCooldowns.put(ability, new CooldownEntry(compound.method_68083("cooldown", 0), compound.method_68083("duration", 0)));
        }
        this.potionBrewerStack = view.method_71426("potionBrewerStack", class_1799.field_24671).orElse(class_1799.field_8037);
        this.horseMarking = class_5148.method_27080((int)view.method_71424("horseMarking", 0));
        this.horseColor = class_5149.method_27083((int)view.method_71424("horseColor", 0));
        this.mountName = view.method_71428("mountName", "");
        this.mountData.clear();
        class_2487 mountDataTag = view.method_71426("mountData", class_2487.field_25128).orElse(new class_2487());
        for (String key : mountDataTag.method_10541()) {
            ability = (ArchetypeAbility)ArchetypeRegistry.ABILITIES.method_63535(class_2960.method_60655((String)"ancestralarchetypes", (String)key));
            if (ability == null) continue;
            class_2487 entryTag = mountDataTag.method_10562(key).orElse(new class_2487());
            UUID uuid = AlgoUtils.getUUID((String)entryTag.method_68564("id", ""));
            this.mountData.put(ability, (class_3545<UUID, Float>)new class_3545((Object)uuid, (Object)Float.valueOf(entryTag.method_66563("hp", 1.0f))));
        }
        this.mountInventory.method_5448();
        for (class_11343 stackWithSlot : view.method_71437("mountInventory", class_11343.field_60354)) {
            if (!stackWithSlot.method_71368(this.mountInventory.method_54454().size())) continue;
            this.mountInventory.method_54454().set(stackWithSlot.comp_4211(), (Object)stackWithSlot.comp_4212());
        }
        this.backpackInventory.method_5448();
        for (class_11343 stackWithSlot : view.method_71437("backpackInventory", class_11343.field_60354)) {
            if (!stackWithSlot.method_71368(this.backpackInventory.method_54454().size())) continue;
            this.backpackInventory.method_54454().set(stackWithSlot.comp_4211(), (Object)stackWithSlot.comp_4212());
        }
    }

    public void writeData(class_11372 view) {
        class_1799 itemStack;
        int i;
        view.method_71465("deathReductionSizeLevel", this.deathReductionSizeLevel);
        view.method_71465("gliderColor", this.gliderColor);
        view.method_71465("helmetColor", this.helmetColor);
        view.method_71465("horseMarking", this.horseMarking.method_27079());
        view.method_71465("horseColor", this.horseColor.method_27082());
        view.method_71465("archetypeChangesAllowed", this.archetypeChangesAllowed);
        view.method_71465("giveItemsCooldown", this.giveItemsCooldown);
        view.method_71465("fungusBoostTime", this.fungusBoostTime);
        view.method_71464("glideTime", this.glideTime);
        view.method_71464("hoverTime", this.hoverTime);
        view.method_71464("fortifyTime", this.fortifyTime);
        view.method_71464("savedFlySpeed", this.savedFlySpeed);
        view.method_71464("loginHealth", this.healthUpdate);
        view.method_71472("giveReminders", this.giveReminders);
        view.method_71472("gliderActive", this.gliderActive);
        view.method_71472("hoverActive", this.hoverActive);
        view.method_71472("fortifyActive", this.fortifyActive);
        view.method_71469("subArchetype", this.subArchetype != null ? this.subArchetype.getId() : "");
        view.method_71469("gliderTrimMaterial", this.gliderTrimMaterial == null ? "" : this.gliderTrimMaterial.method_55840());
        view.method_71469("helmetTrimMaterial", this.helmetTrimMaterial == null ? "" : this.helmetTrimMaterial.method_55840());
        if (this.mountName != null) {
            view.method_71469("mountName", this.mountName);
        }
        class_2487 cooldownTag = new class_2487();
        for (Map.Entry<ArchetypeAbility, CooldownEntry> entry : this.abilityCooldowns.entrySet()) {
            class_2487 cooldownAbilityTag = new class_2487();
            cooldownAbilityTag.method_10569("cooldown", entry.getValue().getCooldown());
            cooldownAbilityTag.method_10569("duration", entry.getValue().getTotalDuration());
            cooldownTag.method_10566(entry.getKey().getId(), (class_2520)cooldownAbilityTag);
        }
        view.method_71468("cooldowns", class_2487.field_25128, (Object)cooldownTag);
        if (!this.potionBrewerStack.method_7960()) {
            view.method_71468("potionBrewerStack", class_1799.field_24671, (Object)this.potionBrewerStack);
        }
        class_2487 mountDataTag = new class_2487();
        this.mountData.forEach((ability, pair) -> {
            class_2487 tagEntry = new class_2487();
            tagEntry.method_10582("id", pair.method_15442() != null ? ((UUID)pair.method_15442()).toString() : "");
            tagEntry.method_10548("hp", ((Float)pair.method_15441()).floatValue());
            mountDataTag.method_10566(ability.getId(), (class_2520)tagEntry);
        });
        view.method_71468("mountData", class_2487.field_25128, (Object)mountDataTag);
        class_11372.class_11373 listAppender = view.method_71467("mountInventory", class_11343.field_60354);
        for (i = 0; i < this.mountInventory.method_54454().size(); ++i) {
            itemStack = (class_1799)this.mountInventory.method_54454().get(i);
            if (itemStack.method_7960()) continue;
            listAppender.method_71484((Object)new class_11343(i, itemStack));
        }
        listAppender.method_71483();
        listAppender = view.method_71467("backpackInventory", class_11343.field_60354);
        for (i = 0; i < this.backpackInventory.method_54454().size(); ++i) {
            itemStack = (class_1799)this.backpackInventory.method_54454().get(i);
            if (itemStack.method_7960()) continue;
            listAppender.method_71484((Object)new class_11343(i, itemStack));
        }
        listAppender.method_71483();
    }

    private void calculateAbilities() {
        this.abilities.clear();
        if (this.subArchetype == null) {
            return;
        }
        this.abilities.addAll(Arrays.asList(this.subArchetype.getAbilities()));
        this.abilities.addAll(Arrays.asList(this.subArchetype.getArchetype().getAbilities()));
        this.abilities.removeIf(a1 -> this.abilities.stream().anyMatch(a2 -> a2.overrides((ArchetypeAbility)a1)));
    }

    @Override
    public List<ArchetypeAbility> getAbilities() {
        return new ArrayList<ArchetypeAbility>(this.abilities);
    }

    @Override
    public int getAbilityCooldown(ArchetypeAbility ability) {
        return this.abilityCooldowns.getOrDefault(ability, new CooldownEntry(0)).getCooldown();
    }

    @Override
    public float getAbilityCooldownPercent(ArchetypeAbility ability) {
        return this.abilityCooldowns.getOrDefault(ability, new CooldownEntry(0)).getPercentage();
    }

    @Override
    public class_1799 getPotionStack() {
        return this.potionBrewerStack.method_7972();
    }

    @Override
    public float getGlideTime() {
        return this.glideTime;
    }

    @Override
    public int getMaxGlideTime() {
        return AncestralArchetypes.CONFIG.getInt(ArchetypeRegistry.GLIDER_DURATION);
    }

    @Override
    public float getHoverTime() {
        return this.hoverTime;
    }

    @Override
    public int getMaxHoverTime() {
        return AncestralArchetypes.CONFIG.getInt(ArchetypeRegistry.SLOW_HOVER_FLIGHT_DURATION);
    }

    @Override
    public float getFortifyTime() {
        return this.fortifyTime;
    }

    @Override
    public int getMaxFortifyTime() {
        return AncestralArchetypes.CONFIG.getInt(ArchetypeRegistry.FORTIFY_DURATION);
    }

    @Override
    public boolean isFortifyActive() {
        return this.fortifyActive;
    }

    @Override
    public void setFortifyActive(boolean fortifyActive) {
        this.fortifyActive = fortifyActive;
    }

    @Override
    public boolean isFungusBoosted() {
        return this.fungusBoostTime > 0;
    }

    @Override
    public void fungusBoost() {
        this.fungusBoostTime = AncestralArchetypes.CONFIG.getInt(ArchetypeRegistry.FUNGUS_SPEED_BOOST_DURATION);
    }

    @Override
    public UUID getMountEntity(ArchetypeAbility ability) {
        class_3545<UUID, Float> data = this.mountData.get(ability);
        if (data != null) {
            return (UUID)data.method_15442();
        }
        return null;
    }

    @Override
    public float getMountHealth(ArchetypeAbility ability) {
        class_3545<UUID, Float> data = this.mountData.get(ability);
        if (data != null) {
            return ((Float)data.method_15441()).floatValue();
        }
        return 0.0f;
    }

    @Override
    public boolean hasAbility(ArchetypeAbility ability) {
        if (this.subArchetype == null) {
            return false;
        }
        return this.abilities.contains(ability);
    }

    @Override
    public int getDeathReductionSizeLevel() {
        return this.deathReductionSizeLevel;
    }

    @Override
    public SubArchetype getSubArchetype() {
        return this.subArchetype;
    }

    @Override
    public Archetype getArchetype() {
        if (this.subArchetype != null) {
            return this.subArchetype.getArchetype();
        }
        return null;
    }

    @Override
    public class_1277 getMountInventory() {
        return this.mountInventory;
    }

    @Override
    public class_1277 getBackpackInventory() {
        return this.backpackInventory;
    }

    @Override
    public class_5148 getHorseMarking() {
        return this.horseMarking;
    }

    @Override
    public class_5149 getHorseColor() {
        return this.horseColor;
    }

    @Override
    public String getMountName() {
        return this.mountName;
    }

    @Override
    public int getGliderColor() {
        return this.gliderColor;
    }

    @Override
    public int getHelmetColor() {
        return this.helmetColor;
    }

    @Override
    public class_6880<class_8054> getGliderTrimMaterial() {
        return this.gliderTrimMaterial;
    }

    @Override
    public class_6880<class_8054> getHelmetTrimMaterial() {
        return this.helmetTrimMaterial;
    }

    @Override
    public boolean canChangeArchetype() {
        return this.archetypeChangesAllowed > 0;
    }

    @Override
    public boolean giveReminders() {
        return this.giveReminders;
    }

    @Override
    public void setSubarchetype(SubArchetype subarchetype) {
        this.subArchetype = subarchetype;
        this.calculateAbilities();
        this.resetDeathReductionSizeLevel();
    }

    @Override
    public void changeDeathReductionSizeLevel(boolean decrease) {
        if (this.deathReductionSizeLevel > 0 && decrease) {
            --this.deathReductionSizeLevel;
        } else if (!decrease) {
            ++this.deathReductionSizeLevel;
        } else {
            return;
        }
        MinecraftUtils.attributeEffect((class_1309)this.player, (class_6880)class_5134.field_23716, (double)0.0, (class_1322.class_1323)class_1322.class_1323.field_6331, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"death_reduction_size_level"), (boolean)true);
        MinecraftUtils.attributeEffect((class_1309)this.player, (class_6880)class_5134.field_47760, (double)0.0, (class_1322.class_1323)class_1322.class_1323.field_6331, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"death_reduction_size_level"), (boolean)true);
        double scale = -(1.0 - Math.pow(0.5, this.deathReductionSizeLevel));
        MinecraftUtils.attributeEffect((class_1309)this.player, (class_6880)class_5134.field_23716, (double)scale, (class_1322.class_1323)class_1322.class_1323.field_6331, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"death_reduction_size_level"), (boolean)false);
        MinecraftUtils.attributeEffect((class_1309)this.player, (class_6880)class_5134.field_47760, (double)scale, (class_1322.class_1323)class_1322.class_1323.field_6331, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"death_reduction_size_level"), (boolean)false);
        this.player.method_6033(this.player.method_6063());
    }

    @Override
    public void resetDeathReductionSizeLevel() {
        this.deathReductionSizeLevel = 0;
        MinecraftUtils.attributeEffect((class_1309)this.player, (class_6880)class_5134.field_23716, (double)0.0, (class_1322.class_1323)class_1322.class_1323.field_6331, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"death_reduction_size_level"), (boolean)true);
        MinecraftUtils.attributeEffect((class_1309)this.player, (class_6880)class_5134.field_47760, (double)0.0, (class_1322.class_1323)class_1322.class_1323.field_6331, (class_2960)class_2960.method_60655((String)"ancestralarchetypes", (String)"death_reduction_size_level"), (boolean)true);
    }

    @Override
    public void setAbilityCooldown(ArchetypeAbility ability, int ticks) {
        this.abilityCooldowns.put(ability, new CooldownEntry(ticks));
    }

    @Override
    public void tick() {
        this.abilityCooldowns.forEach((ability, cooldown) -> cooldown.tick());
        this.handleGlider();
        this.handleHover();
        this.handleFortify();
        if (this.fungusBoostTime > 0) {
            --this.fungusBoostTime;
            ((class_3218)this.player.method_37908()).method_65096((class_2394)new class_2390(2148273, 0.75f), this.player.method_19538().method_10216(), this.player.method_19538().method_10214() + (double)this.player.method_17682() / 2.0, this.player.method_19538().method_10215(), 1, (double)this.player.method_17681() * 0.65, (double)this.player.method_17682() / 2.0, (double)this.player.method_17681() * 0.65, 1.0);
        }
        if (this.giveItemsCooldown > 0) {
            --this.giveItemsCooldown;
        }
        if (AncestralArchetypes.CONFIG.getBoolean(ArchetypeRegistry.CAN_ALWAYS_CHANGE_ARCHETYPE) && !this.canChangeArchetype()) {
            ++this.archetypeChangesAllowed;
        }
    }

    private void handleFortify() {
        if (!this.fortifyActive) {
            this.fortifyTime = (float)Math.min((double)AncestralArchetypes.CONFIG.getInt(ArchetypeRegistry.FORTIFY_DURATION), (double)this.fortifyTime + AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.FORTIFY_RECOVERY_TIME));
        } else {
            this.fortifyTime -= 1.0f;
            if ((int)this.fortifyTime % 2 == 0) {
                double height = (double)(this.player.method_17682() / 2.0f) * (Math.sin(0.10471975511965977 * (double)this.fortifyTime) + 1.0);
                ParticleEffectUtils.circle((class_3218)((class_3218)this.player.method_37908()), null, (class_243)this.player.method_19538().method_1031(0.0, height, 0.0), (class_2394)class_2398.field_11207, (double)this.player.method_17681(), (int)((int)(this.player.method_17681() * 12.0f)), (int)1, (double)0.0, (double)0.0);
            }
        }
    }

    private void handleGlider() {
        boolean gliderEquipped;
        boolean wasGliderActive = this.gliderActive;
        boolean bl = gliderEquipped = this.player.method_6118(class_1304.field_6174).method_31574(ArchetypeRegistry.GLIDER_ITEM) || this.player.method_6118(class_1304.field_6174).method_31574(ArchetypeRegistry.END_GLIDER_ITEM);
        if (gliderEquipped && this.player.method_6128()) {
            if (!wasGliderActive) {
                this.gliderActive = true;
            }
            this.glideTime -= 1.0f;
        } else {
            if (wasGliderActive) {
                this.gliderActive = false;
                this.setAbilityCooldown(ArchetypeRegistry.WING_GLIDER, AncestralArchetypes.CONFIG.getInt(ArchetypeRegistry.GLIDER_COOLDOWN));
                this.setAbilityCooldown(ArchetypeRegistry.ENDER_GLIDER, AncestralArchetypes.CONFIG.getInt(ArchetypeRegistry.GLIDER_COOLDOWN));
            }
            if (this.getAbilityCooldown(ArchetypeRegistry.WING_GLIDER) + this.getAbilityCooldown(ArchetypeRegistry.ENDER_GLIDER) == 0) {
                this.glideTime = (float)Math.min((double)AncestralArchetypes.CONFIG.getInt(ArchetypeRegistry.GLIDER_DURATION), (double)this.glideTime + AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.GLIDER_RECOVERY_TIME));
            }
        }
        if (this.glideTime < 0.0f) {
            this.glideTime = 0.0f;
            this.setAbilityCooldown(ArchetypeRegistry.WING_GLIDER, AncestralArchetypes.CONFIG.getInt(ArchetypeRegistry.GLIDER_COOLDOWN));
            this.setAbilityCooldown(ArchetypeRegistry.ENDER_GLIDER, AncestralArchetypes.CONFIG.getInt(ArchetypeRegistry.GLIDER_COOLDOWN));
        }
    }

    private void handleHover() {
        boolean canHover;
        boolean bl = canHover = !this.player.method_68878() && this.player.method_6118(class_1304.field_6169).method_31574(ArchetypeRegistry.SLOW_HOVER_ITEM) && this.getAbilityCooldown(ArchetypeRegistry.SLOW_HOVER) == 0 && this.hoverTime > 0.0f;
        if (ArchetypeRegistry.SLOW_HOVER_ABILITY.grants(this.player, VanillaAbilities.ALLOW_FLYING) && !canHover) {
            ArchetypeRegistry.SLOW_HOVER_ABILITY.revokeFrom(this.player, VanillaAbilities.ALLOW_FLYING);
        } else if (!ArchetypeRegistry.SLOW_HOVER_ABILITY.grants(this.player, VanillaAbilities.ALLOW_FLYING) && canHover) {
            ArchetypeRegistry.SLOW_HOVER_ABILITY.grantTo(this.player, VanillaAbilities.ALLOW_FLYING);
        }
        boolean hovering = !this.player.method_68878() && VanillaAbilities.ALLOW_FLYING.getTracker(this.player).isEnabled() && VanillaAbilities.ALLOW_FLYING.getTracker(this.player).isGrantedBy(ArchetypeRegistry.SLOW_HOVER_ABILITY) && VanillaAbilities.FLYING.isEnabledFor(this.player);
        boolean wasHovering = this.hoverActive;
        if (hovering) {
            if (!wasHovering) {
                this.hoverActive = true;
                SoundUtils.playSound((class_1937)this.player.method_37908(), (class_2338)this.player.method_24515(), (class_3414)class_3417.field_14550, (class_3419)class_3419.field_15248, (float)0.5f, (float)1.25f);
                SoundUtils.playSound((class_1937)this.player.method_37908(), (class_2338)this.player.method_24515(), (class_3414)class_3417.field_59657, (class_3419)class_3419.field_15248, (float)0.5f, (float)0.8f);
                this.savedFlySpeed = this.player.method_31549().method_7252();
                this.player.method_31549().method_7248((float)AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.SLOW_HOVER_FLIGHT_SPEED));
                ((class_3222)this.player).field_13987.method_14364((class_2596)new class_2696(this.player.method_31549()));
            }
            this.hoverTime -= 1.0f;
            if (this.player.method_59922().method_43058() < 0.4) {
                ((class_3222)this.player).method_51469().method_65096((class_2394)class_2398.field_11203, this.player.method_23317(), this.player.method_23318() - 0.5, this.player.method_23321(), 1, 0.2, 0.2, 0.2, 0.01);
            }
        } else {
            if (wasHovering) {
                this.hoverActive = false;
                this.setAbilityCooldown(ArchetypeRegistry.SLOW_HOVER, AncestralArchetypes.CONFIG.getInt(ArchetypeRegistry.SLOW_HOVER_FLIGHT_COOLDOWN));
                SoundUtils.playSound((class_1937)this.player.method_37908(), (class_2338)this.player.method_24515(), (class_3414)class_3417.field_14550, (class_3419)class_3419.field_15248, (float)0.5f, (float)0.85f);
                SoundUtils.playSound((class_1937)this.player.method_37908(), (class_2338)this.player.method_24515(), (class_3414)class_3417.field_59656, (class_3419)class_3419.field_15248, (float)0.5f, (float)0.8f);
                this.player.method_31549().method_7248(this.savedFlySpeed);
                ((class_3222)this.player).field_13987.method_14364((class_2596)new class_2696(this.player.method_31549()));
            }
            if (this.getAbilityCooldown(ArchetypeRegistry.SLOW_HOVER) == 0) {
                this.hoverTime = (float)Math.min((double)AncestralArchetypes.CONFIG.getInt(ArchetypeRegistry.SLOW_HOVER_FLIGHT_DURATION), (double)this.hoverTime + AncestralArchetypes.CONFIG.getDouble(ArchetypeRegistry.SLOW_HOVER_FLIGHT_RECOVERY_TIME));
            }
        }
        if (this.hoverTime < 0.0f) {
            this.hoverTime = 0.0f;
            this.setAbilityCooldown(ArchetypeRegistry.SLOW_HOVER, AncestralArchetypes.CONFIG.getInt(ArchetypeRegistry.SLOW_HOVER_FLIGHT_COOLDOWN));
        }
    }

    @Override
    public void resetAbilityCooldowns() {
        this.abilityCooldowns.forEach((ability, cooldown) -> this.abilityCooldowns.put((ArchetypeAbility)ability, new CooldownEntry(0)));
        this.glideTime = this.getMaxGlideTime();
        this.hoverTime = this.getMaxHoverTime();
        this.fortifyTime = this.getMaxFortifyTime();
    }

    @Override
    public void setPotionType(class_3545<class_1792, class_6880<class_1842>> pair) {
        this.potionBrewerStack = pair == null ? class_1799.field_8037 : class_1844.method_57400((class_1792)((class_1792)pair.method_15442()), (class_6880)((class_6880)pair.method_15441()));
    }

    @Override
    public void setMountEntity(ArchetypeAbility ability, UUID uuid) {
        class_3545<UUID, Float> prev = this.mountData.get(ability);
        if (prev != null) {
            this.mountData.put(ability, (class_3545<UUID, Float>)new class_3545((Object)uuid, (Object)((Float)prev.method_15441())));
        } else {
            this.mountData.put(ability, (class_3545<UUID, Float>)new class_3545((Object)uuid, (Object)Float.valueOf(0.0f)));
        }
    }

    @Override
    public void setMountHealth(ArchetypeAbility ability, float health) {
        class_3545<UUID, Float> prev = this.mountData.get(ability);
        if (prev != null) {
            this.mountData.put(ability, (class_3545<UUID, Float>)new class_3545((Object)((UUID)prev.method_15442()), (Object)Float.valueOf(health)));
        } else {
            this.mountData.put(ability, (class_3545<UUID, Float>)new class_3545(null, (Object)Float.valueOf(health)));
        }
    }

    @Override
    public void setMountName(String name) {
        this.mountName = name;
    }

    @Override
    public void setHorseVariant(class_5149 color, class_5148 marking) {
        this.horseMarking = marking;
        this.horseColor = color;
    }

    @Override
    public void setGliderColor(int color) {
        this.gliderColor = color;
    }

    @Override
    public void setHelmetColor(int color) {
        this.helmetColor = color;
    }

    @Override
    public void setGliderTrimMaterial(class_6880<class_8054> material) {
        this.gliderTrimMaterial = material;
    }

    @Override
    public void setHelmetTrimMaterial(class_6880<class_8054> material) {
        this.helmetTrimMaterial = material;
    }

    @Override
    public void changeArchetype(SubArchetype archetype) {
        this.setSubarchetype(archetype);
        this.giveItemsCooldown = 0;
        this.giveAbilityItems(true);
        this.archetypeChangesAllowed = Math.max(0, this.archetypeChangesAllowed - 1);
    }

    @Override
    public void increaseAllowedChanges(int num) {
        this.archetypeChangesAllowed = Math.max(0, this.archetypeChangesAllowed + num);
    }

    @Override
    public void setReminders(boolean reminders) {
        this.giveReminders = reminders;
    }

    @Override
    public void setHealthUpdate(float health) {
        if (health >= 0.0f) {
            this.healthUpdate = health;
        }
    }

    @Override
    public boolean giveAbilityItems(boolean shortCooldown) {
        if (this.giveItemsCooldown > 0) {
            return false;
        }
        List<ArchetypeAbility> abilities = this.getAbilities();
        class_1661 inv = this.player.method_31548();
        block0: for (ArchetypeAbility ability : abilities) {
            if (!ability.isActive()) continue;
            for (class_1792 item : ArchetypeRegistry.ITEMS) {
                if (!(item instanceof AbilityItem)) continue;
                AbilityItem abilityItem = (AbilityItem)item;
                if (!ability.equals(abilityItem.ability)) continue;
                boolean found = false;
                for (int i = 0; i < inv.method_5439(); ++i) {
                    class_1799 stack = inv.method_5438(i);
                    if (!stack.method_31574((class_1792)abilityItem)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                MinecraftUtils.giveStacks((class_1657)this.player, (class_1799[])new class_1799[]{new class_1799((class_1935)item)});
                continue block0;
            }
        }
        this.giveItemsCooldown = shortCooldown ? 100 : 1200;
        return true;
    }

    @Override
    public float getHealthUpdate() {
        return this.healthUpdate;
    }

    private static class CooldownEntry {
        private final int totalDuration;
        private int cooldown;

        public CooldownEntry(int duration) {
            this.totalDuration = duration;
            this.cooldown = duration;
        }

        private CooldownEntry(int cooldown, int totalDuration) {
            this.totalDuration = totalDuration;
            this.cooldown = cooldown;
        }

        public boolean isExpired() {
            return this.cooldown <= 0;
        }

        public boolean tick() {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            return this.isExpired();
        }

        public int getCooldown() {
            return this.cooldown;
        }

        public int getTotalDuration() {
            return this.totalDuration;
        }

        public float getPercentage() {
            if (this.totalDuration == 0) {
                return 0.0f;
            }
            return (float)this.cooldown / (float)this.totalDuration;
        }
    }
}

