/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.ancestralarchetypes.gui;

import com.mojang.authlib.GameProfile;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.borisshoes.ancestralarchetypes.AncestralArchetypes;
import net.borisshoes.ancestralarchetypes.Archetype;
import net.borisshoes.ancestralarchetypes.ArchetypeAbility;
import net.borisshoes.ancestralarchetypes.ArchetypeRegistry;
import net.borisshoes.ancestralarchetypes.SubArchetype;
import net.borisshoes.ancestralarchetypes.cca.IArchetypeProfile;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.gui.GuiHelper;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;

public class ArchetypeSelectionGui
extends SimpleGui {
    private final int[][] dynamicSlots = new int[][]{new int[0], {3}, {1, 5}, {1, 3, 5}, {0, 2, 4, 6}, {1, 2, 3, 4, 5}, {0, 1, 2, 4, 5, 6}, {0, 1, 2, 3, 4, 5, 6}};
    private final SubArchetype subArchetype;
    private final boolean showOnly;
    private boolean menuOnClose;
    private final HashMap<Integer, SubArchetype> map;
    private int page = 1;
    private final int numPages = Math.max(1, (int)Math.ceil((double)ArchetypeRegistry.ARCHETYPES.method_10204() / 7.0));

    public ArchetypeSelectionGui(class_3222 player, SubArchetype subArchetype, boolean showOnly) {
        super(ArchetypeSelectionGui.getScreenType(subArchetype), player, false);
        this.subArchetype = subArchetype;
        this.map = new HashMap();
        this.showOnly = showOnly;
        this.setTitle((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.gui_title"));
        if (this.subArchetype != null) {
            this.menuOnClose = true;
        }
        this.build();
    }

    private static class_3917<?> getScreenType(SubArchetype sub) {
        if (sub == null) {
            return class_3917.field_17327;
        }
        ArrayList<ArchetypeAbility> abilities = new ArrayList<ArchetypeAbility>();
        abilities.addAll(Arrays.asList(sub.getAbilities()));
        abilities.addAll(Arrays.asList(sub.getArchetype().getAbilities()));
        abilities.removeIf(a1 -> abilities.stream().anyMatch(a2 -> a2.overrides((ArchetypeAbility)a1)));
        int size = abilities.size();
        if (size <= 7) {
            return class_3917.field_17326;
        }
        if (size <= 14) {
            return class_3917.field_18666;
        }
        if (size <= 21) {
            return class_3917.field_18667;
        }
        return class_3917.field_17327;
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)this.player);
        if (this.subArchetype == null) {
            if (this.map.containsKey(index)) {
                ArchetypeSelectionGui gui = new ArchetypeSelectionGui(this.player, this.map.get(index), this.showOnly);
                gui.open();
            } else if (index == 4 && profile.getSubArchetype() != null && !this.showOnly) {
                profile.changeArchetype(null);
                this.close();
            }
        } else if (index == this.getSize() - 9 || index == 4) {
            this.close();
        } else if (index == this.getSize() - 5 && profile.getSubArchetype() != this.subArchetype && !this.showOnly) {
            profile.changeArchetype(this.subArchetype);
            this.menuOnClose = false;
            this.close();
        }
        return true;
    }

    public void build() {
        if (this.subArchetype == null) {
            this.buildMainMenu();
        } else {
            this.buildArchetypeMenu();
        }
    }

    private void buildArchetypeMenu() {
        IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)this.player);
        GuiHelper.outlineGUI((SimpleGui)this, (int)this.subArchetype.getColor(), (class_2561)class_2561.method_43473());
        GuiElementBuilder subArchetypeItem = GuiElementBuilder.from((class_1799)this.subArchetype.getDisplayItem()).hideDefaultTooltip();
        subArchetypeItem.setName((class_2561)this.subArchetype.getName().method_54663(this.subArchetype.getColor()));
        subArchetypeItem.addLoreLine((class_2561)this.subArchetype.getDescription().method_27692(TextUtils.getClosestFormatting((int)this.subArchetype.getColor())));
        this.setSlot(4, (GuiElementBuilderInterface)subArchetypeItem);
        ArrayList<ArchetypeAbility> abilities = new ArrayList<ArchetypeAbility>();
        abilities.addAll(Arrays.asList(this.subArchetype.getAbilities()));
        abilities.addAll(Arrays.asList(this.subArchetype.getArchetype().getAbilities()));
        abilities.removeIf(a1 -> abilities.stream().anyMatch(a2 -> a2.overrides((ArchetypeAbility)a1)));
        int rows = (int)Math.ceil((double)abilities.size() / 7.0);
        for (int i = 0; i < rows; ++i) {
            int j;
            int[] dynamicSlot = this.dynamicSlots[abilities.size() < 7 * (i + 1) ? abilities.size() - 7 * i : 7];
            for (j = 0; j < 7; ++j) {
                this.setSlot(1 + (9 * (i + 1) + j), (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)this.subArchetype.getColor())).hideTooltip());
            }
            for (j = 0; j < dynamicSlot.length; ++j) {
                int index = i * 7 + j;
                int offset = 1 + dynamicSlot[j];
                ArchetypeAbility ability = (ArchetypeAbility)abilities.get(index);
                GuiElementBuilder abilityItem = GuiElementBuilder.from((class_1799)ability.getDisplayStack()).hideDefaultTooltip();
                abilityItem.setName((class_2561)ability.getName().method_54663(this.subArchetype.getColor()));
                abilityItem.addLoreLine((class_2561)ability.getDescription().method_27692(TextUtils.getClosestFormatting((int)this.subArchetype.getColor())));
                this.setSlot((i + 1) * 9 + offset, (GuiElementBuilderInterface)abilityItem);
            }
        }
        if (!this.showOnly) {
            this.setSlot(this.getSize() - 5, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.CONFIRM)).hideDefaultTooltip().setName((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.confirm_selection").method_27692(class_124.field_1060)).addLoreLine((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.warning").method_27695(new class_124[]{class_124.field_1079, class_124.field_1056})));
        }
        this.setSlot(this.getSize() - 9, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.LEFT_ARROW)).hideDefaultTooltip().setName((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.return").method_27692(class_124.field_1065)));
    }

    private void buildMainMenu() {
        this.map.clear();
        IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)this.player);
        GuiHelper.outlineGUI((SimpleGui)this, (int)2147296, (class_2561)class_2561.method_43473());
        this.setSlot(18, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT_CONNECTOR, (int)2147296)).hideTooltip());
        this.setSlot(26, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_RIGHT_CONNECTOR, (int)2147296)).hideTooltip());
        GameProfile gameProfile = this.player.method_7334();
        GuiElementBuilder head = new GuiElementBuilder(class_1802.field_8575).setSkullOwner(gameProfile, this.player.method_5682());
        head.setName((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.gui_title").method_27692(class_124.field_1075));
        head.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43471((String)"text.ancestralarchetypes.gui_subtitle_1").method_27692(class_124.field_1062)));
        if (profile.getSubArchetype() != null && !this.showOnly) {
            head.addLoreLine((class_2561)class_2561.method_43473());
            head.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43471((String)"text.ancestralarchetypes.gui_subtitle_2").method_27692(class_124.field_1061)));
            head.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43471((String)"text.ancestralarchetypes.warning").method_27695(new class_124[]{class_124.field_1079, class_124.field_1056})));
        }
        this.setSlot(4, (GuiElementBuilderInterface)head);
        if (this.numPages > 1) {
            this.setSlot(45, (GuiElementBuilderInterface)this.createPrevPageItem());
            this.setSlot(53, (GuiElementBuilderInterface)this.createNextPageItem());
        }
        List<Archetype> archetypes = this.getArchetypesForPage(this.page);
        int[] dynamicSlot = this.dynamicSlots[archetypes.size()];
        for (int i = 0; i < dynamicSlot.length; ++i) {
            int offset = 1 + dynamicSlot[i];
            Archetype archetype = archetypes.get(i);
            GuiElementBuilder archetypeItem = GuiElementBuilder.from((class_1799)archetype.getDisplayItem()).hideDefaultTooltip();
            archetypeItem.setName((class_2561)archetype.getName().method_54663(archetype.getColor()));
            archetypeItem.addLoreLine((class_2561)archetype.getDescription().method_27692(TextUtils.getClosestFormatting((int)archetype.getColor())));
            this.setSlot(9 + offset, (GuiElementBuilderInterface)archetypeItem);
            this.setSlot(18 + offset, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_HORIZONTAL, (int)archetype.getColor())).hideTooltip());
            List<SubArchetype> subArchetypes = ArchetypeRegistry.SUBARCHETYPES.method_10220().filter(sub -> sub.getArchetype() == archetype).toList();
            for (int j = 0; j < 3; ++j) {
                GuiElementBuilder subArchetypeItem;
                if (j < subArchetypes.size()) {
                    SubArchetype subArchetype = subArchetypes.get(j);
                    subArchetypeItem = GuiElementBuilder.from((class_1799)subArchetype.getDisplayItem()).hideDefaultTooltip();
                    subArchetypeItem.setName((class_2561)subArchetype.getName().method_54663(subArchetype.getColor()));
                    subArchetypeItem.addLoreLine((class_2561)subArchetype.getDescription().method_27692(TextUtils.getClosestFormatting((int)subArchetype.getColor())));
                    subArchetypeItem.addLoreLine((class_2561)class_2561.method_43470((String)""));
                    subArchetypeItem.addLoreLine((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.gui_subtitle_1").method_27695(new class_124[]{class_124.field_1064, class_124.field_1056}));
                    this.map.put(27 + offset + 9 * j, subArchetype);
                } else {
                    subArchetypeItem = GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)archetype.getColor())).hideTooltip();
                }
                this.setSlot(27 + offset + 9 * j, (GuiElementBuilderInterface)subArchetypeItem);
            }
        }
    }

    private GuiElementBuilder createNextPageItem() {
        GuiElementBuilder nextPage = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.RIGHT_ARROW));
        nextPage.setName((class_2561)class_2561.method_43469((String)"gui.borislib.next_page_title", (Object[])new Object[]{this.page, this.numPages}).method_54663(class_124.field_1075.method_532().intValue()));
        nextPage.addLoreLine((class_2561)class_2561.method_43469((String)"text.borislib.two_elements", (Object[])new Object[]{class_2561.method_43471((String)"gui.borislib.click").method_54663(class_124.field_1060.method_532().intValue()), class_2561.method_43471((String)"gui.borislib.next_page_sub").method_54663(class_124.field_1062.method_532().intValue())}));
        nextPage.setCallback(clickType -> {
            if (this.page < this.numPages) {
                ++this.page;
                this.buildMainMenu();
            }
        });
        return nextPage;
    }

    private GuiElementBuilder createPrevPageItem() {
        GuiElementBuilder prevPage = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.LEFT_ARROW));
        prevPage.setName((class_2561)class_2561.method_43469((String)"gui.borislib.prev_page_title", (Object[])new Object[]{this.page, this.numPages}).method_54663(class_124.field_1075.method_532().intValue()));
        prevPage.addLoreLine((class_2561)class_2561.method_43469((String)"text.borislib.two_elements", (Object[])new Object[]{class_2561.method_43471((String)"gui.borislib.click").method_54663(class_124.field_1060.method_532().intValue()), class_2561.method_43471((String)"gui.borislib.prev_page_sub").method_54663(class_124.field_1062.method_532().intValue())}));
        prevPage.setCallback(clickType -> {
            if (this.page > 1) {
                --this.page;
                this.buildMainMenu();
            }
        });
        return prevPage;
    }

    private List<Archetype> getArchetypesForPage(int page) {
        int lastInd = Math.min(7 * page - 1, ArchetypeRegistry.ARCHETYPES.method_10204() - 1);
        int firstInd = Math.max(lastInd - 6, 0);
        ArrayList<Archetype> archetypes = new ArrayList<Archetype>();
        for (int i = firstInd; i <= lastInd; ++i) {
            archetypes.add((Archetype)ArchetypeRegistry.ARCHETYPES.method_10200(i));
        }
        return archetypes;
    }

    public void onClose() {
        if (this.menuOnClose) {
            ArchetypeSelectionGui gui = new ArchetypeSelectionGui(this.player, null, this.showOnly);
            gui.open();
        }
    }
}

