/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.ancestralarchetypes.gui;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.borisshoes.ancestralarchetypes.AncestralArchetypes;
import net.borisshoes.ancestralarchetypes.ArchetypeRegistry;
import net.borisshoes.ancestralarchetypes.cca.IArchetypeProfile;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.gui.GuiHelper;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_6880;

public class PotionSelectionGui
extends SimpleGui {
    private static final ArrayList<PotionEntry> POTIONS = new ArrayList<PotionEntry>(Arrays.asList(new PotionEntry(new class_3545((Object)class_1847.field_8987, (Object)0), new class_3545((Object)class_1847.field_8969, (Object)2)), new PotionEntry(new class_3545((Object)class_1847.field_8994, (Object)0), new class_3545((Object)class_1847.field_9001, (Object)1)), new PotionEntry(new class_3545((Object)class_1847.field_8968, (Object)0), new class_3545((Object)class_1847.field_8981, (Object)1)), new PotionEntry(new class_3545((Object)class_1847.field_8990, (Object)1), new class_3545((Object)class_1847.field_8988, (Object)3)), new PotionEntry(new class_3545((Object)class_1847.field_9005, (Object)0), new class_3545((Object)class_1847.field_8983, (Object)2)), new PotionEntry(new class_3545((Object)class_1847.field_8978, (Object)0), new class_3545((Object)class_1847.field_8965, (Object)2)), new PotionEntry(new class_3545((Object)class_1847.field_8979, (Object)0), new class_3545((Object)class_1847.field_8971, (Object)1)), new PotionEntry(new class_3545((Object)class_1847.field_8974, (Object)0), new class_3545((Object)class_1847.field_8964, (Object)1)), new PotionEntry(new class_3545((Object)class_1847.field_8986, (Object)0), new class_3545((Object)class_1847.field_9003, (Object)2)), new PotionEntry(new class_3545((Object)class_1847.field_8997, (Object)0), new class_3545((Object)class_1847.field_9000, (Object)1)), new PotionEntry(new class_3545((Object)class_1847.field_8977, (Object)4)), new PotionEntry(new class_3545((Object)class_1847.field_8966, (Object)2)), new PotionEntry(new class_3545((Object)class_1847.field_8993, (Object)2)), new PotionEntry(new class_3545((Object)class_1847.field_8998, (Object)1)), new PotionEntry(new class_3545((Object)class_1847.field_8963, (Object)0), new class_3545((Object)class_1847.field_8980, (Object)3)), new PotionEntry(true, new class_3545((Object)class_1847.field_8963, (Object)2), new class_3545((Object)class_1847.field_8980, (Object)4)), new PotionEntry(new class_3545((Object)class_1847.field_8991, (Object)0)), new PotionEntry(new class_3545((Object)class_1847.field_8996, (Object)0), new class_3545((Object)class_1847.field_8989, (Object)2)), new PotionEntry(new class_3545((Object)class_1847.field_8976, (Object)2)), new PotionEntry(new class_3545((Object)class_1847.field_8982, (Object)1), new class_3545((Object)class_1847.field_9002, (Object)3)), new PotionEntry(new class_3545((Object)class_1847.field_8972, (Object)2)), new PotionEntry(new class_3545((Object)class_1847.field_9004, (Object)1), new class_3545((Object)class_1847.field_8973, (Object)4)), new PotionEntry(true, new class_3545((Object)class_1847.field_9004, (Object)2), new class_3545((Object)class_1847.field_8973, (Object)4)), new PotionEntry(new class_3545((Object)class_1847.field_8975, (Object)0), new class_3545((Object)class_1847.field_8970, (Object)2)), new PotionEntry(new class_3545((Object)class_1847.field_50153, (Object)1)), new PotionEntry(new class_3545((Object)class_1847.field_50154, (Object)1)), new PotionEntry(new class_3545((Object)class_1847.field_50155, (Object)2)), new PotionEntry(new class_3545((Object)class_1847.field_50156, (Object)2))));
    private final HashMap<Integer, Integer> map;
    private boolean splash;

    public PotionSelectionGui(class_3222 player) {
        super(class_3917.field_17327, player, false);
        this.setTitle((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.potion_brewer_gui_title"));
        this.map = new HashMap();
        this.build();
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        if (this.map.containsKey(index)) {
            IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)this.player);
            long timeOfDay = this.player.method_51469().method_8532();
            int day = (int)(timeOfDay / 24000L % Integer.MAX_VALUE);
            int curPhase = day % 8;
            int moonLevel = profile.hasAbility(ArchetypeRegistry.MOONLIT_WITCH) ? Math.abs(-curPhase + 4) : 4;
            PotionEntry entry = POTIONS.get(this.map.get(index));
            class_6880<class_1842> potion = entry.getPotion(moonLevel);
            if (potion != null) {
                profile.setPotionType((class_3545<class_1792, class_6880<class_1842>>)new class_3545((Object)(entry.lingering() ? class_1802.field_8150 : (this.splash ? class_1802.field_8436 : class_1802.field_8574)), potion));
                SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_14978, (float)0.3f, (float)1.0f);
                this.close();
            } else {
                SoundUtils.playSongToPlayer((class_3222)this.player, (class_6880.class_6883)class_3417.field_14708, (float)1.0f, (float)0.5f);
            }
        } else if (index == 8) {
            this.splash = !this.splash;
            this.build();
        }
        return true;
    }

    public void build() {
        IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)this.player);
        this.map.clear();
        GuiHelper.outlineGUI((SimpleGui)this, (int)6493892, (class_2561)class_2561.method_43473());
        GuiElementBuilder potionTypeItem = GuiElementBuilder.from((class_1799)class_1844.method_57400((class_1792)(this.splash ? class_1802.field_8436 : class_1802.field_8574), (class_6880)class_1847.field_8963)).hideDefaultTooltip();
        potionTypeItem.setName((class_2561)class_2561.method_43471((String)(this.splash ? "item.minecraft.splash_potion" : "item.minecraft.potion")).method_27692(this.splash ? class_124.field_1075 : class_124.field_1060));
        potionTypeItem.addLoreLineRaw((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.potion_brewer_gui_toggle"));
        this.setSlot(8, (GuiElementBuilderInterface)potionTypeItem);
        long timeOfDay = this.player.method_51469().method_8532();
        int day = (int)(timeOfDay / 24000L % Integer.MAX_VALUE);
        int curPhase = day % 8;
        int moonLevel = profile.hasAbility(ArchetypeRegistry.MOONLIT_WITCH) ? Math.abs(-curPhase + 4) : 4;
        for (int i = 0; i < POTIONS.size(); ++i) {
            GuiElementBuilder potionItem;
            int row = i / 7;
            int slot = 10 + 9 * row + i % 7;
            PotionEntry entry = POTIONS.get(i);
            class_6880<class_1842> potion = entry.getPotion(moonLevel);
            if (potion != null) {
                potionItem = GuiElementBuilder.from((class_1799)class_1844.method_57400((class_1792)(entry.lingering() ? class_1802.field_8150 : (this.splash ? class_1802.field_8436 : class_1802.field_8574)), potion));
                potionItem.addLoreLineRaw((class_2561)class_2561.method_43470((String)""));
                potionItem.addLoreLineRaw((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.potion_brewer_gui_select").method_27692(class_124.field_1076));
                if (entry.getUpgradePhase(moonLevel) != 5) {
                    potionItem.addLoreLineRaw((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.potion_brewer_gui_upgrades").method_10852((class_2561)this.getTranslationForMoonPhase(entry.getUpgradePhase(moonLevel)).method_27692(class_124.field_1068)));
                }
            } else {
                potionItem = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)(entry.lingering() ? ArchetypeRegistry.LOCKED_LINGERING_POTION : (this.splash ? ArchetypeRegistry.LOCKED_SPLASH_POTION : ArchetypeRegistry.LOCKED_POTION)))).hideDefaultTooltip();
                potionItem.setName(class_1844.method_57400((class_1792)(entry.lingering() ? class_1802.field_8150 : (this.splash ? class_1802.field_8436 : class_1802.field_8574)), entry.getPotion(entry.getMinPhase())).method_7964());
                potionItem.addLoreLineRaw((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.potion_brewer_gui_locked").method_10852((class_2561)this.getTranslationForMoonPhase(entry.getMinPhase()).method_27692(class_124.field_1068)));
            }
            this.setSlot(slot, (GuiElementBuilderInterface)potionItem);
            this.map.put(slot, i);
        }
    }

    public static boolean isUnlocked(class_3222 player, class_6880<class_1842> potion) {
        if (potion == null) {
            return false;
        }
        IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)player);
        long timeOfDay = player.method_51469().method_8532();
        int day = (int)(timeOfDay / 24000L % Integer.MAX_VALUE);
        int curPhase = day % 8;
        int moonLevel = profile.hasAbility(ArchetypeRegistry.MOONLIT_WITCH) ? Math.abs(-curPhase + 4) : 4;
        for (PotionEntry entry : POTIONS) {
            for (class_3545<class_6880<class_1842>, Integer> pair : entry.potionLevels) {
                if (!((class_6880)pair.method_15442()).equals(potion) || moonLevel < (Integer)pair.method_15441()) continue;
                return true;
            }
        }
        return false;
    }

    private class_5250 getTranslationForMoonPhase(int moonPhase) {
        return switch (moonPhase) {
            case 0 -> class_2561.method_43471((String)"text.ancestralarchetypes.new_moon");
            case 1 -> class_2561.method_43471((String)"text.ancestralarchetypes.crescent_moon");
            case 2 -> class_2561.method_43471((String)"text.ancestralarchetypes.quarter_moon");
            case 3 -> class_2561.method_43471((String)"text.ancestralarchetypes.gibbous_moon");
            case 4 -> class_2561.method_43471((String)"text.ancestralarchetypes.full_moon");
            default -> throw new IllegalStateException("Unexpected value: " + moonPhase);
        };
    }

    private record PotionEntry(boolean lingering, class_3545<class_6880<class_1842>, Integer>[] potionLevels) {
        private PotionEntry(class_3545<class_6880<class_1842>, Integer> ... potionLevels) {
            this(false, potionLevels);
        }

        public class_6880<class_1842> getPotion(int moonLevel) {
            int maxPhase = -1;
            class_6880 potion = null;
            for (class_3545<class_6880<class_1842>, Integer> pair : this.potionLevels) {
                if (moonLevel < (Integer)pair.method_15441() || (Integer)pair.method_15441() <= maxPhase) continue;
                maxPhase = (Integer)pair.method_15441();
                potion = (class_6880)pair.method_15442();
            }
            return potion;
        }

        public int getMinPhase() {
            int minPhase = 5;
            for (class_3545<class_6880<class_1842>, Integer> pair : this.potionLevels) {
                if ((Integer)pair.method_15441() >= minPhase) continue;
                minPhase = (Integer)pair.method_15441();
            }
            return minPhase;
        }

        public int getUpgradePhase(int moonLevel) {
            int minPhase = 5;
            for (class_3545<class_6880<class_1842>, Integer> pair : this.potionLevels) {
                if (moonLevel >= (Integer)pair.method_15441() || (Integer)pair.method_15441() >= minPhase) continue;
                minPhase = (Integer)pair.method_15441();
            }
            return minPhase;
        }
    }
}

