/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.ancestralarchetypes.items;

import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.ancestralarchetypes.AncestralArchetypes;
import net.borisshoes.ancestralarchetypes.ArchetypeRegistry;
import net.borisshoes.ancestralarchetypes.cca.IArchetypeProfile;
import net.borisshoes.ancestralarchetypes.gui.BackpackGui;
import net.borisshoes.ancestralarchetypes.gui.BackpackSlot;
import net.borisshoes.ancestralarchetypes.items.AbilityItem;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import xyz.nucleoid.packettweaker.PacketContext;

public class BackpackItem
extends AbilityItem {
    public BackpackItem(class_1792.class_1793 settings) {
        super(ArchetypeRegistry.BACKPACK, "\ud83d\udcbc", settings);
    }

    public class_1792 getPolymerItem(class_1799 itemStack, PacketContext packetContext) {
        if (PolymerResourcePackUtils.hasMainPack((PacketContext)packetContext)) {
            return class_1802.field_8815;
        }
        return class_1802.field_54304;
    }

    public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
        class_1799 superStack = super.getPolymerItemStack(itemStack, tooltipType, context);
        class_3222 class_32222 = context.getPlayer();
        if (!(class_32222 instanceof class_3222)) {
            return superStack;
        }
        class_3222 player = class_32222;
        IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)player);
        if (!profile.hasAbility(this.ability)) {
            return superStack;
        }
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43471((String)"text.ancestralarchetypes.backpack_description").method_27695(new class_124[]{class_124.field_1064, class_124.field_1056}));
        lore.add(class_2561.method_43470((String)""));
        List<class_3545<class_1792, Integer>> cargo = this.getCargoList(player);
        int numDisplayed = 18;
        if (cargo.isEmpty()) {
            lore.add(class_2561.method_43471((String)"text.ancestralarchetypes.backpack_contents_empty").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}));
        } else {
            lore.add(class_2561.method_43471((String)"text.ancestralarchetypes.backpack_contents").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}));
            int leftOverCount = 0;
            for (int i = 0; i < cargo.size(); ++i) {
                int count = (Integer)cargo.get(i).method_15441();
                if (i >= 18) {
                    leftOverCount += count;
                    continue;
                }
                class_1792 item = (class_1792)cargo.get(i).method_15442();
                int stacks = count / item.method_7882();
                int leftover = count % item.method_7882();
                if (count > item.method_7882()) {
                    lore.add(class_2561.method_43469((String)"text.ancestralarchetypes.backpack_contents_stack", (Object[])new Object[]{class_2561.method_43470((String)("" + count)).method_54663(profile.getArchetype().getColor()), class_2561.method_43469((String)"text.ancestralarchetypes.stacks", (Object[])new Object[]{stacks}).method_54663(profile.getArchetype().getColor()), class_2561.method_43470((String)("" + leftover)).method_54663(profile.getArchetype().getColor()), item.method_63680().method_27661().method_54663(profile.getSubArchetype().getColor())}).method_27692(class_124.field_1064));
                    continue;
                }
                lore.add(class_2561.method_43469((String)"text.ancestralarchetypes.backpack_contents_item", (Object[])new Object[]{class_2561.method_43470((String)("" + count)).method_54663(profile.getArchetype().getColor()), item.method_63680().method_27661().method_54663(profile.getSubArchetype().getColor())}).method_27692(class_124.field_1064));
            }
            if (leftOverCount > 0) {
                lore.add(class_2561.method_43469((String)"text.ancestralarchetypes.backpack_contents_more", (Object[])new Object[]{class_2561.method_43470((String)("" + leftOverCount)).method_54663(profile.getArchetype().getColor()), class_2561.method_43470((String)("" + (cargo.size() - 18))).method_54663(profile.getArchetype().getColor())}).method_27692(class_124.field_1076));
            }
        }
        superStack.method_57379(class_9334.field_49632, (Object)new class_9290((List)lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new))));
        return superStack;
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!(user instanceof class_3222)) {
            return class_1269.field_5811;
        }
        class_3222 player = (class_3222)user;
        IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)player);
        if (profile.getAbilityCooldown(this.ability) > 0) {
            player.method_7353((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.ability_on_cooldown").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
            SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15102, (float)0.25f, (float)0.8f);
            return class_1269.field_5811;
        }
        BackpackGui gui = new BackpackGui(player, (class_1263)profile.getBackpackInventory());
        gui.open();
        AncestralArchetypes.profile((class_1657)player).setAbilityCooldown(this.ability, 10);
        return class_1269.field_5812;
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 user) {
        if (!(user instanceof class_3222)) {
            return false;
        }
        class_3222 player = (class_3222)user;
        IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)player);
        if (!profile.hasAbility(this.ability)) {
            return false;
        }
        class_1277 backpackInventory = profile.getBackpackInventory();
        class_1799 backpackStack = slot.method_7677();
        if (clickType == class_5536.field_27013 && !backpackStack.method_7960()) {
            class_1799 insertStack = slot.method_7677();
            if (!BackpackSlot.isValidItem(insertStack)) {
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_52372, (float)1.0f, (float)1.0f);
            } else {
                class_1799 remainder;
                int count = insertStack.method_7947();
                if (count == (remainder = backpackInventory.method_5491(insertStack)).method_7947()) {
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_52372, (float)1.0f, (float)1.0f);
                } else {
                    if (!remainder.method_7960()) {
                        insertStack.method_7939(remainder.method_7947());
                    } else {
                        insertStack.method_7939(0);
                    }
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_34376, (float)0.8f, (float)(0.8f + player.method_51469().method_8409().method_43057() * 0.4f));
                }
            }
            this.onContentChanged(player, stack);
            return true;
        }
        if (clickType == class_5536.field_27014 && backpackStack.method_7960()) {
            for (int i = backpackInventory.method_5439() - 1; i >= 0; --i) {
                class_1799 removeStack = backpackInventory.method_5438(i).method_7972();
                if (removeStack.method_7960()) continue;
                int count = removeStack.method_7947();
                class_1799 remainderStack = slot.method_32756(removeStack);
                if (remainderStack.method_7947() > 0) {
                    backpackInventory.method_5434(i, count - remainderStack.method_7947());
                    break;
                }
                backpackInventory.method_5441(i);
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_34377, (float)0.8f, (float)(0.8f + player.method_51469().method_8409().method_43057() * 0.4f));
                break;
            }
            this.onContentChanged(player, stack);
            return true;
        }
        return false;
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 user, class_5630 cursorStackReference) {
        if (!(user instanceof class_3222)) {
            return false;
        }
        class_3222 player = (class_3222)user;
        IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)player);
        if (!profile.hasAbility(this.ability)) {
            return false;
        }
        class_1277 backpackInventory = profile.getBackpackInventory();
        if (clickType == class_5536.field_27013 && otherStack.method_7960()) {
            return false;
        }
        if (clickType == class_5536.field_27013) {
            if (!BackpackSlot.isValidItem(otherStack)) {
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_52372, (float)1.0f, (float)1.0f);
            } else {
                class_1799 remainder;
                int count = otherStack.method_7947();
                if (count == (remainder = backpackInventory.method_5491(otherStack)).method_7947()) {
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_52372, (float)1.0f, (float)1.0f);
                } else {
                    if (!remainder.method_7960()) {
                        otherStack.method_7939(remainder.method_7947());
                    } else {
                        otherStack.method_7939(0);
                    }
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_34376, (float)0.8f, (float)(0.8f + player.method_51469().method_8409().method_43057() * 0.4f));
                }
            }
            this.onContentChanged(player, stack);
            return true;
        }
        if (clickType == class_5536.field_27014 && otherStack.method_7960()) {
            for (int i = backpackInventory.method_5439() - 1; i >= 0; --i) {
                class_1799 removeStack = backpackInventory.method_5438(i);
                if (removeStack.method_7960()) continue;
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_34377, (float)0.8f, (float)(0.8f + player.method_51469().method_8409().method_43057() * 0.4f));
                cursorStackReference.method_32332(backpackInventory.method_5441(i));
                break;
            }
            this.onContentChanged(player, stack);
            return true;
        }
        return false;
    }

    private void onContentChanged(class_3222 user, class_1799 stack) {
        class_1703 screenHandler = user.field_7512;
        if (screenHandler != null) {
            screenHandler.method_7609((class_1263)user.method_31548());
        }
    }

    private static class_3545<class_1263, class_1799> tryAddStackToInventory(class_1263 inventory, class_1799 stack) {
        int size = inventory.method_5439();
        ArrayList<class_1799> invList = new ArrayList<class_1799>(size);
        for (int i = 0; i < size; ++i) {
            class_1799 invStack = inventory.method_5438(i);
            invList.add(invStack);
        }
        for (class_1799 existingStack : invList) {
            boolean canCombine;
            int curCount = stack.method_7947();
            if (stack.method_7960()) break;
            boolean bl = canCombine = !existingStack.method_7960() && class_1799.method_31577((class_1799)existingStack, (class_1799)stack) && existingStack.method_7946() && existingStack.method_7947() < existingStack.method_7914();
            if (!canCombine) continue;
            int toAdd = Math.min(existingStack.method_7914() - existingStack.method_7947(), curCount);
            existingStack.method_7933(toAdd);
            stack.method_7939(curCount - toAdd);
        }
        int nonEmpty = (int)invList.stream().filter(s -> !s.method_7960()).count();
        if (!stack.method_7960() && nonEmpty < size) {
            if (nonEmpty == invList.size()) {
                invList.add(stack.method_51164());
            } else {
                for (int i = 0; i < nonEmpty; ++i) {
                    if (!((class_1799)invList.get(i)).method_7960()) continue;
                    invList.set(i, stack.method_51164());
                    break;
                }
            }
        }
        for (int i = 0; i < size; ++i) {
            inventory.method_5447(i, (class_1799)invList.get(i));
        }
        return new class_3545((Object)inventory, (Object)stack);
    }

    public List<class_3545<class_1792, Integer>> getCargoList(class_3222 player) {
        ArrayList<class_3545<class_1792, Integer>> list = new ArrayList<class_3545<class_1792, Integer>>();
        IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)player);
        if (!profile.hasAbility(this.ability)) {
            return list;
        }
        class_1277 backpackInventory = profile.getBackpackInventory();
        for (class_1799 stack : backpackInventory) {
            if (stack.method_7960()) continue;
            class_1792 item = stack.method_7909();
            boolean found = false;
            for (class_3545 class_35452 : list) {
                if (class_35452.method_15442() != item) continue;
                class_35452.method_34965((Object)((Integer)class_35452.method_15441() + stack.method_7947()));
                found = true;
                break;
            }
            if (found) continue;
            list.add((class_3545<class_1792, Integer>)new class_3545((Object)item, (Object)stack.method_7947()));
        }
        list.sort((pair1, pair2) -> ((Integer)pair2.method_15441()).compareTo((Integer)pair1.method_15441()));
        return list;
    }
}

