/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.ancestralarchetypes.items;

import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.util.List;
import java.util.Optional;
import net.borisshoes.ancestralarchetypes.AncestralArchetypes;
import net.borisshoes.ancestralarchetypes.ArchetypeRegistry;
import net.borisshoes.ancestralarchetypes.callbacks.DeglowTimerCallback;
import net.borisshoes.ancestralarchetypes.cca.IArchetypeProfile;
import net.borisshoes.ancestralarchetypes.entities.LevitationBulletEntity;
import net.borisshoes.ancestralarchetypes.events.BulletTargetEvent;
import net.borisshoes.ancestralarchetypes.items.AbilityItem;
import net.borisshoes.ancestralarchetypes.mixins.EntityAccessor;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.events.Event;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.MathUtils;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_2739;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import net.minecraft.class_5900;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class LevitationBulletItem
extends AbilityItem {
    public LevitationBulletItem(class_1792.class_1793 settings) {
        super(ArchetypeRegistry.LEVITATION_BULLET, "\u274b", settings);
    }

    public class_1792 getPolymerItem(class_1799 itemStack, PacketContext packetContext) {
        if (PolymerResourcePackUtils.hasMainPack((PacketContext)packetContext)) {
            return class_1802.field_8070;
        }
        return class_1802.field_8301;
    }

    @Override
    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
        class_1309 target;
        super.method_7888(stack, world, entity, slot);
        if (!(entity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)entity;
        IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)player);
        if (profile.getAbilityCooldown(this.ability) <= 0 && (slot == class_1304.field_6173 || slot == class_1304.field_6171) && (target = this.getTarget(world, player)) != null && player.method_5682().method_3780() % 4 == 0) {
            boolean shouldGlow = Event.getEventsOfType(BulletTargetEvent.class).stream().noneMatch(e -> e.player.method_5628() == player.method_5628() && e.target.method_5628() == target.method_5628());
            if (shouldGlow) {
                LevitationBulletItem.addGlow(player, target, class_124.field_1076);
                BorisLib.addTickTimerCallback((TickTimerCallback)new DeglowTimerCallback(player, target));
            }
            Event.addEvent((Event)new BulletTargetEvent(player, target));
        }
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!(user instanceof class_3222)) {
            return class_1269.field_5811;
        }
        class_3222 player = (class_3222)user;
        IArchetypeProfile profile = AncestralArchetypes.profile((class_1657)player);
        if (profile.getAbilityCooldown(this.ability) > 0) {
            player.method_7353((class_2561)class_2561.method_43471((String)"text.ancestralarchetypes.ability_on_cooldown").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
            SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15102, (float)0.25f, (float)0.8f);
            return class_1269.field_5811;
        }
        class_1309 target = this.getTarget(player.method_51469(), player);
        if (target != null) {
            for (int i = 0; i < AncestralArchetypes.CONFIG.getInt(ArchetypeRegistry.LEVITATION_BULLET_COUNT); ++i) {
                LevitationBulletEntity bullet = new LevitationBulletEntity((class_1937)player.method_51469(), (class_1309)player, (class_1297)target, class_2350.class_2351.method_16699((class_5819)player.method_59922()));
                bullet.method_33574(MathUtils.randomSpherePoint((class_243)player.method_33571().method_1031(0.0, 0.5, 0.0), (double)1.0));
                player.method_51469().method_8649((class_1297)bullet);
            }
            SoundUtils.playSound((class_1937)player.method_51469(), (class_2338)player.method_24515(), (class_3414)class_3417.field_15000, (class_3419)class_3419.field_15248, (float)2.0f, (float)((player.method_59922().method_43057() - player.method_59922().method_43057()) * 0.2f + 1.0f));
            AncestralArchetypes.profile((class_1657)player).setAbilityCooldown(this.ability, AncestralArchetypes.CONFIG.getInt(ArchetypeRegistry.LEVITATION_BULLET_COOLDOWN));
            player.field_13987.method_14364((class_2596)new class_2653(player.field_7498.field_7763, player.field_7498.method_37422(), player.method_6058() == class_1268.field_5808 ? 36 + player.method_31548().method_67532() : 45, player.method_5998(hand)));
            return class_1269.field_5812;
        }
        player.field_13987.method_14364((class_2596)new class_2653(player.field_7498.field_7763, player.field_7498.method_37422(), player.method_6058() == class_1268.field_5808 ? 36 + player.method_31548().method_67532() : 45, player.method_5998(hand)));
        return class_1269.field_5814;
    }

    private class_1309 getTarget(class_3218 world, class_3222 user) {
        int viewChunks;
        double maxRange;
        class_243 look;
        class_243 eye = user.method_33571();
        Optional<class_1309> entity = MinecraftUtils.lasercast((class_1937)world, (class_243)eye, (class_243)(look = user.method_5720().method_1029()), (double)(maxRange = (double)(viewChunks = world.method_8503().method_3760().method_14568()) * 16.0), (boolean)false, (class_1297)user).sortedHits().stream().filter(e -> e instanceof class_1309 && eye.method_1025(e.method_19538()) <= maxRange * maxRange).map(e -> (class_1309)e).findFirst();
        if (entity.isPresent()) {
            return entity.get();
        }
        double maxAngleDeg = 5.0;
        double bestScore = Double.POSITIVE_INFINITY;
        class_1309 best = null;
        class_238 search = new class_238(eye, eye).method_1014(maxRange);
        for (class_1309 e2 : world.method_8390(class_1309.class, search, le -> le.method_5805() && le != user && !le.method_7325())) {
            double score;
            class_243 targetEye = e2.method_33571();
            class_243 to = targetEye.method_1020(eye);
            double dist = to.method_1033();
            if (dist <= 1.0E-6 || dist > maxRange) continue;
            class_243 dir = to.method_1021(1.0 / dist);
            double dot = look.method_1026(dir);
            double angleDeg = Math.toDegrees(Math.acos(dot = Math.max(-1.0, Math.min(1.0, dot))));
            if (angleDeg > maxAngleDeg || !this.hasLineOfSight(world, (class_1297)user, eye, targetEye) || !((score = angleDeg + dist / 25.0) < bestScore)) continue;
            bestScore = score;
            best = e2;
        }
        return best;
    }

    private boolean hasLineOfSight(class_3218 world, class_1297 viewer, class_243 from, class_243 to) {
        class_3965 hit = world.method_17742(new class_3959(from, to, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, viewer));
        return hit.method_17783() == class_239.class_240.field_1333;
    }

    private static void addGlow(class_3222 viewer, class_1309 target, class_124 color) {
        String teamName = "glow_" + viewer.method_5845() + "_" + target.method_5628();
        class_268 team = new class_268(new class_269(), teamName);
        team.method_1141(color);
        team.method_1135(true);
        team.method_1143(false);
        team.method_1204().add(target.method_5820());
        byte flags = (Byte)target.method_5841().method_12789(EntityAccessor.getFLAGS());
        byte glowing = (byte)(flags | 0x40);
        List<class_2945.class_7834> entries = List.of(class_2945.class_7834.method_46360(EntityAccessor.getFLAGS(), (Object)glowing));
        viewer.field_13987.method_14364((class_2596)new class_2739(target.method_5628(), entries));
        viewer.field_13987.method_14364((class_2596)class_5900.method_34172((class_268)team, (boolean)true));
    }

    public static void removeGlow(class_3222 viewer, class_1309 target) {
        String teamName = "glow_" + viewer.method_5845() + "_" + target.method_5628();
        class_268 team = new class_268(new class_269(), teamName);
        byte flags = (Byte)target.method_5841().method_12789(EntityAccessor.getFLAGS());
        viewer.field_13987.method_14364((class_2596)class_5900.method_34170((class_268)team));
        viewer.field_13987.method_14364((class_2596)new class_2739(target.method_5628(), List.of(class_2945.class_7834.method_46360(EntityAccessor.getFLAGS(), (Object)flags))));
    }
}

