/*
 * Decompiled with CFR 0.152.
 */
package me.bhojaraju.epicneeds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.bhojaraju.epicneeds.DataManager;
import me.bhojaraju.epicneeds.PlayerListener;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandHandler
implements CommandExecutor,
TabCompleter {
    private static final Map<UUID, UUID> tpaRequests = new HashMap<UUID, UUID>();
    private static final Map<UUID, Long> tpaTimestamps = new HashMap<UUID, Long>();
    private static final Map<UUID, UUID> lastMsg = new HashMap<UUID, UUID>();
    private static PlayerListener listener;
    private static final String PREFIX = "\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r";

    public static void register(Plugin plugin) {
        CommandHandler commandHandler = new CommandHandler();
        listener = new PlayerListener();
        for (String string : Arrays.asList("sethome", "home", "setspawn", "spawn", "setwarp", "warp", "tpa", "tpaccept", "tpdeny", "msg", "reply", "back", "nick", "realname", "afk", "clearchat", "gm", "gmc", "gms", "gma", "gmsp", "fly", "day", "night", "sun", "rain", "storm", "god")) {
            PluginCommand pluginCommand = ((JavaPlugin)plugin).getCommand(string);
            if (pluginCommand == null) continue;
            pluginCommand.setExecutor((CommandExecutor)commandHandler);
            pluginCommand.setTabCompleter((TabCompleter)commandHandler);
        }
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7cPlayer only command.");
            return true;
        }
        Player player = (Player)commandSender;
        String string2 = command.getName().toLowerCase();
        Location location = player.getLocation();
        try {
            switch (string2) {
                case "sethome": {
                    if (!this.checkPerm(player, "epicneeds.sethome")) {
                        return true;
                    }
                    DataManager.get("homes").set(player.getUniqueId().toString(), (Object)location);
                    DataManager.save("homes");
                    player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7aHome set!");
                    break;
                }
                case "home": {
                    if (!this.checkPerm(player, "epicneeds.home")) {
                        return true;
                    }
                    Location location2 = (Location)DataManager.get("homes").get(player.getUniqueId().toString());
                    if (location2 != null) {
                        player.teleport(location2);
                        break;
                    }
                    player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7cNo home set.");
                    break;
                }
                case "setspawn": {
                    if (!this.checkPerm(player, "epicneeds.setspawn")) {
                        return true;
                    }
                    DataManager.get("spawn").set("spawn", (Object)location);
                    DataManager.save("spawn");
                    player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7aSpawn set.");
                    break;
                }
                case "spawn": {
                    if (!this.checkPerm(player, "epicneeds.spawn")) {
                        return true;
                    }
                    Location location3 = (Location)DataManager.get("spawn").get("spawn");
                    if (location3 != null) {
                        player.teleport(location3);
                        break;
                    }
                    player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7cNo spawn set.");
                    break;
                }
                case "setwarp": {
                    if (!this.checkPerm(player, "epicneeds.setwarp")) {
                        return true;
                    }
                    if (stringArray.length == 0) {
                        return this.error(player, "Usage: /setwarp <name>");
                    }
                    DataManager.get("warps").set(stringArray[0].toLowerCase(), (Object)location);
                    DataManager.save("warps");
                    player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7aWarp \u00a7e" + stringArray[0] + " \u00a7aset.");
                    break;
                }
                case "warp": {
                    if (!this.checkPerm(player, "epicneeds.warp")) {
                        return true;
                    }
                    if (stringArray.length == 0) {
                        return this.error(player, "Usage: /warp <name>");
                    }
                    Location location4 = (Location)DataManager.get("warps").get(stringArray[0].toLowerCase());
                    if (location4 != null) {
                        player.teleport(location4);
                        break;
                    }
                    player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7cWarp not found.");
                    break;
                }
                case "tpa": {
                    if (!this.checkPerm(player, "epicneeds.tpa")) {
                        return true;
                    }
                    if (stringArray.length == 0) {
                        return this.error(player, "Usage: /tpa <player>");
                    }
                    Player player2 = Bukkit.getPlayerExact((String)stringArray[0]);
                    if (player2 != null && !player2.equals((Object)player)) {
                        tpaRequests.put(player2.getUniqueId(), player.getUniqueId());
                        tpaTimestamps.put(player2.getUniqueId(), System.currentTimeMillis());
                        player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7aTPA request sent to \u00a7e" + player2.getName());
                        player2.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7e" + player.getName() + " wants to teleport to you. Use \u00a7a/tpaccept \u00a7eor \u00a7c/tpdeny.");
                        break;
                    }
                    player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7cPlayer not found.");
                    break;
                }
                case "tpaccept": {
                    if (!this.checkPerm(player, "epicneeds.tpaccept")) {
                        return true;
                    }
                    UUID uUID = tpaRequests.get(player.getUniqueId());
                    if (uUID != null && System.currentTimeMillis() - tpaTimestamps.get(player.getUniqueId()) < 30000L) {
                        Player player3 = Bukkit.getPlayer((UUID)uUID);
                        if (player3 != null) {
                            player3.teleport((Entity)player);
                        }
                        player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7aTeleport accepted.");
                        break;
                    }
                    player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7cNo TPA request.");
                    break;
                }
                case "tpdeny": {
                    if (!this.checkPerm(player, "epicneeds.tpdeny")) {
                        return true;
                    }
                    if (tpaRequests.containsKey(player.getUniqueId())) {
                        tpaRequests.remove(player.getUniqueId());
                        player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7cTPA request denied.");
                        break;
                    }
                    player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7cNo TPA request.");
                    break;
                }
                case "msg": {
                    if (!this.checkPerm(player, "epicneeds.msg")) {
                        return true;
                    }
                    if (stringArray.length < 2) {
                        return this.error(player, "Usage: /msg <player> <message>");
                    }
                    Player player4 = Bukkit.getPlayerExact((String)stringArray[0]);
                    if (player4 != null) {
                        String string3 = String.join((CharSequence)" ", Arrays.copyOfRange(stringArray, 1, stringArray.length));
                        player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a77[To " + player4.getName() + "] \u00a7f" + string3);
                        player4.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a77[From " + player.getName() + "] \u00a7f" + string3);
                        lastMsg.put(player.getUniqueId(), player4.getUniqueId());
                        lastMsg.put(player4.getUniqueId(), player.getUniqueId());
                        break;
                    }
                    player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7cPlayer not found.");
                    break;
                }
                case "reply": {
                    if (!this.checkPerm(player, "epicneeds.reply")) {
                        return true;
                    }
                    if (stringArray.length < 1) {
                        return this.error(player, "Usage: /reply <message>");
                    }
                    UUID uUID = lastMsg.get(player.getUniqueId());
                    if (uUID != null) {
                        Player player5 = Bukkit.getPlayer((UUID)uUID);
                        if (player5 != null) {
                            String string4 = String.join((CharSequence)" ", stringArray);
                            player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a77[To " + player5.getName() + "] \u00a7f" + string4);
                            player5.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a77[From " + player.getName() + "] \u00a7f" + string4);
                            break;
                        }
                        player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7cPlayer not found.");
                        break;
                    }
                    player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7cNo one to reply to.");
                    break;
                }
                case "back": {
                    if (!this.checkPerm(player, "epicneeds.back")) {
                        return true;
                    }
                    Location location5 = listener.getBackLocation(player);
                    if (location5 != null) {
                        player.teleport(location5);
                        break;
                    }
                    player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7cNo previous location.");
                    break;
                }
                case "nick": {
                    if (!this.checkPerm(player, "epicneeds.nick")) {
                        return true;
                    }
                    if (stringArray.length == 0) {
                        return this.error(player, "Usage: /nick <name>");
                    }
                    player.setDisplayName(stringArray[0]);
                    DataManager.get("nicks").set(player.getUniqueId().toString(), (Object)stringArray[0]);
                    DataManager.save("nicks");
                    player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7aNickname set to \u00a7e" + stringArray[0]);
                    break;
                }
                case "realname": {
                    if (!this.checkPerm(player, "epicneeds.realname")) {
                        return true;
                    }
                    if (stringArray.length == 0) {
                        return this.error(player, "Usage: /realname <nickname>");
                    }
                    for (Player player6 : Bukkit.getOnlinePlayers()) {
                        if (!player6.getDisplayName().equalsIgnoreCase(stringArray[0])) continue;
                        player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7aReal name: \u00a7e" + player6.getName());
                        return true;
                    }
                    player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7cNickname not found.");
                    break;
                }
                case "afk": {
                    if (!this.checkPerm(player, "epicneeds.afk")) {
                        return true;
                    }
                    listener.toggleAFK(player);
                    break;
                }
                case "clearchat": {
                    if (!this.checkPerm(player, "epicneeds.clearchat")) {
                        return true;
                    }
                    for (int i = 0; i < 100; ++i) {
                        Bukkit.broadcastMessage((String)"");
                    }
                    Bukkit.broadcastMessage((String)("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7aChat cleared by \u00a7e" + player.getName()));
                    break;
                }
                case "gm": 
                case "gmc": 
                case "gms": 
                case "gma": 
                case "gmsp": {
                    GameMode gameMode;
                    if (!this.checkPerm(player, "epicneeds.gamemode")) {
                        return true;
                    }
                    switch (string2) {
                        case "gmc": {
                            GameMode gameMode2 = GameMode.CREATIVE;
                            break;
                        }
                        case "gms": {
                            GameMode gameMode2 = GameMode.SURVIVAL;
                            break;
                        }
                        case "gma": {
                            GameMode gameMode2 = GameMode.ADVENTURE;
                            break;
                        }
                        case "gmsp": {
                            GameMode gameMode2 = GameMode.SPECTATOR;
                            break;
                        }
                        case "gm": {
                            GameMode gameMode2;
                            if (stringArray.length > 0) {
                                gameMode2 = GameMode.getByValue((int)Integer.parseInt(stringArray[0]));
                                break;
                            }
                            gameMode2 = null;
                            break;
                        }
                        default: {
                            GameMode gameMode2 = gameMode = null;
                        }
                    }
                    if (gameMode != null) {
                        player.setGameMode(gameMode);
                        player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7aGamemode set to \u00a7e" + gameMode.name());
                        break;
                    }
                    player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7cInvalid gamemode.");
                    break;
                }
                case "fly": {
                    if (!this.checkPerm(player, "epicneeds.fly")) {
                        return true;
                    }
                    boolean bl = !player.getAllowFlight();
                    player.setAllowFlight(bl);
                    player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7aFlight " + (bl ? "\u00a7aenabled" : "\u00a7cdisabled"));
                    break;
                }
                case "day": 
                case "night": 
                case "sun": 
                case "rain": 
                case "storm": {
                    if (!this.checkPerm(player, "epicneeds.weather")) {
                        return true;
                    }
                    World world = player.getWorld();
                    switch (string2) {
                        case "day": {
                            world.setTime(1000L);
                            break;
                        }
                        case "night": {
                            world.setTime(13000L);
                            break;
                        }
                        case "sun": {
                            world.setStorm(false);
                            world.setThundering(false);
                            break;
                        }
                        case "rain": {
                            world.setStorm(true);
                            break;
                        }
                        case "storm": {
                            world.setThundering(true);
                        }
                    }
                    player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7aTime/Weather updated.");
                    break;
                }
                case "god": {
                    if (!this.checkPerm(player, "epicneeds.god")) {
                        return true;
                    }
                    boolean bl = !player.isInvulnerable();
                    player.setInvulnerable(bl);
                    player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7aGod mode " + (bl ? "\u00a7aenabled" : "\u00a7cdisabled"));
                }
            }
        }
        catch (Exception exception) {
            player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7cError: " + exception.getMessage());
        }
        return true;
    }

    private boolean checkPerm(Player player, String string) {
        if (!player.hasPermission(string)) {
            player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7cYou don't have permission.");
            return false;
        }
        return true;
    }

    private boolean error(Player player, String string) {
        player.sendMessage("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7c" + string);
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (command.getName().equalsIgnoreCase("warp") || command.getName().equalsIgnoreCase("setwarp")) {
            return new ArrayList<String>(DataManager.get("warps").getKeys(false));
        }
        return null;
    }
}

