/*
 * Decompiled with CFR 0.152.
 */
package me.bhojaraju.epicneeds;

import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class PlayerListener
implements Listener {
    private static final String PREFIX = "\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r";
    private final HashMap<UUID, Boolean> isAfk = new HashMap();
    private final HashMap<UUID, Location> backLocations = new HashMap();

    @EventHandler
    public void onDeath(PlayerDeathEvent playerDeathEvent) {
        Player player = playerDeathEvent.getEntity();
        this.backLocations.put(player.getUniqueId(), player.getLocation());
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent playerTeleportEvent) {
        Player player = playerTeleportEvent.getPlayer();
        if (player.hasPermission("epicneeds.back")) {
            this.backLocations.put(player.getUniqueId(), player.getLocation());
        }
    }

    public Location getBackLocation(Player player) {
        return this.backLocations.get(player.getUniqueId());
    }

    @EventHandler
    public void onMove(PlayerMoveEvent playerMoveEvent) {
        Player player = playerMoveEvent.getPlayer();
        if ((playerMoveEvent.getFrom().getX() != playerMoveEvent.getTo().getX() || playerMoveEvent.getFrom().getY() != playerMoveEvent.getTo().getY() || playerMoveEvent.getFrom().getZ() != playerMoveEvent.getTo().getZ()) && this.isAfk.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            this.isAfk.put(player.getUniqueId(), false);
            Bukkit.broadcastMessage((String)("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7e" + player.getName() + " \u00a7ais no longer AFK."));
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        Player player = asyncPlayerChatEvent.getPlayer();
        if (this.isAfk.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            this.isAfk.put(player.getUniqueId(), false);
            Bukkit.broadcastMessage((String)("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7e" + player.getName() + " \u00a7ais no longer AFK."));
        }
    }

    public void toggleAFK(Player player) {
        boolean bl = this.isAfk.getOrDefault(player.getUniqueId(), false);
        if (bl) {
            this.isAfk.put(player.getUniqueId(), false);
            Bukkit.broadcastMessage((String)("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7e" + player.getName() + " \u00a7ais no longer AFK."));
        } else {
            this.isAfk.put(player.getUniqueId(), true);
            Bukkit.broadcastMessage((String)("\u00a78[\u00a7bEpicNeeds\u00a78] \u00a7r\u00a7e" + player.getName() + " \u00a77is now \u00a7cAFK\u00a77."));
        }
    }

    public void setBackLocation(Player player, Location location) {
        this.backLocations.put(player.getUniqueId(), location);
    }
}

