/*
 * Decompiled with CFR 0.152.
 */
package mc.algrim.fabric.chat.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mc.algrim.fabric.chat.components.LiteralPatternPart;
import mc.algrim.fabric.chat.components.PatternPart;
import mc.algrim.fabric.chat.components.RegexPatternPart;
import mc.algrim.fabric.chat.components.StylePatternPart;
import net.minecraft.class_2583;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ)\u0010\u000f\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0011\u0010\nR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lmc/algrim/fabric/chat/components/Pattern;", "", "", "Lmc/algrim/fabric/chat/components/PatternPart;", "parts", "<init>", "([Lmc/algrim/fabric/chat/components/PatternPart;)V", "", "content", "applyTransforms", "(Ljava/lang/String;)Ljava/lang/String;", "messageContent", "Lkotlin/Pair;", "", "Lnet/minecraft/class_2583;", "toCharStylePair", "(Ljava/lang/String;)[Lkotlin/Pair;", "applyStyles", "[Lmc/algrim/fabric/chat/components/PatternPart;", "getParts", "()[Lmc/algrim/fabric/chat/components/PatternPart;", "Companion", "algrim-chat"})
@SourceDebugExtension(value={"SMAP\nPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pattern.kt\nmc/algrim/fabric/chat/components/Pattern\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,103:1\n37#2,2:104\n*S KotlinDebug\n*F\n+ 1 Pattern.kt\nmc/algrim/fabric/chat/components/Pattern\n*L\n51#1:104,2\n*E\n"})
public final class Pattern {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PatternPart[] parts;

    public Pattern(@NotNull PatternPart[] parts) {
        Intrinsics.checkNotNullParameter((Object)parts, (String)"parts");
        this.parts = parts;
    }

    @NotNull
    public final PatternPart[] getParts() {
        return this.parts;
    }

    @Nullable
    public final String applyTransforms(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        int i = 0;
        StringBuilder transformedPattern = new StringBuilder();
        for (PatternPart part : this.parts) {
            String transformedPart = part.apply(content, i);
            if (transformedPart == null) {
                return null;
            }
            transformedPattern.append(transformedPart);
            i = transformedPart.length();
        }
        return transformedPattern.toString();
    }

    @Nullable
    public final Pair<Character, class_2583>[] toCharStylePair(@NotNull String messageContent) {
        Intrinsics.checkNotNullParameter((Object)messageContent, (String)"messageContent");
        ArrayList charStylePairs = new ArrayList(messageContent.length());
        int i = 0;
        for (PatternPart part : this.parts) {
            Object[] p;
            if (part.toCharStylePair(messageContent, i) == null) {
                return null;
            }
            CollectionsKt.addAll((Collection)charStylePairs, (Object[])p);
            i += p.length;
        }
        Collection $this$toTypedArray$iv = charStylePairs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Pair[0]);
    }

    @Nullable
    public final String applyStyles(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        int i = 0;
        StringBuilder transformedPattern = new StringBuilder();
        for (PatternPart part : this.parts) {
            String transformedPart = part.apply(content, i);
            if (transformedPart == null) {
                return null;
            }
            transformedPattern.append(transformedPart);
            i = transformedPart.length();
        }
        return transformedPattern.toString();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lmc/algrim/fabric/chat/components/Pattern$Companion;", "", "<init>", "()V", "", "patternString", "Lmc/algrim/fabric/chat/components/Pattern;", "fromString", "(Ljava/lang/String;)Lmc/algrim/fabric/chat/components/Pattern;", "algrim-chat"})
    @SourceDebugExtension(value={"SMAP\nPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pattern.kt\nmc/algrim/fabric/chat/components/Pattern$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,103:1\n37#2,2:104\n*S KotlinDebug\n*F\n+ 1 Pattern.kt\nmc/algrim/fabric/chat/components/Pattern$Companion\n*L\n99#1:104,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern fromString(@NotNull String patternString) {
            Intrinsics.checkNotNullParameter((Object)patternString, (String)"patternString");
            List parts = new ArrayList();
            int i = 0;
            int loopCount = 0;
            while (i < patternString.length()) {
                boolean escaped;
                if (++loopCount > 2500) {
                    throw new IllegalArgumentException("Pattern has exceeded the maximum number of iterations");
                }
                char c = patternString.charAt(i);
                boolean bl = i > 0 ? patternString.charAt(i - 1) == '\\' : (escaped = false);
                if (!escaped) {
                    PatternPart patternPart;
                    char c2 = c;
                    if (c2 == StylePatternPart.Companion.getOpenChar().charValue()) {
                        patternPart = new StylePatternPart(patternString, i);
                    } else if (c2 == RegexPatternPart.Companion.getOpenChar().charValue()) {
                        patternPart = new RegexPatternPart(patternString, i);
                    } else {
                        char[] cArray = new char[]{StylePatternPart.Companion.getOpenChar().charValue(), RegexPatternPart.Companion.getOpenChar().charValue()};
                        patternPart = new LiteralPatternPart(patternString, i, cArray);
                    }
                    PatternPart part = patternPart;
                    parts.add(part);
                    if (part.getLength() == 0) {
                        ++i;
                        continue;
                    }
                    i += part.getLength();
                    continue;
                }
                ++i;
            }
            Collection $this$toTypedArray$iv = parts;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return new Pattern(thisCollection$iv.toArray(new PatternPart[0]));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

