/*
 * Decompiled with CFR 0.152.
 */
package mc.algrim.fabric.chat.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import mc.algrim.fabric.chat.components.PatternPart;
import net.minecraft.class_2583;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 %2\u00020\u0001:\u0001%B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ3\u0010\u0014\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0016\u001a\u0004\b\u001d\u0010\u0018R\u001a\u0010\u001e\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0019\u001a\u0004\b\u001f\u0010\u001bR\u0017\u0010!\u001a\u00020 8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\u00a8\u0006&"}, d2={"Lmc/algrim/fabric/chat/components/RegexPatternPart;", "Lmc/algrim/fabric/chat/components/PatternPart;", "", "pattern", "", "index", "<init>", "(Ljava/lang/String;I)V", "string", "", "matches", "(Ljava/lang/String;)Z", "messageContent", "startIndex", "apply", "(Ljava/lang/String;I)Ljava/lang/String;", "", "Lkotlin/Pair;", "", "Lnet/minecraft/class_2583;", "toCharStylePair", "(Ljava/lang/String;I)[Lkotlin/Pair;", "Ljava/lang/String;", "getPattern", "()Ljava/lang/String;", "I", "getIndex", "()I", "value", "getValue", "length", "getLength", "Lkotlin/text/Regex;", "regex", "Lkotlin/text/Regex;", "getRegex", "()Lkotlin/text/Regex;", "Companion", "algrim-chat"})
@SourceDebugExtension(value={"SMAP\nRegexPatternPart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegexPatternPart.kt\nmc/algrim/fabric/chat/components/RegexPatternPart\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,73:1\n975#2:74\n1046#2,3:75\n37#3,2:78\n*S KotlinDebug\n*F\n+ 1 RegexPatternPart.kt\nmc/algrim/fabric/chat/components/RegexPatternPart\n*L\n65#1:74\n65#1:75,3\n65#1:78,2\n*E\n"})
public final class RegexPatternPart
implements PatternPart {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pattern;
    private final int index;
    @NotNull
    private final String value;
    private final int length;
    @NotNull
    private final Regex regex;
    private static final char openChar = (char)47;
    private static final char closeChar = (char)47;

    public RegexPatternPart(@NotNull String pattern, int index) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.pattern = pattern;
        this.index = index;
        String string = this.getPattern().substring(this.getIndex());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String remainder = string;
        int partLength = 0;
        if (remainder.length() < 2) {
            throw new IllegalArgumentException("Pattern '" + this.getPattern() + "', is invalid. Unexpected end of pattern.");
        }
        char[] cArray = remainder.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] cArray2 = cArray;
        int n = cArray2.length;
        for (int i = 0; i < n; ++i) {
            boolean escaped;
            int i2 = i;
            char c = cArray2[i];
            if (i2 == 0) {
                if (c == openChar) continue;
                throw new IllegalArgumentException("Pattern '" + this.getPattern() + "', invalid open char, should be '" + openChar + "'");
            }
            boolean bl = i2 > 0 ? remainder.charAt(i2 - 1) == '\\' : (escaped = false);
            if (!escaped && c == closeChar) {
                partLength = i2 + 1;
                break;
            }
            if (i2 != remainder.length() - 1) continue;
            throw new IllegalArgumentException("Pattern '" + this.getPattern() + "', is invalid. Unexpected end of pattern.");
        }
        this.length = partLength;
        String string2 = remainder.substring(1, this.getLength() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        this.value = string2;
        this.regex = new Regex(this.getValue());
    }

    @Override
    @NotNull
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    @NotNull
    public String getValue() {
        return this.value;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @NotNull
    public final Regex getRegex() {
        return this.regex;
    }

    @Override
    public boolean matches(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        CharSequence charSequence = this.getPattern();
        return this.regex.matches(charSequence);
    }

    @Override
    @Nullable
    public String apply(@NotNull String messageContent, int startIndex) {
        MatchResult rx;
        Intrinsics.checkNotNullParameter((Object)messageContent, (String)"messageContent");
        MatchResult matchResult = rx = this.regex.matchAt((CharSequence)messageContent, startIndex);
        return matchResult != null ? matchResult.getValue() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Pair<Character, class_2583>[] toCharStylePair(@NotNull String messageContent, int startIndex) {
        Pair[] pairArray;
        Intrinsics.checkNotNullParameter((Object)messageContent, (String)"messageContent");
        String string = this.apply(messageContent, startIndex);
        if (string != null) {
            void $this$mapTo$iv$iv;
            CharSequence $this$map$iv = string;
            boolean $i$f$map = false;
            CharSequence charSequence = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length());
            boolean $i$f$mapTo = false;
            for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
                void it;
                char item$iv$iv;
                char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)Character.valueOf((char)it), (Object)class_2583.field_24360));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            pairArray = thisCollection$iv.toArray(new Pair[0]);
        } else {
            pairArray = null;
        }
        return pairArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u00048\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lmc/algrim/fabric/chat/components/RegexPatternPart$Companion;", "Lmc/algrim/fabric/chat/components/PatternPart$Delimiters;", "<init>", "()V", "", "openChar", "C", "getOpenChar", "()Ljava/lang/Character;", "closeChar", "getCloseChar", "algrim-chat"})
    public static final class Companion
    implements PatternPart.Delimiters {
        private Companion() {
        }

        @Override
        @NotNull
        public Character getOpenChar() {
            return Character.valueOf(openChar);
        }

        @Override
        @NotNull
        public Character getCloseChar() {
            return Character.valueOf(closeChar);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

